/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.setvalueconstant;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.setvalueconstant.SetValueConstant;
import org.pentaho.di.trans.steps.setvalueconstant.SetValueConstantData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SetValueConstantMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SetValueConstantMeta.class;
    private String[] fieldName;
    private String[] replaceValue;
    private String[] replaceMask;
    private boolean[] setEmptyString;
    private boolean usevar;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        SetValueConstantMeta retval = (SetValueConstantMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.replaceValue[i] = this.replaceValue[i];
            retval.replaceMask[i] = this.replaceMask[i];
            retval.setEmptyString[i] = this.setEmptyString[i];
        }
        return retval;
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.replaceValue = new String[nrfields];
        this.replaceMask = new String[nrfields];
        this.setEmptyString = new boolean[nrfields];
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getReplaceValue() {
        return this.replaceValue;
    }

    public void setReplaceValue(String[] replaceValue) {
        this.replaceValue = replaceValue;
    }

    public String[] getReplaceMask() {
        return this.replaceMask;
    }

    public void setReplaceMask(String[] replaceMask) {
        this.replaceMask = replaceMask;
    }

    public boolean[] isSetEmptyString() {
        return this.setEmptyString;
    }

    public void setEmptyString(boolean[] setEmptyString) {
        this.setEmptyString = setEmptyString;
    }

    public void setUseVars(boolean usevar) {
        this.usevar = usevar;
    }

    public boolean isUseVars() {
        return this.usevar;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.usevar = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"usevar"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.replaceValue[i] = XMLHandler.getTagValue((Node)fnode, (String)"value");
                this.replaceMask[i] = XMLHandler.getTagValue((Node)fnode, (String)"mask");
                String emptyString = XMLHandler.getTagValue((Node)fnode, (String)"set_empty_string");
                this.setEmptyString[i] = !Const.isEmpty((String)emptyString) && "Y".equalsIgnoreCase(emptyString);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("It was not possible to load the metadata for this step from XML", (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("   " + XMLHandler.addTagValue((String)"usevar", (boolean)this.usevar));
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"value", (String)this.replaceValue[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"mask", (String)this.replaceMask[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"set_empty_string", (boolean)this.setEmptyString[i]));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
            this.replaceValue[i] = "value" + i;
            this.replaceMask[i] = "mask" + i;
            this.setEmptyString[i] = false;
        }
        this.usevar = false;
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.usevar = rep.getStepAttributeBoolean(id_step, "usevar");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.replaceValue[i] = rep.getStepAttributeString(id_step, i, "replace_value");
                this.replaceMask[i] = rep.getStepAttributeString(id_step, i, "replace_mask");
                this.setEmptyString[i] = rep.getStepAttributeBoolean(id_step, i, "set_empty_string", false);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "usevar", this.usevar);
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "replace_value", this.replaceValue[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "replace_mask", this.replaceMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "set_empty_string", this.setEmptyString[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                int idx = prev.indexOfValue(this.fieldName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.fieldName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.FieldsFound", (String[])new String[]{error_message});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = this.fieldName.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(3, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.NoFieldsEntered", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new SetValueConstant(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SetValueConstantData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

