/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.reservoirsampling;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.reservoirsampling.ReservoirSamplingData;
import org.pentaho.di.trans.steps.reservoirsampling.ReservoirSamplingMeta;

public class ReservoirSampling
extends BaseStep
implements StepInterface {
    private ReservoirSamplingMeta m_meta;
    private ReservoirSamplingData m_data;

    public ReservoirSampling(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.m_data.getProcessingMode() == ReservoirSamplingData.PROC_MODE.DISABLED) {
            this.setOutputDone();
            this.m_data.cleanUp();
            return false;
        }
        this.m_meta = (ReservoirSamplingMeta)smi;
        this.m_data = (ReservoirSamplingData)sdi;
        Object[] r = this.getRow();
        if (this.first) {
            this.first = false;
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            this.m_data.setOutputRowMeta(this.getInputRowMeta().clone());
            String sampleSize = this.getTransMeta().environmentSubstitute(this.m_meta.getSampleSize());
            String seed = this.getTransMeta().environmentSubstitute(this.m_meta.getSeed());
            this.m_data.initialize(Integer.valueOf(sampleSize), Integer.valueOf(seed));
        }
        if (this.m_data.getProcessingMode() == ReservoirSamplingData.PROC_MODE.PASSTHROUGH) {
            if (r == null) {
                this.setOutputDone();
                this.m_data.cleanUp();
                return false;
            }
            this.putRow(this.m_data.getOutputRowMeta(), r);
        } else if (this.m_data.getProcessingMode() == ReservoirSamplingData.PROC_MODE.SAMPLING) {
            if (r == null) {
                List<Object[]> samples = this.m_data.getSample();
                int numRows = samples != null ? samples.size() : 0;
                this.logBasic(this.getStepname() + " Actual/Sample: " + numRows + "/" + this.m_data.m_k + " Seed:" + this.getTransMeta().environmentSubstitute(this.m_meta.m_randomSeed));
                if (samples != null) {
                    Object[] sample;
                    for (int i = 0; i < samples.size() && (sample = samples.get(i)) != null; ++i) {
                        this.putRow(this.m_data.getOutputRowMeta(), sample);
                    }
                }
                this.setOutputDone();
                this.m_data.cleanUp();
                return false;
            }
            this.m_data.processRow(r);
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + r);
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Line number " + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.m_meta = (ReservoirSamplingMeta)smi;
        this.m_data = (ReservoirSamplingData)sdi;
        if (super.init(smi, sdi)) {
            boolean remoteInput = this.getStepMeta().getRemoteInputSteps().size() > 0;
            List<StepMeta> previous = this.getTransMeta().findPreviousSteps(this.getStepMeta());
            if (!(remoteInput || previous != null && previous.size() > 0)) {
                this.m_data.setProcessingMode(ReservoirSamplingData.PROC_MODE.DISABLED);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logBasic("Starting to run...");
        try {
            while (this.processRow(this.m_meta, this.m_data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error : " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.m_meta, this.m_data);
            this.logBasic("Finished, processing " + this.getLinesRead() + " rows");
            this.markStop();
        }
    }
}

