/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pgpdecryptstream;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pgpdecryptstream.PGPDecryptStream;
import org.pentaho.di.trans.steps.pgpdecryptstream.PGPDecryptStreamData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class PGPDecryptStreamMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = PGPDecryptStreamMeta.class;
    private String gpglocation;
    private String passhrase;
    private boolean passphraseFromField;
    private String passphraseFieldName;
    private String streamfield;
    private String resultfieldname;

    public void setGPGPLocation(String gpglocation) {
        this.gpglocation = gpglocation;
    }

    public String getGPGLocation() {
        return this.gpglocation;
    }

    public String getStreamField() {
        return this.streamfield;
    }

    public void setStreamField(String streamfield) {
        this.streamfield = streamfield;
    }

    public String getPassphraseFieldName() {
        return this.passphraseFieldName;
    }

    public void setPassphraseFieldName(String passphraseFieldName) {
        this.passphraseFieldName = passphraseFieldName;
    }

    public boolean isPassphraseFromField() {
        return this.passphraseFromField;
    }

    public void setPassphraseFromField(boolean passphraseFromField) {
        this.passphraseFromField = passphraseFromField;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    public void setResultfieldname(String resultfieldname) {
        this.resultfieldname = resultfieldname;
    }

    public String getPassphrase() {
        return this.passhrase;
    }

    public void setPassphrase(String passhrase) {
        this.passhrase = passhrase;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        PGPDecryptStreamMeta retval = (PGPDecryptStreamMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.resultfieldname = "result";
        this.streamfield = null;
        this.passhrase = null;
        this.gpglocation = null;
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (!Const.isEmpty((String)this.resultfieldname)) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.resultfieldname), 2);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"gpglocation", (String)this.gpglocation));
        retval.append("    ").append(XMLHandler.addTagValue((String)"passhrase", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.passhrase)));
        retval.append("    " + XMLHandler.addTagValue((String)"streamfield", (String)this.streamfield));
        retval.append("    " + XMLHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"passphraseFromField", (boolean)this.passphraseFromField));
        retval.append("    " + XMLHandler.addTagValue((String)"passphraseFieldName", (String)this.passphraseFieldName));
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.gpglocation = XMLHandler.getTagValue((Node)stepnode, (String)"gpglocation");
            this.passhrase = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"passhrase"));
            this.streamfield = XMLHandler.getTagValue((Node)stepnode, (String)"streamfield");
            this.resultfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldname");
            this.passphraseFromField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"passphraseFromField"));
            this.passphraseFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"passphraseFieldName");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.gpglocation = rep.getStepAttributeString(id_step, "gpglocation");
            this.passhrase = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "passhrase"));
            this.streamfield = rep.getStepAttributeString(id_step, "streamfield");
            this.resultfieldname = rep.getStepAttributeString(id_step, "resultfieldname");
            this.passphraseFromField = rep.getStepAttributeBoolean(id_step, "passphraseFromField");
            this.passphraseFieldName = rep.getStepAttributeString(id_step, "passphraseFieldName");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "gpglocation", this.gpglocation);
            rep.saveStepAttribute(id_transformation, id_step, "passhrase", Encr.encryptPasswordIfNotUsingVariables((String)this.passhrase));
            rep.saveStepAttribute(id_transformation, id_step, "streamfield", this.streamfield);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldname", this.resultfieldname);
            rep.saveStepAttribute(id_transformation, id_step, "passphraseFromField", this.passphraseFromField);
            rep.saveStepAttribute(id_transformation, id_step, "passphraseFieldName", this.passphraseFieldName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (Const.isEmpty((String)this.gpglocation)) {
            error_message = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.GPGLocationMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.GPGLocationOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
        }
        if (!this.isPassphraseFromField()) {
            if (Const.isEmpty((String)this.passhrase)) {
                error_message = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.PassphraseMissing", (String[])new String[0]);
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                error_message = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.PassphraseOK", (String[])new String[0]);
                cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            }
        }
        if (Const.isEmpty((String)this.resultfieldname)) {
            error_message = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)this.streamfield)) {
            error_message = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.StreamFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.StreamFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new PGPDecryptStream(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new PGPDecryptStreamData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

