/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getslavesequence;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getslavesequence.GetSlaveSequence;
import org.pentaho.di.trans.steps.getslavesequence.GetSlaveSequenceData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class GetSlaveSequenceMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = GetSlaveSequenceMeta.class;
    private String valuename;
    private String slaveServerName;
    private String sequenceName;
    private String increment;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.valuename = XMLHandler.getTagValue((Node)stepnode, (String)"valuename");
            this.slaveServerName = XMLHandler.getTagValue((Node)stepnode, (String)"slave");
            this.sequenceName = XMLHandler.getTagValue((Node)stepnode, (String)"seqname");
            this.increment = XMLHandler.getTagValue((Node)stepnode, (String)"increment");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"GetSequenceMeta.Exception.ErrorLoadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.valuename = "id";
        this.slaveServerName = "slave server name";
        this.sequenceName = "Slave Sequence Name -- To be configured";
        this.increment = "10000";
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMeta v = new ValueMeta(this.valuename, 5);
        v.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)v);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("      ").append(XMLHandler.addTagValue((String)"valuename", (String)this.valuename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"slave", (String)this.slaveServerName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"seqname", (String)this.sequenceName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"increment", (String)this.increment));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.valuename = rep.getStepAttributeString(id_step, "valuename");
            this.slaveServerName = rep.getStepAttributeString(id_step, "slave");
            this.sequenceName = rep.getStepAttributeString(id_step, "seqname");
            this.increment = rep.getStepAttributeString(id_step, "increment");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetSequenceMeta.Exception.UnableToReadStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "valuename", this.valuename);
            rep.saveStepAttribute(id_transformation, id_step, "slave", this.slaveServerName);
            rep.saveStepAttribute(id_transformation, id_step, "seqname", this.sequenceName);
            rep.saveStepAttribute(id_transformation, id_step, "increment", this.increment);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetSequenceMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSequenceMeta.CheckResult.StepIsReceving.Title", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSequenceMeta.CheckResult.NoInputReceived.Title", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GetSlaveSequence(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GetSlaveSequenceData();
    }

    public String getValuename() {
        return this.valuename;
    }

    public void setValuename(String valuename) {
        this.valuename = valuename;
    }

    public String getSlaveServerName() {
        return this.slaveServerName;
    }

    public void setSlaveServerName(String slaveServerName) {
        this.slaveServerName = slaveServerName;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public String getIncrement() {
        return this.increment;
    }

    public void setIncrement(String increment) {
        this.increment = increment;
    }
}

