/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.filelocked;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.checkfilelocked.LockFile;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.filelocked.FileLockedData;
import org.pentaho.di.trans.steps.filelocked.FileLockedMeta;

public class FileLocked
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = FileLockedMeta.class;
    private FileLockedMeta meta;
    private FileLockedData data;

    public FileLocked(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block12: {
            this.meta = (FileLockedMeta)smi;
            this.data = (FileLockedData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            boolean FileLocked2 = false;
            if (this.first) {
                this.first = false;
                this.data.previousRowMeta = this.getInputRowMeta().clone();
                this.data.NrPrevFields = this.data.previousRowMeta.size();
                this.data.outputRowMeta = this.data.previousRowMeta;
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (Const.isEmpty((String)this.meta.getDynamicFilenameField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"FileLocked.Error.FilenameFieldMissing", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"FileLocked.Error.FilenameFieldMissing", (String[])new String[0]));
                }
                if (this.data.indexOfFileename < 0) {
                    this.data.indexOfFileename = this.data.previousRowMeta.indexOfValue(this.meta.getDynamicFilenameField());
                    if (this.data.indexOfFileename < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"FileLocked.Exception.CouldnotFindField", (String[])new String[0]) + "[" + this.meta.getDynamicFilenameField() + "]");
                        throw new KettleException(BaseMessages.getString(PKG, (String)"FileLocked.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicFilenameField()}));
                    }
                }
            }
            try {
                String filename = this.data.previousRowMeta.getString(r, this.data.indexOfFileename);
                if (!Const.isEmpty((String)filename)) {
                    LockFile locked = new LockFile(filename);
                    FileLocked2 = locked.isLocked();
                    if (this.meta.addResultFilenames()) {
                        ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)filename), this.getTransMeta().getName(), this.getStepname());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"FileLocked.Log.FileAddedResult", (String[])new String[0]));
                        this.addResultFile(resultFile);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"FileLocked.Log.FilenameAddResult", (String[])new String[]{filename}));
                        }
                    }
                }
                this.putRow(this.data.outputRowMeta, RowDataUtil.addValueData((Object[])r, (int)this.data.NrPrevFields, (Object)FileLocked2));
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"FileLocked.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"FileLocked.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block12;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "FileLocked001");
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FileLockedMeta)smi;
        this.data = (FileLockedData)sdi;
        if (super.init(smi, sdi)) {
            if (Const.isEmpty((String)this.meta.getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"FileLocked.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FileLockedMeta)smi;
        this.data = (FileLockedData)sdi;
        super.dispose(smi, sdi);
    }
}

