/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.execsqlrow;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.execsqlrow.ExecSQLRowData;
import org.pentaho.di.trans.steps.execsqlrow.ExecSQLRowMeta;

public class ExecSQLRow
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ExecSQLRowMeta.class;
    private ExecSQLRowMeta meta;
    private ExecSQLRowData data;

    public ExecSQLRow(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public static final RowMetaAndData getResultRow(Result result, String upd, String ins, String del, String read) {
        ValueMeta meta;
        RowMetaAndData resultRow = new RowMetaAndData();
        if (upd != null && upd.length() > 0) {
            meta = new ValueMeta(upd, 5);
            meta.setLength(10, 0);
            resultRow.addValue((ValueMetaInterface)meta, (Object)new Long(result.getNrLinesUpdated()));
        }
        if (ins != null && ins.length() > 0) {
            meta = new ValueMeta(ins, 5);
            meta.setLength(10, 0);
            resultRow.addValue((ValueMetaInterface)meta, (Object)new Long(result.getNrLinesOutput()));
        }
        if (del != null && del.length() > 0) {
            meta = new ValueMeta(del, 5);
            meta.setLength(10, 0);
            resultRow.addValue((ValueMetaInterface)meta, (Object)new Long(result.getNrLinesDeleted()));
        }
        if (read != null && read.length() > 0) {
            meta = new ValueMeta(read, 5);
            meta.setLength(10, 0);
            resultRow.addValue((ValueMetaInterface)meta, (Object)new Long(result.getNrLinesRead()));
        }
        return resultRow;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block18: {
            this.meta = (ExecSQLRowMeta)smi;
            this.data = (ExecSQLRowData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (Const.isEmpty((String)this.meta.getSqlFieldName())) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ExecSQLRow.Error.SQLFieldFieldMissing", (String[])new String[0]));
                }
                if (this.data.indexOfSQLFieldname < 0) {
                    this.data.indexOfSQLFieldname = this.getInputRowMeta().indexOfValue(this.meta.getSqlFieldName());
                    if (this.data.indexOfSQLFieldname < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"ExecSQLRow.Exception.CouldnotFindField", (String[])new String[]{this.meta.getSqlFieldName()}));
                    }
                }
            }
            String sql = this.getInputRowMeta().getString(row, this.data.indexOfSQLFieldname);
            try {
                if (this.meta.isSqlFromfile()) {
                    if (Const.isEmpty((String)sql)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"ExecSQLRow.Log.EmptySQLFromFile", (String[])new String[0]));
                    }
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ExecSQLRow.Log.ExecutingSQLFromFile", (String[])new String[]{sql}));
                    }
                    this.data.result = this.data.db.execStatementsFromFile(sql, this.meta.IsSendOneStatement());
                } else {
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ExecSQLRow.Log.ExecutingSQLScript", (String[])new String[0]) + Const.CR + sql);
                    }
                    this.data.result = this.meta.IsSendOneStatement() ? this.data.db.execStatement(sql) : this.data.db.execStatements(sql);
                }
                RowMetaAndData add = ExecSQLRow.getResultRow(this.data.result, this.meta.getUpdateField(), this.meta.getInsertField(), this.meta.getDeleteField(), this.meta.getReadField());
                row = RowDataUtil.addRowData((Object[])row, (int)this.getInputRowMeta().size(), (Object[])add.getData());
                if (this.meta.getCommitSize() > 0 && !this.data.db.isAutoCommit()) {
                    if (this.meta.getCommitSize() == 1) {
                        this.data.db.commit();
                    } else if (this.getLinesWritten() % (long)this.meta.getCommitSize() == 0L) {
                        this.data.db.commit();
                    }
                }
                this.putRow(this.data.outputRowMeta, row);
                if (this.checkFeedback(this.getLinesWritten()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ExecSQLRow.Log.LineNumber", (String[])new String[0]) + this.getLinesWritten());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ExecSQLRow.Log.ErrorInStep", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "ExecSQLRow001");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecSQLRowMeta)smi;
        this.data = (ExecSQLRowData)sdi;
        if (this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ExecSQLRow.Log.FinishingReadingQuery", (String[])new String[0]));
        }
        if (this.data.db != null) {
            try {
                if (!this.data.db.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        this.data.db.commit();
                    } else {
                        this.data.db.rollback();
                    }
                }
            }
            catch (KettleDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"Update.Log.UnableToCommitUpdateConnection", (String[])new String[0]) + this.data.db + "] :" + e.toString());
                this.setErrors(1L);
            }
            finally {
                this.data.db.disconnect();
            }
        }
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ExecSQLRowMeta)smi;
        this.data = (ExecSQLRowData)sdi;
        if (this.data.db != null) {
            this.data.db.cancelQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecSQLRowMeta)smi;
        this.data = (ExecSQLRowData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.getDatabaseMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"ExecSQLRow.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                return false;
            }
            this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ExecSQLRow.Log.ConnectedToDB", (String[])new String[0]));
                }
                if (this.meta.getCommitSize() >= 1) {
                    this.data.db.setCommit(this.meta.getCommitSize());
                }
                return true;
            }
            catch (KettleException e) {
                this.logError(BaseMessages.getString(PKG, (String)"ExecSQLRow.Log.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }
}

