/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.ods;

import java.sql.Date;
import java.util.TimeZone;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KCellType;

public class OdfCell
implements KCell {
    public static String TYPE_BOOLEAN = "boolean";
    public static String TYPE_CURRENCY = "currency";
    public static String TYPE_DATE = "date";
    public static String TYPE_FLOAT = "float";
    public static String TYPE_PERCENTAGE = "percentage";
    public static String TYPE_STRING = "string";
    public static String TYPE_TIME = "time";
    private OdfTableCell cell;

    public OdfCell(OdfTableCell cell) {
        this.cell = cell;
    }

    public KCellType getType() {
        String type = this.cell.getValueType();
        if (Const.isEmpty((String)type)) {
            return KCellType.EMPTY;
        }
        if (TYPE_BOOLEAN.equals(type)) {
            if (Const.isEmpty((String)this.cell.getFormula())) {
                return KCellType.BOOLEAN;
            }
            return KCellType.BOOLEAN_FORMULA;
        }
        if (TYPE_CURRENCY.equals(type) || TYPE_FLOAT.equals(type) || TYPE_PERCENTAGE.equals(type)) {
            if (Const.isEmpty((String)this.cell.getFormula())) {
                return KCellType.NUMBER;
            }
            return KCellType.NUMBER_FORMULA;
        }
        if (TYPE_DATE.equals(type) || TYPE_TIME.equals(type)) {
            if (Const.isEmpty((String)this.cell.getFormula())) {
                return KCellType.DATE;
            }
            return KCellType.DATE_FORMULA;
        }
        if (TYPE_STRING.equals(type)) {
            if (Const.isEmpty((String)this.cell.getFormula())) {
                return KCellType.LABEL;
            }
            return KCellType.STRING_FORMULA;
        }
        return null;
    }

    public Object getValue() {
        try {
            switch (this.getType()) {
                case BOOLEAN_FORMULA: 
                case BOOLEAN: {
                    return (boolean)this.cell.getBooleanValue();
                }
                case DATE_FORMULA: 
                case DATE: {
                    long time = this.cell.getDateValue().getTime().getTime();
                    long tzOffset = TimeZone.getDefault().getOffset(time);
                    return new Date(time + tzOffset);
                }
                case NUMBER_FORMULA: 
                case NUMBER: {
                    return (double)this.cell.getDoubleValue();
                }
                case STRING_FORMULA: 
                case LABEL: {
                    return this.cell.getStringValue();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get value of cell (" + this.cell.getColumnIndex() + ", " + this.cell.getRowIndex() + ")", e);
        }
    }

    public String getContents() {
        try {
            Object value = this.getValue();
            if (value == null) {
                return null;
            }
            return value.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get string content of cell (" + this.cell.getColumnIndex() + ", " + this.cell.getRowIndex() + ")", e);
        }
    }

    public int getRow() {
        return this.cell.getRowIndex();
    }
}

