/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.logging.Metrics;
import org.pentaho.di.core.logging.MetricsInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;

public class RunThread
implements Runnable {
    private static Class<?> PKG = BaseStep.class;
    private StepInterface step;
    private StepMetaInterface meta;
    private StepDataInterface data;
    private LogChannelInterface log;

    public RunThread(StepMetaDataCombi combi) {
        this.step = combi.step;
        this.meta = combi.meta;
        this.data = combi.data;
        this.log = this.step.getLogChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        this.step.setRunning(true);
        this.step.getLogChannel().snap((MetricsInterface)Metrics.METRIC_STEP_EXECUTION_START, new long[0]);
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString((String)"System.Log.StartingToRun"));
        }
        while (this.step.processRow(this.meta, this.data) && !this.step.isStopped()) {
        }
        this.step.dispose(this.meta, this.data);
        this.step.getLogChannel().snap((MetricsInterface)Metrics.METRIC_STEP_EXECUTION_STOP, new long[0]);
        try {
            long li = this.step.getLinesInput();
            long lo = this.step.getLinesOutput();
            long lr = this.step.getLinesRead();
            long lw = this.step.getLinesWritten();
            long lu = this.step.getLinesUpdated();
            long lj = this.step.getLinesRejected();
            long e = this.step.getErrors();
            if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || e > 0L) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"BaseStep.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
            }
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
        }
        catch (Throwable t) {
            this.log.logError("UnexpectedError: " + Const.getStackTracker((Throwable)t));
        }
        finally {
            this.step.markStop();
        }
        catch (Throwable t) {
            try {
                try {
                    if (t instanceof OutOfMemoryError) {
                        this.log.logError("UnexpectedError: ", t);
                    } else {
                        t.printStackTrace();
                        this.log.logError(BaseMessages.getString((String)"System.Log.UnexpectedError"), t);
                    }
                    String logChannelId = this.log.getLogChannelId();
                    LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(logChannelId);
                    String parentLogChannelId = loggingObject.getParent().getLogChannelId();
                    List logChannelChildren = LoggingRegistry.getInstance().getLogChannelChildren(parentLogChannelId);
                    int childIndex = Const.indexOfString((String)this.log.getLogChannelId(), (List)logChannelChildren);
                    System.out.println("child index = " + childIndex + ", logging object : " + loggingObject.toString() + " parent=" + parentLogChannelId);
                    KettleLogStore.getAppender().getBuffer("2bcc6b3f-c660-4a8b-8b17-89e8cbd5b29b", false);
                }
                catch (OutOfMemoryError e) {
                    e.printStackTrace();
                }
                finally {
                    this.step.setErrors(1L);
                    this.step.stopAll();
                }
                this.step.dispose(this.meta, this.data);
            }
            catch (Throwable throwable) {
                this.step.dispose(this.meta, this.data);
                this.step.getLogChannel().snap((MetricsInterface)Metrics.METRIC_STEP_EXECUTION_STOP, new long[0]);
                try {
                    long li = this.step.getLinesInput();
                    long lo = this.step.getLinesOutput();
                    long lr = this.step.getLinesRead();
                    long lw = this.step.getLinesWritten();
                    long lu = this.step.getLinesUpdated();
                    long lj = this.step.getLinesRejected();
                    long e = this.step.getErrors();
                    if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || e > 0L) {
                        this.log.logBasic(BaseMessages.getString(PKG, (String)"BaseStep.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
                    } else {
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
                    }
                }
                catch (Throwable t2) {
                    this.log.logError("UnexpectedError: " + Const.getStackTracker((Throwable)t2));
                }
                finally {
                    this.step.markStop();
                }
                throw throwable;
            }
            this.step.getLogChannel().snap((MetricsInterface)Metrics.METRIC_STEP_EXECUTION_STOP, new long[0]);
            try {
                long li = this.step.getLinesInput();
                long lo = this.step.getLinesOutput();
                long lr = this.step.getLinesRead();
                long lw = this.step.getLinesWritten();
                long lu = this.step.getLinesUpdated();
                long lj = this.step.getLinesRejected();
                long e = this.step.getErrors();
                if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || e > 0L) {
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"BaseStep.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
                } else {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
                }
            }
            catch (Throwable t3) {
                this.log.logError("UnexpectedError: " + Const.getStackTracker((Throwable)t3));
            }
            finally {
                this.step.markStop();
            }
        }
    }
}

