/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.filecompare;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryFileCompare
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryFileCompare.class;
    private String filename1 = null;
    private String filename2 = null;
    private boolean addFilenameToResult = false;

    public JobEntryFileCompare(String n) {
        super(n, "");
    }

    public JobEntryFileCompare() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryFileCompare je = (JobEntryFileCompare)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename1", (String)this.filename1));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename2", (String)this.filename2));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_filename_result", (boolean)this.addFilenameToResult));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename1 = XMLHandler.getTagValue((Node)entrynode, (String)"filename1");
            this.filename2 = XMLHandler.getTagValue((Node)entrynode, (String)"filename2");
            this.addFilenameToResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_filename_result"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryFileCompare.ERROR_0001_Unable_To_Load_From_Xml_Node", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.filename1 = rep.getJobEntryAttributeString(id_jobentry, "filename1");
            this.filename2 = rep.getJobEntryAttributeString(id_jobentry, "filename2");
            this.addFilenameToResult = rep.getJobEntryAttributeBoolean(id_jobentry, "add_filename_result");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryFileCompare.ERROR_0002_Unable_To_Load_Job_From_Repository", (Object[])new Object[]{id_jobentry}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename1", this.filename1);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename2", this.filename2);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_filename_result", this.addFilenameToResult);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryFileCompare.ERROR_0003_Unable_To_Save_Job", (Object[])new Object[]{id_job}), (Throwable)dbe);
        }
    }

    public String getRealFilename1() {
        return this.environmentSubstitute(this.getFilename1());
    }

    public String getRealFilename2() {
        return this.environmentSubstitute(this.getFilename2());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean equalFileContents(FileObject file1, FileObject file2) throws KettleFileException {
        FilterInputStream in1 = null;
        FilterInputStream in2 = null;
        try {
            in1 = new DataInputStream(new BufferedInputStream(KettleVFS.getInputStream((String)KettleVFS.getFilename((FileObject)file1), (VariableSpace)this)));
            in2 = new DataInputStream(new BufferedInputStream(KettleVFS.getInputStream((String)KettleVFS.getFilename((FileObject)file2), (VariableSpace)this)));
            while (in1.available() != 0 && in2.available() != 0) {
                char ch2;
                char ch1 = (char)((DataInputStream)in1).readByte();
                if (ch1 == (ch2 = (char)((DataInputStream)in2).readByte())) continue;
                boolean bl = false;
                return bl;
            }
            if (in1.available() != in2.available()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new KettleFileException((Throwable)e);
        }
        finally {
            if (in1 != null) {
                try {
                    in1.close();
                }
                catch (IOException ignored) {}
            }
            if (in2 != null) {
                try {
                    in2.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        String realFilename1 = this.getRealFilename1();
        String realFilename2 = this.getRealFilename2();
        FileObject file1 = null;
        FileObject file2 = null;
        try {
            if (this.filename1 != null && this.filename2 != null) {
                file1 = KettleVFS.getFileObject((String)realFilename1, (VariableSpace)this);
                file2 = KettleVFS.getFileObject((String)realFilename2, (VariableSpace)this);
                if (file1.exists() && file2.exists()) {
                    if (this.equalFileContents(file1, file2)) {
                        result.setResult(true);
                    } else {
                        result.setResult(false);
                    }
                    if (this.addFilenameToResult && file1.getType() == FileType.FILE && file2.getType() == FileType.FILE) {
                        ResultFile resultFile = new ResultFile(0, file1, this.parentJob.getJobname(), this.toString());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"JobWaitForFile.FilenameAdded", (String[])new String[0]));
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        resultFile = new ResultFile(0, file2, this.parentJob.getJobname(), this.toString());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"JobWaitForFile.FilenameAdded", (String[])new String[0]));
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                    }
                } else {
                    if (!file1.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryFileCompare.ERROR_0004_File1_Does_Not_Exist", (String[])new String[]{realFilename1}));
                    }
                    if (!file2.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryFileCompare.ERROR_0005_File2_Does_Not_Exist", (String[])new String[]{realFilename2}));
                    }
                    result.setResult(false);
                    result.setNrErrors(1L);
                }
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryFileCompare.ERROR_0006_Need_Two_Filenames", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            result.setResult(false);
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryFileCompare.ERROR_0007_Comparing_Files", (String[])new String[]{realFilename2, realFilename2, e.getMessage()}));
        }
        finally {
            try {
                if (file1 != null) {
                    file1.close();
                    file1 = null;
                }
                if (file2 != null) {
                    file2.close();
                    file2 = null;
                }
            }
            catch (IOException e) {}
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public void setFilename1(String filename) {
        this.filename1 = filename;
    }

    public String getFilename1() {
        return this.filename1;
    }

    public void setFilename2(String filename) {
        this.filename2 = filename;
    }

    public String getFilename2() {
        return this.filename2;
    }

    public boolean isAddFilenameToResult() {
        return this.addFilenameToResult;
    }

    public void setAddFilenameToResult(boolean addFilenameToResult) {
        this.addFilenameToResult = addFilenameToResult;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.filename1) && !Const.isEmpty((String)this.filename2)) {
            String realFilename1 = jobMeta.environmentSubstitute(this.filename1);
            String realFilename2 = jobMeta.environmentSubstitute(this.filename2);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFilename1, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realFilename2, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "filename1", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "filename2", remarks, ctx);
    }
}

