/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.pentaho.di.core.compress.CompressionInputStream;
import org.pentaho.di.core.compress.CompressionProvider;

public class GZIPCompressionInputStream
extends CompressionInputStream {
    public GZIPCompressionInputStream(InputStream in, CompressionProvider provider) throws IOException {
        super(GZIPCompressionInputStream.getDelegate(in), provider);
    }

    protected static GZIPInputStream getDelegate(InputStream in) throws IOException {
        GZIPInputStream delegate = null;
        delegate = in instanceof GZIPInputStream ? (GZIPInputStream)in : new GZIPInputStream(in);
        return delegate;
    }

    @Override
    public void close() throws IOException {
        GZIPInputStream gis = (GZIPInputStream)this.delegate;
        gis.close();
    }

    @Override
    public int read() throws IOException {
        GZIPInputStream gis = (GZIPInputStream)this.delegate;
        return gis.read();
    }
}

