/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.GUIOption;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginExtraClassTypes;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginRegistryExtension;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.RegistryPlugin;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@PluginMainClassType(value=PluginRegistryExtension.class)
@PluginExtraClassTypes(classTypes={GUIOption.class})
@PluginAnnotationType(value=RegistryPlugin.class)
public class PluginRegistryPluginType
extends BasePluginType
implements PluginTypeInterface {
    private static PluginRegistryPluginType INSTANCE = new PluginRegistryPluginType();
    private static List<NativePlugin> natives = new ArrayList<NativePlugin>();

    public PluginRegistryPluginType() {
        super(RegistryPlugin.class, "Plugin Extensions", "Plugin Registry Extension Types");
        this.populateFolders("pluginRegistry");
    }

    public static PluginRegistryPluginType getInstance() {
        return INSTANCE;
    }

    @Override
    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    public static void registerNative(Class<?> clazz, String id, String name, String desc) {
        natives.add(new NativePlugin(clazz, id, name, desc));
    }

    @Override
    protected void registerNatives() throws KettlePluginException {
        String xmlFile = "kettle-registry-extensions.xml";
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(xmlFile);
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream("/" + xmlFile);
            }
            if (inputStream == null) {
                return;
            }
            Document document = XMLHandler.loadXMLFile(inputStream, null, true, false);
            Node repsNode = XMLHandler.getSubNode(document, "registry-extensions");
            List<Node> repsNodes = XMLHandler.getNodes(repsNode, "registry-extension");
            for (Node repNode : repsNodes) {
                this.registerPluginFromXmlResource(repNode, "./", this.getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle extension points XML config file: " + xmlFile, e);
        }
    }

    @Override
    protected void registerXmlPlugins() throws KettlePluginException {
    }

    @Override
    protected String extractID(Annotation annotation) {
        return ((RegistryPlugin)annotation).id();
    }

    @Override
    protected String extractName(Annotation annotation) {
        return ((RegistryPlugin)annotation).name();
    }

    @Override
    protected String extractDesc(Annotation annotation) {
        return ((RegistryPlugin)annotation).description();
    }

    @Override
    protected String extractCategory(Annotation annotation) {
        return "";
    }

    @Override
    protected String extractImageFile(Annotation annotation) {
        return "";
    }

    @Override
    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return false;
    }

    @Override
    protected String extractI18nPackageName(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractDocumentationUrl(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractCasesUrl(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractForumUrl(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractClassLoaderGroup(Annotation annotation) {
        return ((RegistryPlugin)annotation).classLoaderGroup();
    }

    private static class NativePlugin {
        Class<?> clazz;
        String id;
        String name;
        String desc;

        public NativePlugin(Class<?> clazz, String id, String name, String desc) {
            this.clazz = clazz;
            this.id = id;
            this.desc = desc;
        }
    }
}

