/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExporterContext;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterNature;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.type.ImageAnchorTypeEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.ObjectUtils;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.PrintPartUnrollExporterInput;
import net.sf.jasperreports.export.XlsExporterConfiguration;
import net.sf.jasperreports.export.XlsReportConfiguration;
import net.sf.jasperreports.export.parameters.ParametersOutputStreamExporterOutput;
import net.sf.jasperreports.renderers.RenderersCache;

public abstract class ExcelAbstractExporter<RC extends XlsReportConfiguration, C extends XlsExporterConfiguration, E extends JRExporterContext>
extends JRAbstractExporter<RC, C, OutputStreamExporterOutput, E> {
    public static final String XLS_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xls.";
    public static final String DEFAULT_SHEET_NAME_PREFIX = "Page ";
    public static final String DEFAULT_DEFINED_NAME_SCOPE = "workbook";
    public static final String DEFAULT_DEFINED_NAME_SCOPE_SEPARATOR = "\\u007C";
    public static final String EXCEPTION_MESSAGE_KEY_CANNOT_ADD_CELL = "export.xls.common.cannot.add.cell";
    public static final String EXCEPTION_MESSAGE_KEY_CANNOT_MERGE_CELLS = "export.xls.common.cannot.merge.cells";
    public static final String EXCEPTION_MESSAGE_KEY_CELL_FORMAT_TEMPLATE_ERROR = "export.xls.common.cell.format.template.error";
    public static final String EXCEPTION_MESSAGE_KEY_COLUMN_INDEX_BEYOND_LIMIT = "export.xls.common.column.index.beyond.limit";
    public static final String EXCEPTION_MESSAGE_KEY_LOADED_FONTS_ERROR = "export.xls.common.loaded.fonts.error";
    public static final String EXCEPTION_MESSAGE_KEY_NEGATIVE_COLUMN_INDEX = "export.xls.common.negative.column.index";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_GENERATION_ERROR = "export.xls.common.report.generation.error";
    public static final String EXCEPTION_MESSAGE_KEY_TEMPLATE_NOT_FOUND = "export.xls.common.template.not.found";
    public static final String PROPERTY_CELL_FORMULA = "net.sf.jasperreports.export.xls.formula";
    public static final String PROPERTY_CELL_PATTERN = "net.sf.jasperreports.export.xls.pattern";
    public static final String PROPERTY_SHEET_NAME = "net.sf.jasperreports.export.xls.sheet.name";
    public static final String PROPERTY_FREEZE_ROW_EDGE = "net.sf.jasperreports.export.xls.freeze.row.edge";
    public static final String PROPERTY_FREEZE_COLUMN_EDGE = "net.sf.jasperreports.export.xls.freeze.column.edge";
    public static final String PROPERTY_AUTO_FIT_ROW = "net.sf.jasperreports.export.xls.auto.fit.row";
    public static final String PROPERTY_IGNORE_ROW_HEIGHT = "net.sf.jasperreports.export.xls.ignore.row.height";
    public static final String PROPERTY_AUTO_FIT_COLUMN = "net.sf.jasperreports.export.xls.auto.fit.column";
    public static final String PROPERTY_AUTO_FILTER = "net.sf.jasperreports.export.xls.auto.filter";
    public static final String PROPERTY_COLUMN_WIDTH = "net.sf.jasperreports.export.xls.column.width";
    public static final String PROPERTY_ROW_OUTLINE_LEVEL_PREFIX = "net.sf.jasperreports.export.xls.row.outline.level.";
    public static final String PROPERTY_BREAK_BEFORE_ROW = "net.sf.jasperreports.export.xls.break.before.row";
    public static final String PROPERTY_BREAK_AFTER_ROW = "net.sf.jasperreports.export.xls.break.after.row";
    public static final String PROPERTY_COLUMN_NAME = "net.sf.jasperreports.export.xls.column.name";
    public static final String PROPERTY_REPEAT_VALUE = "net.sf.jasperreports.export.xls.repeat.value";
    public static final String PROPERTY_DATA = "net.sf.jasperreports.export.xls.data";
    public static final String PROPERTY_COLUMN_WIDTH_METADATA = "net.sf.jasperreports.export.xls.column.width.metadata";
    public static final String CURRENT_ROW_HEIGHT = "CURRENT_ROW_HEIGHT";
    public static final String CURRENT_ROW_AUTOFIT = "CURRENT_ROW_AUTOFIT";
    protected List<Object> loadedFonts = new ArrayList<Object>();
    protected ExporterNature nature;
    protected String[] sheetNames;
    protected int reportIndex;
    protected int pageIndex;
    protected PrintPageFormat pageFormat;
    protected Map<Integer, Boolean> onePagePerSheetMap = new HashMap<Integer, Boolean>();
    protected int sheetsBeforeCurrentReport;
    protected Map<Integer, Integer> sheetsBeforeCurrentReportMap = new HashMap<Integer, Integer>();
    protected RenderersCache renderersCache;
    protected JRFont defaultFont;
    protected JRXlsAbstractExporter.SheetInfo sheetInfo;
    protected int sheetIndex;
    protected int sheetNamesIndex;
    protected Map<String, Integer> sheetNamesMap;
    protected String autoFilterStart;
    protected String autoFilterEnd;
    protected boolean firstPageNotSet;
    protected Boolean keepTemplateSheets;
    protected String workbookTemplate;
    protected String invalidCharReplacement;
    protected int maxColumnIndex;
    protected Map<NameScope, String> definedNamesMap;
    protected Map<String, String> formatPatternsMap;
    protected boolean onePagePerSheet;
    protected boolean defaultShrinkToFit;
    protected boolean defaultWrapText;
    protected boolean defaultCellLocked;
    protected boolean defaultCellHidden;
    protected boolean defaultIgnoreTextFormatting;
    protected boolean ignoreAnchors;
    protected boolean defaultIgnoreHyperlink;
    protected boolean detectCellType;
    protected ImageAnchorTypeEnum defaultImageAnchorType;
    protected boolean collapseRowSpan;
    protected boolean defaultUseTimeZone;
    protected boolean imageBorderFixEnabled;

    protected JRFont getDefaultFont() {
        return this.defaultFont;
    }

    public ExcelAbstractExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public ExcelAbstractExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        OutputStream outputStream = ((OutputStreamExporterOutput)this.getExporterOutput()).getOutputStream();
        try {
            this.exportReportToStream(outputStream);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            ((OutputStreamExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void ensureInput() {
        super.ensureInput();
        this.exporterInput = new PrintPartUnrollExporterInput(this.exporterInput, this.getItemConfigurationInterface());
        this.jasperPrint = this.exporterInput.getItems().get(0).getJasperPrint();
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersOutputStreamExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
        this.sheetInfo = null;
        this.sheetIndex = 0;
        this.onePagePerSheetMap.clear();
        this.sheetsBeforeCurrentReport = 0;
        this.sheetsBeforeCurrentReportMap.clear();
    }

    @Override
    protected void initReport() {
        super.initReport();
        this.setSheetNames();
        this.invalidCharReplacement = this.jasperPrint.hasProperties() && this.jasperPrint.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") ? this.jasperPrint.getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") : this.getPropertiesUtil().getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars", this.jasperPrint);
        this.renderersCache = new RenderersCache(this.getJasperReportsContext());
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        this.onePagePerSheet = configuration.isOnePagePerSheet();
        this.formatPatternsMap = configuration.getFormatPatternsMap();
        this.defaultShrinkToFit = configuration.isShrinkToFit();
        this.defaultWrapText = configuration.isWrapText();
        this.defaultCellLocked = configuration.isCellLocked();
        this.defaultCellHidden = configuration.isCellHidden();
        this.defaultIgnoreTextFormatting = configuration.isIgnoreTextFormatting();
        this.ignoreAnchors = configuration.isIgnoreAnchors();
        this.defaultIgnoreHyperlink = configuration.isIgnoreHyperlink();
        this.detectCellType = configuration.isDetectCellType();
        this.defaultImageAnchorType = configuration.getImageAnchorType();
        this.collapseRowSpan = configuration.isCollapseRowSpan();
        this.defaultUseTimeZone = configuration.isUseTimeZone();
        this.imageBorderFixEnabled = configuration.isImageBorderFixEnabled();
    }

    protected void updatePrintSettings(JRXlsAbstractExporter.SheetInfo.SheetPrintSettings printSettings, XlsReportConfiguration configuration) {
        if (printSettings.getPageHeight() == null) {
            printSettings.setPageHeight(configuration.getPrintPageHeight() == null ? this.jasperPrint.getPageHeight() : configuration.getPrintPageHeight().intValue());
        }
        if (printSettings.getPageWidth() == null) {
            printSettings.setPageWidth(configuration.getPrintPageWidth() == null ? this.jasperPrint.getPageWidth() : configuration.getPrintPageWidth().intValue());
        }
        if (printSettings.getTopMargin() == null) {
            printSettings.setTopMargin(configuration.getPrintPageTopMargin() == null ? 0 : configuration.getPrintPageTopMargin());
        }
        if (printSettings.getLeftMargin() == null) {
            printSettings.setLeftMargin(configuration.getPrintPageLeftMargin() == null ? 0 : configuration.getPrintPageLeftMargin());
        }
        if (printSettings.getBottomMargin() == null) {
            printSettings.setBottomMargin(configuration.getPrintPageBottomMargin() == null ? 0 : configuration.getPrintPageBottomMargin());
        }
        if (printSettings.getRightMargin() == null) {
            printSettings.setRightMargin(configuration.getPrintPageRightMargin() == null ? 0 : configuration.getPrintPageRightMargin());
        }
        if (printSettings.getHeaderMargin() == null) {
            printSettings.setHeaderMargin(configuration.getPrintHeaderMargin() == null ? 0 : configuration.getPrintHeaderMargin());
        }
        if (printSettings.getFooterMargin() == null) {
            printSettings.setFooterMargin(configuration.getPrintFooterMargin() == null ? 0 : configuration.getPrintFooterMargin());
        }
    }

    protected void updateHeaderFooter(JRXlsAbstractExporter.SheetInfo.SheetPrintSettings printSettings, XlsReportConfiguration configuration) {
        if (printSettings.getHeaderLeft() == null) {
            printSettings.setHeaderLeft(configuration.getSheetHeaderLeft());
        }
        if (printSettings.getHeaderCenter() == null) {
            printSettings.setHeaderCenter(configuration.getSheetHeaderCenter());
        }
        if (printSettings.getHeaderRight() == null) {
            printSettings.setHeaderRight(configuration.getSheetHeaderRight());
        }
        if (printSettings.getFooterLeft() == null) {
            printSettings.setFooterLeft(configuration.getSheetFooterLeft());
        }
        if (printSettings.getFooterCenter() == null) {
            printSettings.setFooterCenter(configuration.getSheetFooterCenter());
        }
        if (printSettings.getFooterRight() == null) {
            printSettings.setFooterRight(configuration.getSheetFooterRight());
        }
    }

    protected void mergeAndSetRowLevels(XlsRowLevelInfo levelInfo, SortedMap<String, Boolean> rowLevelMap, int rowIndex) {
        if (rowLevelMap != null) {
            SortedMap<String, Integer> crtLevelMap = levelInfo.getLevelMap();
            for (Map.Entry<String, Boolean> rowLevel : rowLevelMap.entrySet()) {
                Iterator<String> it;
                String level = rowLevel.getKey();
                Boolean isEndMarker = rowLevel.getValue();
                if (crtLevelMap.containsKey(level)) {
                    if (!isEndMarker.booleanValue()) continue;
                    this.setRowLevels(levelInfo, level);
                    it = crtLevelMap.keySet().iterator();
                    while (it.hasNext()) {
                        if (level.compareTo(it.next()) > 0) continue;
                        it.remove();
                    }
                    continue;
                }
                if (crtLevelMap.size() > 0 && level.compareTo(crtLevelMap.firstKey()) < 0) {
                    this.setRowLevels(levelInfo, level);
                    it = crtLevelMap.keySet().iterator();
                    while (it.hasNext()) {
                        if (level.compareTo(it.next()) >= 0) continue;
                        it.remove();
                    }
                }
                crtLevelMap.put(level, rowIndex);
            }
        }
        levelInfo.setEndIndex(rowIndex);
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledTextAttributeSelector selector = textElement.getModeValue() == ModeEnum.OPAQUE ? this.allSelector : this.noBackcolorSelector;
        return textElement.getFullStyledText(selector);
    }

    public static TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        HorizontalTextAlignEnum horizontalAlignment;
        VerticalTextAlignEnum verticalAlignment;
        RotationEnum rotation = textElement.getRotationValue();
        block0 : switch (textElement.getRotationValue()) {
            case LEFT: {
                switch (textElement.getHorizontalTextAlign()) {
                    case JUSTIFIED: {
                        verticalAlignment = VerticalTextAlignEnum.JUSTIFIED;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalTextAlignEnum.TOP;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalTextAlignEnum.MIDDLE;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalTextAlignEnum.BOTTOM;
                    }
                }
                switch (textElement.getVerticalTextAlign()) {
                    case JUSTIFIED: {
                        horizontalAlignment = HorizontalTextAlignEnum.JUSTIFIED;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalTextAlignEnum.RIGHT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalTextAlignEnum.CENTER;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalTextAlignEnum.LEFT;
                break;
            }
            case RIGHT: {
                switch (textElement.getHorizontalTextAlign()) {
                    case JUSTIFIED: {
                        verticalAlignment = VerticalTextAlignEnum.JUSTIFIED;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalTextAlignEnum.BOTTOM;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalTextAlignEnum.MIDDLE;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalTextAlignEnum.TOP;
                    }
                }
                switch (textElement.getVerticalTextAlign()) {
                    case JUSTIFIED: {
                        horizontalAlignment = HorizontalTextAlignEnum.JUSTIFIED;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalTextAlignEnum.LEFT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalTextAlignEnum.CENTER;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalTextAlignEnum.RIGHT;
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalTextAlign();
                verticalAlignment = textElement.getVerticalTextAlign();
            }
        }
        return new TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    protected int getImageBorderCorrection(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            if (lineWidth >= 2.0f) {
                return 2;
            }
            return 1;
        }
        return this.imageBorderFixEnabled ? 1 : 0;
    }

    protected String getSheetName(String sheetName, String defaultSheetName) {
        if (sheetName != null) {
            if (this.sheetNames != null && this.sheetNamesIndex < this.sheetNames.length) {
                this.sheetNames[this.sheetNamesIndex] = sheetName;
            }
            return this.getSheetName(sheetName);
        }
        return this.getSheetName(defaultSheetName);
    }

    protected String getSheetName(String sheetName) {
        String validSheetName;
        if (this.sheetNames != null && this.sheetNamesIndex < this.sheetNames.length) {
            sheetName = this.sheetNames[this.sheetNamesIndex];
        }
        if (sheetName == null) {
            return DEFAULT_SHEET_NAME_PREFIX + (this.sheetIndex + 1);
        }
        int crtIndex = 1;
        String txtIndex = "";
        String string = validSheetName = sheetName.length() < 32 ? sheetName : sheetName.substring(0, 31);
        if (this.sheetNamesMap.containsKey(validSheetName)) {
            crtIndex = this.sheetNamesMap.get(validSheetName) + 1;
            txtIndex = String.valueOf(crtIndex);
        }
        this.sheetNamesMap.put(validSheetName, crtIndex);
        String name = sheetName;
        if (txtIndex.length() > 0) {
            name = name + " " + txtIndex;
        }
        if (name.length() > 31) {
            name = (sheetName + " ").substring(0, 31 - txtIndex.length()) + txtIndex;
        }
        return name;
    }

    protected final int calculateWidthForDinAN(int n) {
        return (int)(Math.pow(2.0, -0.25 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateHeightForDinAN(int n) {
        return (int)(Math.pow(2.0, 0.25 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateWidthForDinBN(int n) {
        return (int)(Math.pow(2.0, -((double)n / 2.0)) * 1000.0);
    }

    protected final int calculateHeightForDinBN(int n) {
        return (int)(Math.pow(2.0, 0.5 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateWidthForDinCN(int n) {
        return (int)(Math.pow(2.0, -0.125 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateHeightForDinCN(int n) {
        return (int)(Math.pow(2.0, 0.375 - (double)n / 2.0) * 1000.0);
    }

    protected boolean isWrapText(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.wrap.text")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.wrap.text", this.defaultWrapText);
        }
        return this.defaultWrapText;
    }

    protected boolean isCellLocked(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.cell.locked")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.cell.locked", this.defaultCellLocked);
        }
        return this.defaultCellLocked;
    }

    protected boolean isShrinkToFit(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.shrink.to.fit")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.shrink.to.fit", this.defaultShrinkToFit);
        }
        return this.defaultShrinkToFit;
    }

    protected boolean isIgnoreTextFormatting(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.ignore.text.formatting")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.ignore.text.formatting", this.defaultIgnoreTextFormatting);
        }
        return this.defaultIgnoreTextFormatting;
    }

    protected String getFormula(JRPrintText text) {
        String formula = JRPropertiesUtil.getOwnProperty(text, PROPERTY_CELL_FORMULA);
        if (formula != null && (formula = formula.trim()).startsWith("=")) {
            formula = formula.substring(1);
        }
        return formula;
    }

    protected void setSheetNames() {
        String[] sheetNamesArray = ((XlsReportConfiguration)this.getCurrentItemConfiguration()).getSheetNames();
        List<String> sheetNamesList = JRStringUtil.split(sheetNamesArray, "/");
        this.sheetNames = sheetNamesList == null ? null : sheetNamesList.toArray(new String[sheetNamesList.size()]);
    }

    protected boolean hasGlobalSheetNames() {
        XlsReportConfiguration lcItemConfiguration;
        Boolean globalSheetNames = null;
        boolean isOverrideHintsDefault = this.propertiesUtil.getBooleanProperty("net.sf.jasperreports.export.configuration.override.report.hints");
        if (this.itemConfiguration != null && ((XlsReportConfiguration)this.itemConfiguration).getSheetNames() != null) {
            boolean isExporterConfigOverrideHints;
            boolean bl = isExporterConfigOverrideHints = ((XlsReportConfiguration)this.itemConfiguration).isOverrideHints() == null ? isOverrideHintsDefault : ((XlsReportConfiguration)this.itemConfiguration).isOverrideHints();
            if (isExporterConfigOverrideHints) {
                globalSheetNames = true;
            }
        }
        if (globalSheetNames == null && (lcItemConfiguration = (XlsReportConfiguration)this.crtItem.getConfiguration()) != null && lcItemConfiguration.getSheetNames() != null) {
            boolean isItemConfigOverrideHints;
            boolean bl = isItemConfigOverrideHints = lcItemConfiguration.isOverrideHints() == null ? isOverrideHintsDefault : lcItemConfiguration.isOverrideHints();
            if (isItemConfigOverrideHints) {
                globalSheetNames = false;
            }
        }
        if (globalSheetNames == null) {
            List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getProperties(this.getCurrentJasperPrint(), "net.sf.jasperreports.export.xls.sheet.names.");
            globalSheetNames = properties == null || properties.isEmpty();
        }
        return globalSheetNames;
    }

    protected boolean isCellHidden(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.cell.hidden")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.cell.hidden", this.defaultCellHidden);
        }
        return this.defaultCellHidden;
    }

    protected String getConvertedPattern(JRPrintText text, String pattern) {
        String convertedPattern = JRPropertiesUtil.getOwnProperty(text, PROPERTY_CELL_PATTERN);
        if (convertedPattern == null || convertedPattern.trim().length() == 0) {
            if (this.formatPatternsMap != null && this.formatPatternsMap.containsKey(pattern)) {
                return this.formatPatternsMap.get(pattern);
            }
            return pattern == null || pattern.trim().length() == 0 ? null : pattern;
        }
        return convertedPattern;
    }

    protected int getColumnIndex(String columnName) {
        String upperColumnName;
        int index = -1;
        if (columnName != null && (upperColumnName = columnName.toUpperCase()).matches("[A-Z]*")) {
            for (int i = 0; i < upperColumnName.length(); ++i) {
                index += (upperColumnName.charAt(i) - 64) * (int)Math.pow(26.0, upperColumnName.length() - i - 1);
            }
        }
        return index;
    }

    protected String getColumnName(int columnIndex) {
        return JRStringUtil.getLetterNumeral(columnIndex + 1, true);
    }

    protected void resetAutoFilters() {
        this.autoFilterStart = null;
        this.autoFilterEnd = null;
    }

    protected boolean isUseTimeZone(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.use.timezone")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.use.timezone", this.defaultUseTimeZone);
        }
        return this.defaultUseTimeZone;
    }

    protected Date translateDateValue(JRPrintText text, Date value) {
        if (this.isUseTimeZone(text)) {
            TimeZone tz = this.getTextTimeZone(text);
            value = JRDataUtils.translateToTimezone(value, tz);
        }
        return value;
    }

    protected boolean isValidScale(Integer scale) {
        return scale != null && scale > 9 && scale < 401;
    }

    protected Integer getMaxRowsPerSheet() {
        return ((XlsReportConfiguration)this.getCurrentItemConfiguration()).getMaxRowsPerSheet();
    }

    protected ExporterNature getNature() {
        return this.nature;
    }

    public static String getColumIndexName(int colIndex, int maxColIndex) {
        if (colIndex < 0) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NEGATIVE_COLUMN_INDEX, colIndex);
        }
        if (colIndex > maxColIndex) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_COLUMN_INDEX_BEYOND_LIMIT, colIndex, maxColIndex);
        }
        if (colIndex < 26) {
            return String.valueOf((char)(colIndex + 65));
        }
        if (colIndex < 702) {
            return String.valueOf((char)(colIndex / 26 + 64)) + String.valueOf((char)(colIndex % 26 + 65));
        }
        return String.valueOf((char)((colIndex - 26) / 676 + 64)) + String.valueOf((char)((colIndex - 26) % 676 / 26 + 65)) + String.valueOf((char)(colIndex % 26 + 65));
    }

    protected void configureDefinedNames(ExporterNature exporterNature, JRPrintElement element) {
        if (exporterNature instanceof JRXlsAbstractExporterNature) {
            this.configureDefinedNames(((JRXlsAbstractExporterNature)exporterNature).getDefinedNames(element));
        }
    }

    protected void configureDefinedNames(JRPropertiesUtil.PropertySuffix[] names) {
        if (names != null) {
            for (JRPropertiesUtil.PropertySuffix definedName : names) {
                this.configureDefinedNames(definedName);
            }
        }
    }

    protected void configureDefinedNames(JRPropertiesUtil.PropertySuffix propertySuffix) {
        if (propertySuffix != null) {
            String[] valueScope;
            String name = propertySuffix.getSuffix();
            String value = propertySuffix.getValue();
            if (name != null && name.trim().length() > 0 && value != null && value.length() > 0 && (valueScope = value.split(DEFAULT_DEFINED_NAME_SCOPE_SEPARATOR))[0] != null && valueScope[0].length() > 0) {
                String scope = valueScope.length > 1 ? valueScope[1] : DEFAULT_DEFINED_NAME_SCOPE;
                NameScope nameScope = new NameScope(name, scope);
                if (valueScope[0].startsWith("=")) {
                    this.definedNamesMap.put(nameScope, valueScope[0].substring(1));
                } else {
                    this.definedNamesMap.put(nameScope, valueScope[0]);
                }
            }
        }
    }

    protected String toExcelName(String name) {
        String excelName;
        if (name.isEmpty()) {
            return name;
        }
        char[] chars = name.toCharArray();
        StringBuilder escaped = null;
        if (!Character.isLetter(chars[0]) && chars[0] != '_' && chars[0] != '\\') {
            escaped = new StringBuilder(chars.length * 4 / 3);
            escaped.append('_');
            escaped.append(Integer.toHexString(chars[0]));
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isLetterOrDigit(chars[i]) || chars[i] == '_' || chars[i] == '\\' || chars[i] == '.') {
                if (escaped == null) continue;
                escaped.append(chars[i]);
                continue;
            }
            if (escaped == null) {
                escaped = new StringBuilder(chars.length * 4 / 3);
                escaped.append(chars, 0, i);
            }
            escaped.append(Integer.toHexString(chars[i]));
        }
        String string = excelName = escaped == null ? name : escaped.toString();
        if (excelName.length() > 255) {
            excelName = excelName.substring(0, 255);
        }
        return excelName;
    }

    protected abstract void openWorkbook(OutputStream var1) throws JRException, IOException;

    protected abstract void closeSheet();

    protected abstract void closeWorkbook(OutputStream var1) throws JRException, IOException;

    protected abstract void setColumnWidth(int var1, int var2, boolean var3);

    protected abstract void addRowBreak(int var1);

    protected abstract void setFreezePane(int var1, int var2);

    protected abstract void setSheetName(String var1);

    protected abstract void setAutoFilter(String var1);

    protected abstract void setRowLevels(XlsRowLevelInfo var1, String var2);

    protected abstract void exportReportToStream(OutputStream var1) throws JRException, IOException;

    protected abstract void exportEmptyReport() throws JRException, IOException;

    public class NameScope {
        private String name;
        private String scope;

        public NameScope(String name, String scope) {
            this.name = name;
            this.scope = scope;
        }

        public String getName() {
            return this.name;
        }

        public String getScope() {
            return this.scope;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return this == null;
            }
            if (this == null || !obj.getClass().equals(NameScope.class)) {
                return false;
            }
            NameScope obj1 = (NameScope)obj;
            return ObjectUtils.equals(this.name, obj1.name) && ObjectUtils.equals(this.scope, obj1.scope);
        }

        public int hashCode() {
            ObjectUtils.HashCode hash = ObjectUtils.hash();
            hash.add(this.name);
            hash.add(this.scope);
            return hash.getHashCode();
        }
    }

    protected static class TextAlignHolder {
        public final HorizontalTextAlignEnum horizontalAlignment;
        public final VerticalTextAlignEnum verticalAlignment;
        public final RotationEnum rotation;

        public TextAlignHolder(HorizontalTextAlignEnum horizontalAlignment, VerticalTextAlignEnum verticalAlignment, RotationEnum rotation) {
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
        }
    }
}

