/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceFinder;

public final class JavaSourceIClassLoader
extends IClassLoader {
    private static final boolean DEBUG = false;
    private final ResourceFinder sourceFinder;
    private final String optionalCharacterEncoding;
    private final Set unitCompilers;
    private UnitCompiler.ErrorHandler optionalCompileErrorHandler = null;
    private WarningHandler optionalWarningHandler = null;

    public JavaSourceIClassLoader(ResourceFinder sourceFinder, String optionalCharacterEncoding, Set unitCompilers, IClassLoader optionalParentIClassLoader) {
        super(optionalParentIClassLoader);
        this.sourceFinder = sourceFinder;
        this.optionalCharacterEncoding = optionalCharacterEncoding;
        this.unitCompilers = unitCompilers;
        super.postConstruct();
    }

    public void setCompileErrorHandler(UnitCompiler.ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    public void setWarningHandler(WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClass findIClass(String type) throws ClassNotFoundException {
        String className = Descriptor.toClassName(type);
        if (className.startsWith("java.")) {
            return null;
        }
        int idx = className.indexOf(36);
        String topLevelClassName = idx == -1 ? className : className.substring(0, idx);
        Iterator it = this.unitCompilers.iterator();
        while (it.hasNext()) {
            UnitCompiler uc = (UnitCompiler)it.next();
            IClass res = uc.findClass(topLevelClassName);
            if (res == null) continue;
            if (!className.equals(topLevelClassName) && (res = uc.findClass(className)) == null) {
                return null;
            }
            this.defineIClass(res);
            return res;
        }
        Resource sourceResource = this.sourceFinder.findResource(ClassFile.getSourceResourceName(className));
        if (sourceResource == null) {
            return null;
        }
        try {
            Java.CompilationUnit cu;
            InputStream inputStream = sourceResource.open();
            try {
                Scanner scanner = new Scanner(sourceResource.getFileName(), inputStream, this.optionalCharacterEncoding);
                scanner.setWarningHandler(this.optionalWarningHandler);
                Parser parser = new Parser(scanner);
                parser.setWarningHandler(this.optionalWarningHandler);
                cu = parser.parseCompilationUnit();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
            UnitCompiler uc = new UnitCompiler(cu, this);
            uc.setCompileErrorHandler(this.optionalCompileErrorHandler);
            uc.setWarningHandler(this.optionalWarningHandler);
            this.unitCompilers.add(uc);
            IClass res = uc.findClass(className);
            if (res == null) {
                if (className.equals(topLevelClassName)) {
                    throw new Parser.ParseException("Source file \"" + sourceResource.getFileName() + "\" does not declare class \"" + className + "\"", (Location)null);
                }
                return null;
            }
            this.defineIClass(res);
            return res;
        }
        catch (Scanner.ScanException e) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", e);
        }
        catch (Parser.ParseException e) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", e);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", e);
        }
        catch (CompileException e) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", e);
        }
    }
}

