/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector;

import de.destatis.core.connect.util.Contract;
import de.destatis.core.inspector.ProblemPosition;

public class InspectionProblem {
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    public static final int FATAL = 4;
    public static final int WORST_PROBLEM_CLASS = 4;
    private int level;
    private String resid;
    private int problemClass;
    private String key;
    private String text;
    private String condition;
    private ProblemPosition pos;

    public InspectionProblem(int level, String resid, int problemClass, String key, String text, String condition, ProblemPosition pos) {
        Contract.verify((level >= 1 && level <= 4 ? 1 : 0) != 0, (String)"Pr\u00fcfebene muss zwischen 1 und 4 sein.");
        Contract.verify((problemClass >= 1 && problemClass <= 4 ? 1 : 0) != 0, (String)"Problemklasse muss zwischen 1 und 4 sein.");
        Contract.verify((key != null && key.length() == 5 ? 1 : 0) != 0, (String)"Problemschl\u00fcssel muss 5-stellig sein.");
        for (int i = 0; i < 5; ++i) {
            Contract.verify((boolean)Character.isDigit(key.charAt(i)), (String)"Problemschl\u00fcssel darf nur aus Ziffern bestehen.");
        }
        Contract.verify((pos != null ? 1 : 0) != 0, (String)"Position muss ungleich null sein.");
        this.level = level;
        this.resid = resid;
        this.problemClass = problemClass;
        this.key = key;
        this.text = text;
        this.condition = condition;
        this.pos = pos;
    }

    public int getTestLevel() {
        return this.level;
    }

    public String getResourceID() {
        return this.resid;
    }

    public int getProblemClass() {
        return this.problemClass;
    }

    public String getKey() {
        return this.key;
    }

    public String getComment() {
        return this.text;
    }

    public String getCondition() {
        return this.condition;
    }

    public ProblemPosition getPosition() {
        return this.pos;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("Pr\u00fcfebene:          ");
        buffer.append(this.level);
        buffer.append(lineSeparator);
        if (this.resid != null && this.resid.length() > 0) {
            buffer.append("Ressourceschl\u00fcssel: ");
            buffer.append(this.resid);
            buffer.append(lineSeparator);
        }
        buffer.append("Klasse:             ");
        switch (this.problemClass) {
            case 1: {
                buffer.append("Information / Hinweis");
                break;
            }
            case 2: {
                buffer.append("Warnung");
                break;
            }
            case 3: {
                buffer.append("Fehler");
                break;
            }
            case 4: {
                buffer.append("Nicht behebbarer Fehler");
            }
        }
        buffer.append(lineSeparator);
        buffer.append("Schl\u00fcssel:          ");
        buffer.append(this.key);
        buffer.append(lineSeparator);
        buffer.append("Erl\u00e4uterungstext:   ");
        buffer.append(this.text);
        buffer.append(lineSeparator);
        if (this.condition != null && this.condition.length() > 0) {
            buffer.append("Bedingung:          ");
            buffer.append(this.condition);
            buffer.append(lineSeparator);
        }
        buffer.append(lineSeparator);
        buffer.append("Position:");
        buffer.append(lineSeparator);
        buffer.append(this.pos);
        return buffer.toString();
    }
}

