/*
 * Decompiled with CFR 0.152.
 */
package de.his.tools;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StringUtil {
    public static final int INDEX_NOT_FOUND = -1;
    private static Logger logger = Logger.getLogger(StringUtil.class);
    protected static final String defaultCharset = "UTF8";
    public static final Set<Character> WORD_CHARS = new HashSet<Character>(Arrays.asList(StringUtil.stringToCharacterArray("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df_0123456789")));

    private static Character[] stringToCharacterArray(String str) {
        char[] chrs = str.toCharArray();
        Character[] characters = new Character[chrs.length];
        for (int i = 0; i < chrs.length; ++i) {
            characters[i] = Character.valueOf(chrs[i]);
        }
        return characters;
    }

    public static String replace(String source, String before, String after) {
        if (source == null || before == null || after == null || before.length() < 1) {
            return source;
        }
        StringBuilder where = new StringBuilder();
        int start = 0;
        int hit = source.indexOf(before, start);
        while (hit >= 0) {
            if (start < hit) {
                where.append(source.substring(start, hit));
            }
            where.append(after);
            start = hit + before.length();
            if (start > source.length()) {
                start = source.length();
            }
            hit = source.indexOf(before, start);
        }
        where.append(source.substring(start));
        return where.toString();
    }

    public static int containsWord(String str, String word) {
        return StringUtil.containsWord(str, word, 0);
    }

    public static int containsWord(String str, String word, int start) {
        if (str == null || word == null) {
            return -1;
        }
        str = str.substring(start);
        int i = str.indexOf(word);
        int j = 0;
        while (i > -1) {
            Character previousChr;
            Character c = previousChr = i > 0 ? Character.valueOf(str.charAt(i - 1)) : null;
            if (previousChr == null || !WORD_CHARS.contains(previousChr)) {
                Character nextChr;
                j = i + word.length();
                Character c2 = nextChr = j < str.length() ? Character.valueOf(str.charAt(j)) : null;
                if (nextChr == null || !WORD_CHARS.contains(nextChr)) {
                    return i + start;
                }
            }
            if ((j = i + 1) < str.length() - 1) {
                i = str.indexOf(word, j);
                continue;
            }
            i = -1;
        }
        return -1;
    }

    public static Vector<String> stringToVector(String str) {
        return StringUtil.stringToVector(str, null);
    }

    public static Vector<String> stringToVector(String str, String sep) {
        return StringUtil.stringToVector(str, sep, false);
    }

    public static Vector<String> stringToVector(String str, String sep, boolean removeBackslashes) {
        String _sep = "\u0003";
        Vector<String> v = new Vector<String>();
        if (str == null) {
            return v;
        }
        if (str.trim().length() == 0) {
            v.addElement("");
            return v;
        }
        String delimiters = ",;" + _sep;
        if (sep != null) {
            delimiters = sep;
        }
        int i = 0;
        StringBuilder strbuf = new StringBuilder();
        String current = str.substring(i, i + 1);
        while (i < str.length() - 1) {
            if (current.equals("\\")) {
                if (!removeBackslashes) {
                    StringUtil.addToStrbuf(strbuf, current);
                }
                if (++i < str.length() - 1) {
                    current = str.substring(i, i + 1);
                    StringUtil.addToStrbuf(strbuf, current);
                    ++i;
                }
            } else if (delimiters.indexOf(current) < 0) {
                StringUtil.addToStrbuf(strbuf, current);
                ++i;
            } else {
                v.add(strbuf.toString());
                strbuf = new StringBuilder();
                current = str.substring(++i, i + 1);
            }
            current = str.substring(i, i + 1);
        }
        if (delimiters.indexOf(current) < 0) {
            v.add(strbuf.toString() + current);
        } else {
            v.add(strbuf.toString());
            v.add("");
        }
        return v;
    }

    private static StringBuilder addToStrbuf(StringBuilder strbuf, String current) {
        if (current.trim().isEmpty() && strbuf.length() == 0) {
            return strbuf;
        }
        return strbuf.append(current);
    }

    static String removeBackslashes(String str) {
        char[] charArray = str.toCharArray();
        Vector<Character> v = new Vector<Character>();
        boolean found = false;
        for (char c : charArray) {
            if (!found && c == '\\') {
                found = true;
                continue;
            }
            v.add(Character.valueOf(c));
            found = false;
        }
        charArray = new char[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            charArray[i] = ((Character)v.elementAt(i)).charValue();
        }
        str = new String(charArray);
        return str;
    }

    public static String[] stringToArray(String str) {
        if (str == null) {
            return new String[0];
        }
        return str.split("\\s*[,;\u0003]\\s*");
    }

    public static String arrayToString(String[] array, String sep) {
        StringBuilder strbuf = new StringBuilder();
        if (sep == null) {
            sep = ",";
        }
        String trimmedSep = sep.trim();
        if (array != null) {
            boolean first = true;
            for (int i = 0; i < array.length; ++i) {
                if (!first) {
                    strbuf.append(sep);
                } else {
                    first = false;
                }
                String item = array[i];
                if (item.indexOf(trimmedSep) > -1) {
                    item = StringUtil.replace(item, trimmedSep, "\\" + trimmedSep);
                }
                strbuf.append(item);
            }
        }
        return strbuf.toString();
    }

    public static String[] vectorToArray(Collection<String> v) {
        if (v == null) {
            return new String[0];
        }
        return v.toArray(new String[v.size()]);
    }

    public static String unquoteDoubles(String str) {
        int len;
        String ret = str;
        if (str != null && (len = str.length()) >= 2 && str.charAt(0) == '\"' && str.charAt(len - 1) == '\"') {
            ret = str.substring(1, len - 1);
        }
        return ret;
    }

    public static String argsubst(String arg, Map<?, ?> prop) {
        return StringUtil.argsubst(arg, null, prop, false);
    }

    public static String argsubst(String arg, String prefix, Map<?, ?> prop, boolean keep) {
        if (arg == null || prop == null) {
            return arg;
        }
        StringBuilder parlist = new StringBuilder();
        String work = arg;
        while (work.length() > 0) {
            int backslaschPos = work.indexOf(92);
            int i = work.indexOf(91);
            boolean replace = backslaschPos <= -1 || backslaschPos + 1 != i;
            if (i > -1 && replace) {
                int j;
                if (i > 0) {
                    parlist.append(work.substring(0, i));
                }
                if ((j = (work = work.substring(++i)).indexOf(93)) < 0) {
                    logger.warn((Object)("argsubst: ] fehlt in " + arg));
                    parlist.append(work);
                    break;
                }
                int k = work.indexOf(91);
                if (k > -1 && k < j) {
                    parlist.append("[");
                    continue;
                }
                String par = work.substring(0, j);
                if (par != null && par.length() > 0) {
                    if (par.indexOf(",") > -1 || par.indexOf(61) > -1 || par.indexOf("@") > -1) {
                        parlist.append("[" + par + "]");
                    } else {
                        String key = par;
                        if (prefix != null) {
                            key = prefix + "." + par;
                        }
                        String parval = null;
                        Object parvalObj = null;
                        if (key.indexOf(35) > -1) {
                            String[] keyNewArr = key.split("#");
                            Map tmpProp = (Map)prop.get(keyNewArr[0]);
                            if (tmpProp != null && keyNewArr.length > 1) {
                                parvalObj = tmpProp.get(keyNewArr[1]);
                            } else {
                                logger.warn((Object)("tmpProp is " + tmpProp + "  for " + key));
                            }
                        } else {
                            parvalObj = prop.get(key);
                        }
                        if (parvalObj != null) {
                            parval = parvalObj.toString();
                        }
                        if (parval != null && parval.trim().length() > 0) {
                            parlist.append(parval);
                        } else if (prefix != null) {
                            key = par;
                            Object temp = prop.get(key);
                            if (temp != null) {
                                parval = temp.toString();
                            }
                            if (parval != null && parval.trim().length() > 0) {
                                parlist.append(parval);
                            }
                        }
                        if ((parval == null || parval.length() < 1) && keep) {
                            parlist.append("[" + par + "]");
                        }
                    }
                }
                work = work.substring(++j);
                continue;
            }
            if (backslaschPos > -1 && backslaschPos + 1 == i) {
                work = work.replace("\\", "");
                int weiter = work.indexOf(93) + 1;
                parlist.append(work, 0, weiter);
                work = work.substring(weiter);
                continue;
            }
            parlist.append(work);
            work = work.substring(work.length());
        }
        return parlist.toString();
    }

    public static int indexOf(String str, String[] arr) {
        block4: {
            if (arr == null) break block4;
            if (str == null) {
                for (int i = 0; i < arr.length; ++i) {
                    if (arr[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < arr.length; ++i) {
                    if (!str.equals(arr[i])) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public static String encodeURL(String str) {
        return StringUtil.encodeURL(str, null);
    }

    public static String encodeURL(String str, String charset) {
        if (str != null) {
            try {
                if (charset == null) {
                    charset = defaultCharset;
                }
                str = URLEncoder.encode(str, charset);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return str;
    }

    public static String extractVersion(String id) {
        try {
            StringTokenizer st = new StringTokenizer(id, " ");
            st.nextToken();
            st.nextToken();
            return st.nextToken();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public static int stringToInt(String zahl, int defaultValue) {
        try {
            return Integer.parseInt(zahl);
        }
        catch (NumberFormatException e) {
            if (zahl != null) {
                logger.warn((Object)("Ungueltige Zahl \"" + zahl + "\". Default-Wert " + defaultValue + " wird verwendet."));
            }
            return defaultValue;
        }
    }

    public static String joinToOsPath(String[] pathElements) {
        StringBuilder path = new StringBuilder();
        for (String pathElement : pathElements) {
            if (path.length() > 0) {
                path.append(File.separator);
            }
            path.append(pathElement);
        }
        return path.toString();
    }

    public static String[] getParsFromString(String arg) {
        Vector<String> v = new Vector<String>();
        if (arg == null) {
            return null;
        }
        String work = arg;
        while (work.length() > 0) {
            int i = work.indexOf("[");
            if (i > -1 && i < work.length()) {
                int ix;
                int j;
                if ((j = (work = work.substring(++i)).indexOf("]")) < 0) {
                    logger.warn((Object)("argsubst: ] fehlt in " + arg));
                    break;
                }
                String par = work.substring(0, j);
                if (par != null && par.length() > 0 && (ix = par.indexOf(",")) < 0) {
                    v.addElement(par);
                }
                work = work.substring(++j);
                continue;
            }
            work = work.substring(work.length());
        }
        String[] pars = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            pars[i] = (String)v.elementAt(i);
        }
        return pars;
    }
}

