/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class X509Auth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(X509Auth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        Object[] objs;
        Object[] oldCerts;
        if (request == null) {
            return userProp;
        }
        Element maxCertDepthElem = confElement.getChild("maxCertDepth");
        int maxCertDepth = 1;
        try {
            if (maxCertDepthElem != null) {
                maxCertDepth = Integer.parseInt(maxCertDepthElem.getText());
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Ungueltiger Wert fuer maxCertDepth: " + confElement.getChildText("maxCertDepth")));
        }
        boolean authSuccess = false;
        if (logger.isDebugEnabled()) {
            this.printRequestProperties(request);
        }
        if ((oldCerts = (Object[])request.getAttribute("javax.net.ssl.peer_certificates")) != null) {
            int nofOldCerts = oldCerts.length;
            logger.debug((Object)("Anzahl Zertifikats-Objekte von Servlet-Spezifikation 2.1: " + nofOldCerts));
            for (int i = 0; i < nofOldCerts; ++i) {
                logger.debug((Object)("Zertifikat #" + i + " hat Java-Klasse " + oldCerts[i].getClass()));
            }
        }
        if ((objs = (Object[])request.getAttribute("javax.servlet.request.X509Certificate")) == null) {
            return userProp;
        }
        int nofObjs = objs.length;
        logger.debug((Object)("Anzahl Zertifikats-Objekte = " + nofObjs));
        if (nofObjs <= 0) {
            logger.info((Object)"Keine Zertifikate...");
            return userProp;
        }
        if (nofObjs > maxCertDepth) {
            logger.error((Object)("Webserver hat " + nofObjs + " Zertifikate \u00fcbermittelt! Bitte 'maxCertDepth' konfigurieren! Login wird abgebrochen..."));
            return userProp;
        }
        Object obj = objs[0];
        if (obj == null) {
            logger.error((Object)"Erhaltenes Zertifikats-Objekt ist null.");
            return userProp;
        }
        logger.debug((Object)("Zertifikat hat Java-Klasse " + obj.getClass().getName()));
        logger.debug((Object)("obj instanceof java.security.cert.Certificate = " + (obj instanceof Certificate)));
        logger.debug((Object)("obj instanceof java.security.cert.X509Certificate = " + (obj instanceof java.security.cert.X509Certificate)));
        logger.debug((Object)("obj instanceof javax.security.cert.Certificate = " + (obj instanceof javax.security.cert.Certificate)));
        logger.debug((Object)("obj instanceof javax.security.cert.X509Certificate = " + (obj instanceof X509Certificate)));
        Element certEmailLocationsElem = confElement.getChild("certEmailLocation");
        String certEmailLocations = certEmailLocationsElem != null ? certEmailLocationsElem.getText() : null;
        logger.debug((Object)("certEmailLocations = " + certEmailLocations));
        String string = certEmailLocations = certEmailLocations != null ? certEmailLocations.trim().toUpperCase() : "";
        if (certEmailLocations.length() == 0) {
            logger.info((Object)"certEmailLocation in LoginConf.xml nicht konfiguriert. Nehme subjectDN, rfc822 als default.");
            certEmailLocations = "SUBJECTDN, RFC822";
        }
        String emailAddress = null;
        StringTokenizer certEmailLocationsTokenizer = new StringTokenizer(certEmailLocations, ",");
        while (emailAddress == null && certEmailLocationsTokenizer.hasMoreTokens()) {
            Object cert;
            String certEmailLocation = certEmailLocationsTokenizer.nextToken().trim().toUpperCase();
            if (obj instanceof Certificate) {
                cert = (Certificate)obj;
                emailAddress = this.analyseJavaCert(certEmailLocation, (Certificate)cert);
                continue;
            }
            if (obj instanceof javax.security.cert.Certificate) {
                cert = (javax.security.cert.Certificate)obj;
                emailAddress = this.analyseJavaxCert(certEmailLocation, (javax.security.cert.Certificate)cert);
                continue;
            }
            logger.error((Object)"Nicht unterst\u00fctzte Zertifikats-Klasse !");
        }
        logger.info((Object)("Gefundene email:" + emailAddress));
        if (emailAddress != null && emailAddress.length() > 0) {
            userProp.setProperty("userEmail", emailAddress);
            authSuccess = true;
        }
        logger.warn((Object)("Ergebnis x509: " + authSuccess));
        if (authSuccess) {
            userProp.setProperty("authenticated", "y");
        }
        return userProp;
    }

    private String analyseJavaCert(String certEmailLocation, Certificate cert) {
        if (logger.isDebugEnabled()) {
            this.printCertificateProperties(cert);
        }
        String emailAddress = null;
        if (cert instanceof java.security.cert.X509Certificate) {
            java.security.cert.X509Certificate x509Cert = (java.security.cert.X509Certificate)cert;
            if (logger.isDebugEnabled()) {
                this.printX509CertificateProperties(x509Cert);
            }
            if (certEmailLocation.equals("RFC822")) {
                emailAddress = this.extractRFC822EmailAddress(x509Cert);
            } else if (certEmailLocation.equals("SUBJECTDN")) {
                Principal subjectDN = x509Cert.getSubjectDN();
                emailAddress = this.extractEmailAddress(subjectDN);
            } else {
                logger.warn((Object)("Nicht unterst\u00fctzter Wert f\u00fcr Parameter certEmailLocation: " + certEmailLocation + " Wird ignoriert..."));
            }
        } else {
            logger.error((Object)"Kein X509Certificate.");
        }
        return emailAddress;
    }

    private String analyseJavaxCert(String certEmailLocation, javax.security.cert.Certificate certXXX) {
        String emailAddress = null;
        if (certXXX instanceof X509Certificate) {
            X509Certificate x509CertXXX = (X509Certificate)certXXX;
            if (certEmailLocation.equals("RFC822")) {
                logger.warn((Object)"rfc822Name wird von javax-Implementierungen nicht unterst\u00fctzt! Wird ignoriert...");
            } else if (certEmailLocation.equals("SUBJECTDN")) {
                Principal subjectDN = x509CertXXX.getSubjectDN();
                emailAddress = this.extractEmailAddress(subjectDN);
            } else {
                logger.warn((Object)("Nicht unterst\u00fctzter Wert f\u00fcr Parameter certEmailLocation: " + certEmailLocation + " Wird ignoriert..."));
            }
        } else {
            logger.error((Object)"Kein X509Certificate.");
        }
        return emailAddress;
    }

    private String extractRFC822EmailAddress(java.security.cert.X509Certificate x509Cert) {
        String rfc822Name = null;
        try {
            Collection<List<?>> subjectAlternativeNames = x509Cert.getSubjectAlternativeNames();
            Object[] subjectAlternativeNamesObj = subjectAlternativeNames.toArray();
            rfc822Name = (String)((List)subjectAlternativeNamesObj[0]).get(1);
        }
        catch (Exception e) {
            logger.error((Object)("Ausnahme aufgetreten: " + e.toString()));
        }
        if (rfc822Name != null) {
            logger.debug((Object)("rfc822Name = " + rfc822Name));
        } else {
            logger.warn((Object)"rfc822Name nicht vorhanden.");
        }
        return rfc822Name;
    }

    private String extractEmailAddress(Principal subjectDN) {
        String userDNName = subjectDN.getName();
        String userDNStr = subjectDN.toString();
        logger.debug((Object)("userDNName = " + userDNName + ", userDNStr = " + userDNStr));
        String value = X509Auth.extractValueFromDNString(userDNStr, "EMAILADDRESS");
        if (value == null) {
            value = X509Auth.extractValueFromDNString(userDNStr, "E");
        }
        logger.debug((Object)("email: " + value));
        if (value == null) {
            logger.error((Object)"subjectDN enth\u00e4lt keine Email-Adresse.");
        }
        return value;
    }

    public static String extractValueFromDNString(String dn, String key) {
        String[] tokens;
        String keyUpper = key.toUpperCase();
        for (String token : tokens = dn.split(", *")) {
            if (!token.toUpperCase().startsWith(keyUpper + "=")) continue;
            return token.substring(token.indexOf("=") + 1);
        }
        return null;
    }

    private void printRequestProperties(HttpServletRequest request) {
        Object ssl_session;
        Object key_size;
        logger.debug((Object)"Request headers ------------------------------");
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            logger.debug((Object)(name + " = " + request.getHeader(name)));
        }
        logger.debug((Object)"Request attributes ------------------------------");
        Enumeration atrrs = request.getAttributeNames();
        while (atrrs.hasMoreElements()) {
            String attr = (String)atrrs.nextElement();
            logger.debug((Object)(attr + " = " + request.getAttribute(attr)));
        }
        logger.debug((Object)"Request parameters ------------------------------");
        Enumeration pars = request.getParameterNames();
        while (pars.hasMoreElements()) {
            String par = (String)pars.nextElement();
            logger.debug((Object)(par + " = " + request.getParameter(par)));
        }
        logger.debug((Object)"Some special attributes ------------------------------");
        Object cipher_suite = request.getAttribute("javax.servlet.request.cipher_suite");
        if (cipher_suite != null) {
            logger.debug((Object)("cipher_suite: Java-Klasse = " + cipher_suite.getClass() + ", Wert = " + cipher_suite));
        }
        if ((key_size = request.getAttribute("javax.servlet.request.key_size")) != null) {
            logger.debug((Object)("key_size: Java-Klasse = " + key_size.getClass() + ", Wert = " + key_size));
        }
        if ((ssl_session = request.getAttribute("javax.servlet.request.ssl_session")) != null) {
            logger.debug((Object)("ssl_session: Java-Klasse = " + ssl_session.getClass() + ", Wert = " + ssl_session));
        }
        boolean isSecure = request.isSecure();
        logger.debug((Object)("isSecure = " + isSecure));
        String scheme = request.getScheme();
        logger.debug((Object)("scheme = " + scheme));
    }

    private void printCertificateProperties(Certificate cert) {
        try {
            byte[] encoded = cert.getEncoded();
            logger.debug((Object)("encoded = " + new String(encoded)));
        }
        catch (CertificateEncodingException ce) {
            logger.error((Object)("Zertifikats-Codierung: " + ce));
        }
        PublicKey publicKey = cert.getPublicKey();
        logger.debug((Object)("publicKey = " + publicKey));
        try {
            cert.verify(publicKey);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void printX509CertificateProperties(java.security.cert.X509Certificate x509Cert) {
        Principal issuerDN = x509Cert.getIssuerDN();
        logger.debug((Object)("issuerDN = " + issuerDN));
        String issuerName = issuerDN.getName();
        logger.debug((Object)("issuerName = " + issuerName));
        BigInteger serialNumber = x509Cert.getSerialNumber();
        logger.debug((Object)("serialNumber = " + serialNumber));
        try {
            x509Cert.checkValidity();
        }
        catch (CertificateExpiredException ce) {
            logger.error((Object)("Zertifikat ist abgelaufen: " + ce));
        }
        catch (CertificateNotYetValidException ce) {
            logger.error((Object)("Zertifikat noch nicht g\u00fcltig: " + ce));
        }
        Date notBefore = x509Cert.getNotBefore();
        logger.debug((Object)("Zertifikat g\u00fcltig ab " + notBefore));
        Date notAfter = x509Cert.getNotAfter();
        logger.debug((Object)("Zertifikat g\u00fcltig bis " + notAfter));
        String sigAlgName = x509Cert.getSigAlgName();
        logger.debug((Object)("sigAlgName = " + sigAlgName));
        String sigAlgOID = x509Cert.getSigAlgOID();
        logger.debug((Object)("sigAlgOID = " + sigAlgOID));
        byte[] sigAlgParms = x509Cert.getSigAlgParams();
        if (sigAlgParms != null) {
            logger.debug((Object)("sigAlgParms = " + new String(sigAlgParms)));
        } else {
            logger.debug((Object)"sigAlgParms = null");
        }
    }
}

