/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.PropUtil;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class RegExAuth
implements AuthenticationPlugin {
    private final Logger logger = Logger.getLogger(RegExAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        this.logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        String key = confElement.getAttributeValue("key");
        String var = confElement.getAttributeValue("var");
        String pattern = confElement.getAttributeValue("pattern");
        String rule = confElement.getAttributeValue("rule");
        if (key == null || var == null || pattern == null || rule == null) {
            this.logger.error((Object)"A required attribute (key, var, match, rules) is missing for regex");
            if (var != null) {
                userProp.remove(var);
            }
            return userProp;
        }
        String value = userProp.getProperty("key");
        if (value == null) {
            this.logger.info((Object)("Value for key " + key + " is undefined."));
            userProp.remove(var);
            return userProp;
        }
        PropUtil.putIgnoreNull(userProp, var, this.regexReplace(value, pattern, rule));
        return userProp;
    }

    String regexReplace(String value, String pattern, String rule) {
        String res = rule;
        Pattern p = Pattern.compile(pattern);
        Matcher matcher = p.matcher(value);
        if (!matcher.matches()) {
            return "";
        }
        int count = matcher.groupCount();
        for (int i = 1; i <= count; ++i) {
            res = res.replace("$" + i, matcher.group(i));
        }
        return res;
    }
}

