/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import org.dbforms.util.external.PrintfFormat;

public class Util {
    private static final String REALPATH = "$(SERVLETCONTEXT_REALPATH)";

    public static final boolean isNull(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static final String decode(String s, String enc) throws UnsupportedEncodingException {
        if (!Util.isNull(s)) {
            try {
                s = Util.decCheck(s, enc);
            }
            catch (NoSuchMethodError nsme) {
                s = URLDecoder.decode(s);
            }
        }
        return s;
    }

    public static final String encode(String s, String enc) throws UnsupportedEncodingException {
        if (!Util.isNull(s)) {
            try {
                s = Util.encCheck(s, enc);
            }
            catch (NoSuchMethodError nsme) {
                s = URLEncoder.encode(s);
            }
        }
        return s;
    }

    public static final String replaceRealPath(String s, String realpath) {
        if (!Util.isNull(s) && !Util.isNull(realpath)) {
            if (realpath.charAt(realpath.length() - 1) != '/') {
                realpath = realpath + '/';
            }
            int i = s.indexOf(REALPATH);
            while (i >= 0) {
                StringBuffer buf = new StringBuffer();
                buf.append(s.substring(0, i));
                buf.append(realpath);
                buf.append(s.substring(i + REALPATH.length() + 1));
                s = buf.toString();
                i = s.indexOf(REALPATH);
            }
        }
        return s;
    }

    public static boolean getFalse(String value) {
        return !Util.getTrue(value);
    }

    public static String getPattern(Format f) {
        if (f instanceof DecimalFormat) {
            return ((DecimalFormat)f).toPattern();
        }
        if (f instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)f).toPattern();
        }
        return null;
    }

    public static boolean getTrue(String value) {
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static String sprintf(String format, Object[] o) {
        PrintfFormat printfFormat = new PrintfFormat(format);
        return printfFormat.sprintf(o);
    }

    private static final String decCheck(String s, String enc) throws UnsupportedEncodingException, NoSuchMethodError {
        if (Util.isNull(enc)) {
            enc = "UTF-8";
        }
        return URLDecoder.decode(s, enc);
    }

    private static final String encCheck(String s, String enc) throws UnsupportedEncodingException, NoSuchMethodError {
        if (Util.isNull(enc)) {
            enc = "UTF-8";
        }
        s = URLEncoder.encode(s, enc);
        return s;
    }

    public static String getBaseURL(HttpServletRequest request) {
        StringBuffer buf = new StringBuffer();
        buf.append(request.getScheme());
        buf.append("://");
        buf.append(request.getServerName());
        int port = request.getServerPort();
        if (port != 80 && port != 443) {
            buf.append(":");
            buf.append(String.valueOf(port));
        }
        buf.append(request.getContextPath());
        buf.append("/");
        return buf.toString();
    }

    public static String getRequestURL(HttpServletRequest request) {
        StringBuffer buf = new StringBuffer();
        buf.append(request.getScheme());
        buf.append("://");
        buf.append(request.getServerName());
        int port = request.getServerPort();
        if (port != 80 && port != 443) {
            buf.append(":");
            buf.append(port);
        }
        buf.append(request.getRequestURI());
        String query = request.getQueryString();
        if (!Util.isNull(query)) {
            buf.append("?");
            buf.append(query);
        }
        return buf.toString();
    }
}

