/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.util.Util;

public class ServletUtil {
    private static Log cat = LogFactory.getLog((Class)(class$org$dbforms$util$ServletUtil == null ? (class$org$dbforms$util$ServletUtil = ServletUtil.class$("org.dbforms.util.ServletUtil")) : class$org$dbforms$util$ServletUtil));
    static /* synthetic */ Class class$org$dbforms$util$ServletUtil;

    public static String dumpRequest(HttpServletRequest req) {
        return ServletUtil.dumpRequest(req, "\n");
    }

    public static String dumpRequest(HttpServletRequest req, String returnToken) {
        String s = null;
        try {
            s = ServletUtil.dump(req, returnToken);
        }
        catch (Exception e) {
            cat.error((Object)"::dumpRequest - exception: ", (Throwable)e);
        }
        return s;
    }

    private static int getElementNameMaxLength(Iterator paramNames) {
        int len = 0;
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            int tmpLen = paramName.length();
            if (tmpLen <= len) continue;
            len = tmpLen;
        }
        return len;
    }

    private static String addSpaces(int spacesToAdd, String fromString) {
        int len = spacesToAdd;
        String res = "";
        if (!Util.isNull(fromString)) {
            len = spacesToAdd - fromString.length();
            for (int i = 0; i < len; ++i) {
                res = res + " ";
            }
        }
        return res;
    }

    private static String dump(HttpServletRequest req, String returnToken) throws ServletException, IOException {
        Enumeration e;
        StringBuffer sb = new StringBuffer();
        String s = null;
        sb.append("HTTP Snooper Servlet").append(returnToken).append(returnToken);
        sb.append("Request URL:").append(returnToken);
        sb.append(" http://" + req.getServerName() + ":" + req.getServerPort() + req.getRequestURI() + returnToken).append(returnToken);
        sb.append("Request Info:").append(returnToken);
        sb.append(" Request Method: " + req.getMethod()).append(returnToken);
        sb.append(" Request URI: " + req.getRequestURI()).append(returnToken);
        sb.append(" Request Protocol: " + req.getProtocol()).append(returnToken);
        sb.append(" Servlet Path: " + req.getServletPath()).append(returnToken);
        sb.append(" Path Info: " + req.getPathInfo()).append(returnToken);
        sb.append(" Path Translated: " + req.getPathTranslated()).append(returnToken);
        sb.append(" Content Length: " + req.getContentLength()).append(returnToken);
        sb.append(" Content Type: " + req.getContentType()).append(returnToken);
        String queryString = req.getQueryString();
        sb.append(" QueryString: " + queryString).append(returnToken);
        if (queryString != null) {
            Map ht = req.getParameterMap();
            sb.append(ServletUtil.geKeyValuesData(ht, returnToken)).append(returnToken);
        }
        sb.append(" Server Name: " + req.getServerName()).append(returnToken);
        sb.append(" Server Port: " + req.getServerPort()).append(returnToken);
        sb.append(" Remote User: " + req.getRemoteUser()).append(returnToken);
        sb.append(" Remote Host: " + req.getRemoteHost()).append(returnToken);
        sb.append(" Remote Address: " + req.getRemoteAddr()).append(returnToken);
        sb.append(" Authentication Scheme: " + req.getAuthType()).append("").append(returnToken);
        int maxParamNameLength = ServletUtil.getElementNameMaxLength(req.getParameterMap().keySet().iterator());
        Enumeration params = req.getParameterNames();
        if (params.hasMoreElements()) {
            sb.append(returnToken).append("Parameters:").append(returnToken);
            while (params.hasMoreElements()) {
                String name = (String)params.nextElement();
                sb.append("  ").append(name).append(ServletUtil.addSpaces(maxParamNameLength, name)).append(" = ");
                String[] values = req.getParameterValues(name);
                for (int x = 0; x < values.length; ++x) {
                    if (x > 0) {
                        sb.append(", ");
                    }
                    sb.append(values[x]);
                }
                sb.append(returnToken);
            }
            sb.append(returnToken);
        }
        if ((e = req.getHeaderNames()).hasMoreElements()) {
            sb.append("Request Headers:").append(returnToken);
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                sb.append("  " + name + ": " + req.getHeader(name)).append(returnToken);
            }
            sb.append(returnToken);
        }
        sb.append(returnToken);
        s = sb.toString();
        return s;
    }

    private static StringBuffer geKeyValuesData(Map ht, String returnToken) {
        StringBuffer sb = new StringBuffer();
        Iterator keys = ht.keySet().iterator();
        int maxKeyNameLength = ServletUtil.getElementNameMaxLength(keys);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String[] values = (String[])ht.get(key);
            for (int i = 0; i < values.length; ++i) {
                sb.append("  {").append(key).append(" [").append(i).append("]}").append(ServletUtil.addSpaces(maxKeyNameLength, key)).append(" = ").append(values[i]).append(returnToken);
            }
        }
        return sb;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

