/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.util;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.dbforms.util.KeyValuePair;
import org.dbforms.util.Util;

public abstract class HttpTestCase
extends TestCase {
    private String paramReplace;
    private String paramSearch;
    private String urlReplace;
    private String urlSearch;
    private WebConversation wc = new WebConversation();
    private WebResponse resp = null;

    public HttpTestCase(String name) {
        super(name);
        String context = System.getProperty("cactus.contextURL");
        if (!Util.isNull(context)) {
            this.println("change context to: " + context);
            this.urlSearch = "http://localhost/bookstore";
            this.urlReplace = context;
            this.paramSearch = "/bookstore/";
            this.paramReplace = "/dbforms-cactus/";
        }
    }

    public void get(String url) throws Exception {
        this.get(url, null);
    }

    public void get(String url, List args) throws Exception {
        url = this.replaceURL(url);
        this.println("=========================");
        this.println("url = " + url);
        this.println("=========================");
        GetMethodWebRequest request = new GetMethodWebRequest(url);
        this.doIt((WebRequest)request, args);
    }

    public void post(String url) throws Exception {
        this.post(url, null);
    }

    public void post(String url, List args) throws Exception {
        url = this.replaceURL(url);
        this.println("=========================");
        this.println("url = " + url);
        this.println("=========================");
        PostMethodWebRequest request = new PostMethodWebRequest(url);
        this.doIt((WebRequest)request, args);
    }

    protected WebResponse getResponse() {
        return this.resp;
    }

    protected void printResponse() throws Exception {
        this.println(this.resp.getText());
    }

    protected void println(String s) {
        System.out.println(s);
    }

    protected boolean responseContains(String text) throws Exception {
        if (this.resp == null || this.resp.getText() == null) {
            return false;
        }
        return this.resp.getText().indexOf(text) != -1;
    }

    private int getStatusCode() {
        return this.resp.getResponseCode();
    }

    private void doIt(WebRequest request, List args) throws Exception {
        this.resp = null;
        if (args != null) {
            this.println("parameters");
            this.println("=========================");
            Iterator iter = args.iterator();
            while (iter.hasNext()) {
                KeyValuePair pair = (KeyValuePair)iter.next();
                this.println(pair.getKey() + " = " + pair.getValue());
                request.setParameter(pair.getKey(), this.replaceParam(pair.getValue()));
            }
            this.println("=========================");
        }
        this.wc.setExceptionsThrownOnErrorStatus(false);
        this.resp = this.wc.getResponse(request);
        this.println("Response code: " + this.getStatusCode());
        this.println("=========================");
        HttpTestCase.assertEquals((String)"Page not found: ", (int)200, (int)this.getStatusCode());
    }

    private String replace(String from, String search, String replace) {
        if (search == null || replace == null) {
            return from;
        }
        int pos = from.indexOf(search);
        if (pos == -1) {
            return from;
        }
        String str = from.substring(0, pos) + replace + from.substring(pos + search.length());
        return str;
    }

    private String replaceParam(String param) {
        return this.replace(param, this.paramSearch, this.paramReplace);
    }

    private String replaceURL(String url) {
        return this.replace(url, this.urlSearch, this.urlReplace);
    }
}

