/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.Table;
import org.dbforms.config.ValidationException;
import org.dbforms.event.DbEventInterceptorSupport;
import org.dbforms.util.FileHolder;

public class BlobInterceptor
extends DbEventInterceptorSupport {
    private static final int BLOB_COL = 0;
    private static final int NAME_COL = 1;
    private static final int MIME_COL = 2;
    private static final int SIZE_COL = 3;
    private HashMap blobFieldData;

    public void setParameterMap(Map params) {
        super.setParameterMap(params);
        this.blobFieldData = new HashMap();
        Iterator iter = params.entrySet().iterator();
        while (iter.hasNext()) {
            String[] s;
            Integer ii;
            Map.Entry me = iter.next();
            String key = (String)me.getKey();
            String value = (String)me.getValue();
            if (key.startsWith("blob-column")) {
                ii = this.getSuffixAsInteger(key, "blob-column");
                s = (String[])this.blobFieldData.get(ii);
                if (s == null) {
                    s = new String[4];
                    this.blobFieldData.put(ii, s);
                }
                s[0] = value;
                continue;
            }
            if (key.startsWith("name-column")) {
                ii = this.getSuffixAsInteger(key, "name-column");
                s = (String[])this.blobFieldData.get(ii);
                if (s == null) {
                    s = new String[4];
                    this.blobFieldData.put(ii, s);
                }
                s[1] = value;
                continue;
            }
            if (key.startsWith("mime-column")) {
                ii = this.getSuffixAsInteger(key, "mime-column");
                s = (String[])this.blobFieldData.get(ii);
                if (s == null) {
                    s = new String[4];
                    this.blobFieldData.put(ii, s);
                }
                s[2] = value;
                continue;
            }
            if (!key.startsWith("size-column")) continue;
            ii = this.getSuffixAsInteger(key, "size-column");
            s = (String[])this.blobFieldData.get(ii);
            if (s == null) {
                s = new String[4];
                this.blobFieldData.put(ii, s);
            }
            s[3] = value;
        }
    }

    public int preInsert(HttpServletRequest request, Table table, FieldValues fieldValues, DbFormsConfig config, Connection con) throws ValidationException {
        this.assignBlobData(table, fieldValues);
        return 0;
    }

    public int preUpdate(HttpServletRequest request, Table table, FieldValues fieldValues, DbFormsConfig config, Connection con) throws ValidationException {
        this.assignBlobData(table, fieldValues);
        return 0;
    }

    private Integer getSuffixAsInteger(String value, String stub) {
        String suffix = value.substring(stub.length());
        if (suffix.length() == 0) {
            return new Integer(Integer.MIN_VALUE);
        }
        return new Integer(suffix);
    }

    private void assignBlobData(Table table, FieldValues fieldValues) {
        Iterator iter = this.blobFieldData.values().iterator();
        while (iter.hasNext()) {
            Object o;
            String[] s = (String[])iter.next();
            FieldValue fv = fieldValues.get(s[0]);
            if (fv == null || (o = fv.getFieldValueAsObject()) == null || !(o instanceof FileHolder)) continue;
            String fileName = ((FileHolder)o).getFileName();
            String contentType = ((FileHolder)o).getContentType();
            int fileLength = ((FileHolder)o).getFileLength();
            this.setValue(table, fieldValues, s[1], fileName);
            if (s[2] != null) {
                this.setValue(table, fieldValues, s[2], contentType);
            }
            if (s[3] == null) continue;
            this.setValue(table, fieldValues, s[3], String.valueOf(fileLength));
        }
    }
}

