/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.wizard;

import de.destatis.core.connect.Client;
import de.destatis.core.connect.ClientStatusEvent;
import de.destatis.core.connect.ClientStatusListener;
import de.destatis.core.connect.GetSurveysRequest;
import de.destatis.core.connect.ResponseToGetSurveysRequest;
import de.destatis.core.connect.survey.Survey;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.MappingBuilder;
import de.destatis.core.map.editor.task.ProgressDialog;
import de.destatis.core.map.editor.task.ProgressMonitor;
import de.destatis.core.map.editor.task.Task;
import de.destatis.core.map.editor.wizard.AbstractStep;
import de.destatis.core.map.editor.wizard.AbstractWizard;
import de.destatis.core.map.editor.wizard.PromtAuthenticationStep;
import de.destatis.core.map.editor.wizard.SelectResourceStorageStep;
import de.destatis.core.map.editor.wizard.SelectSurveyStep;
import de.destatis.core.map.editor.wizard.Step;
import de.destatis.core.resource.DatmlSdfSource;
import de.destatis.core.resource.NoResourceFoundException;
import de.destatis.core.resource.util.ResourceManager;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JOptionPane;

public class CreateMappingWizard
extends AbstractWizard {
    private SelectResourceStorageStep selectResourceStorageStep;
    private PromtAuthenticationStep promtAuthenticationStep;
    private SelectSurveyStep selectSurveyStep;
    private ResourceManager resourceManager;
    private Properties clientProperties;
    private Mapping mapping;
    private MetaErhebungsbeschreibung surveyDefinition;

    public CreateMappingWizard(ResourceManager resourceManager, Properties clientProperties) {
        this.resourceManager = resourceManager;
        this.clientProperties = clientProperties;
        this.mapping = null;
        this.surveyDefinition = null;
        this.selectResourceStorageStep = new SelectResourceStorageStep(true);
        this.promtAuthenticationStep = new PromtAuthenticationStep();
        this.selectSurveyStep = new SelectSurveyStep();
        this.setCurrentStep(this.selectResourceStorageStep);
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public MetaErhebungsbeschreibung getSurveyDefinition() {
        return this.surveyDefinition;
    }

    @Override
    public String getTitle() {
        return "Neues Mapping erstellen";
    }

    @Override
    public Step getNextStep() {
        AbstractStep nextStep = this.getCurrentStep() == this.selectResourceStorageStep ? (this.selectResourceStorageStep.isLocalResourceStorageSelected() ? this.selectSurveyStep : (this.resourceManager.getResourceConfig().getClient() != null ? this.selectSurveyStep : this.promtAuthenticationStep)) : (this.getCurrentStep() == this.promtAuthenticationStep ? this.selectSurveyStep : null);
        return nextStep;
    }

    @Override
    public Step getPreviousStep() {
        AbstractStep previousStep = this.getCurrentStep() == this.selectSurveyStep ? (this.selectResourceStorageStep.isLocalResourceStorageSelected() ? this.selectResourceStorageStep : (this.resourceManager.getResourceConfig().getClient() != null ? this.selectResourceStorageStep : this.promtAuthenticationStep)) : (this.getCurrentStep() == this.promtAuthenticationStep ? this.selectResourceStorageStep : null);
        return previousStep;
    }

    @Override
    protected boolean onNext() {
        boolean canContinue = true;
        if (this.getCurrentStep() == this.selectResourceStorageStep) {
            if (this.selectResourceStorageStep.isLocalResourceStorageSelected()) {
                final ArrayList surveyList = new ArrayList();
                Task task = new Task(){

                    @Override
                    protected void execute(ProgressMonitor monitor) throws Exception {
                        monitor.processing("Liste der Erhebungsbeschreibungen wird ermittelt...");
                        surveyList.addAll(CreateMappingWizard.this.resourceManager.getLocalSurveys());
                    }
                };
                task.execute(new ProgressDialog(this.getDialog(), "Liste der Erhebungsbeschreibungen ermitteln...", true), true);
                if (task.getThrowable() != null) {
                    Throwable t = task.getThrowable();
                    t.printStackTrace();
                    JOptionPane.showMessageDialog(this.getDialog(), t.getMessage(), "Fehler", 0);
                    canContinue = false;
                } else if (task.isAborted()) {
                    canContinue = false;
                } else {
                    this.selectSurveyStep.setSurveyList(surveyList);
                }
            } else if (this.resourceManager.getResourceConfig().getClient() != null) {
                final ArrayList surveyList = new ArrayList();
                Task task = new Task(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void execute(final ProgressMonitor monitor) throws Exception {
                        ClientStatusListener listener = new ClientStatusListener(){

                            @Override
                            public void statusChanged(ClientStatusEvent e) {
                                this.abortIfCanceled(monitor);
                                switch (e.getType()) {
                                    case 1: {
                                        monitor.processed(0.0);
                                        break;
                                    }
                                    case 2: {
                                        monitor.processed(0.05);
                                        break;
                                    }
                                    case 3: {
                                        monitor.processed(0.2);
                                        break;
                                    }
                                    case 4: {
                                        monitor.processed(0.85);
                                    }
                                }
                                monitor.processing(e.getDescription());
                            }
                        };
                        Client client = CreateMappingWizard.this.resourceManager.getResourceConfig().getClient();
                        client.addStatusListener(listener);
                        try {
                            ResponseToGetSurveysRequest response = client.send(new GetSurveysRequest());
                            if (!response.isOK()) {
                                throw new Exception("" + response.getStatus());
                            }
                            this.abortIfCanceled(monitor);
                            surveyList.addAll(response.getSurveyList());
                        }
                        finally {
                            client.removeStatusListener(listener);
                        }
                    }
                };
                task.execute(new ProgressDialog(this.getDialog(), "Liste der Erhebungsbeschreibungen ermitteln...", true), true);
                if (task.getThrowable() != null) {
                    Throwable t = task.getThrowable();
                    t.printStackTrace();
                    JOptionPane.showMessageDialog(this.getDialog(), t.getMessage(), "Fehler", 0);
                    canContinue = false;
                } else if (task.isAborted()) {
                    canContinue = false;
                } else {
                    this.selectSurveyStep.setSurveyList(surveyList);
                }
            }
        } else if (this.getCurrentStep() == this.promtAuthenticationStep) {
            final ArrayList surveyList = new ArrayList();
            Task task = new Task(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void execute(final ProgressMonitor monitor) throws Exception {
                    ClientStatusListener listener = new ClientStatusListener(){

                        @Override
                        public void statusChanged(ClientStatusEvent e) {
                            this.abortIfCanceled(monitor);
                            switch (e.getType()) {
                                case 1: {
                                    monitor.processed(0.0);
                                    break;
                                }
                                case 2: {
                                    monitor.processed(0.05);
                                    break;
                                }
                                case 3: {
                                    monitor.processed(0.2);
                                    break;
                                }
                                case 4: {
                                    monitor.processed(0.85);
                                }
                            }
                            monitor.processing(e.getDescription());
                        }
                    };
                    Client client = new Client(CreateMappingWizard.this.promtAuthenticationStep.getUserName(), CreateMappingWizard.this.promtAuthenticationStep.getPassword(), CreateMappingWizard.this.clientProperties);
                    client.addStatusListener(listener);
                    try {
                        ResponseToGetSurveysRequest response = client.send(new GetSurveysRequest());
                        if (!response.isOK()) {
                            throw new Exception("" + response.getStatus());
                        }
                        this.abortIfCanceled(monitor);
                        surveyList.addAll(response.getSurveyList());
                    }
                    finally {
                        client.removeStatusListener(listener);
                    }
                }
            };
            task.execute(new ProgressDialog(this.getDialog(), "Liste der Erhebungsbeschreibungen ermitteln...", true), true);
            if (task.getThrowable() != null) {
                Throwable t = task.getThrowable();
                t.printStackTrace();
                JOptionPane.showMessageDialog(this.getDialog(), t.getMessage(), "Fehler", 0);
                canContinue = false;
            } else if (task.isAborted()) {
                canContinue = false;
            } else {
                this.selectSurveyStep.setSurveyList(surveyList);
            }
        }
        return canContinue;
    }

    @Override
    protected Step[] getAllSteps() {
        return new Step[]{this.selectResourceStorageStep, this.promtAuthenticationStep, this.selectSurveyStep};
    }

    @Override
    public boolean finish() {
        Throwable t;
        Task task;
        boolean canContinue = true;
        boolean isLocalResourceStorageSelected = this.selectResourceStorageStep.isLocalResourceStorageSelected();
        boolean isSurveyAutoUpdate = this.resourceManager.getResourceConfig().isSurveyAutoUpdate();
        if (!isLocalResourceStorageSelected && !isSurveyAutoUpdate) {
            task = new Task(){

                @Override
                protected void execute(ProgressMonitor monitor) throws Exception {
                    Survey survey = CreateMappingWizard.this.selectSurveyStep.getSelectedSurvey();
                    String statId = survey.getStatId();
                    String reportingPeriod = survey.getErhebungsId().getTimeId();
                    String collector = survey.getLkz();
                    CreateMappingWizard.this.resourceManager.getSdfResource(statId, reportingPeriod, collector);
                }
            };
            task.execute(new ProgressDialog(this.getDialog(), "Lokale Erhebungsbeschreibung wird gesucht...", false), true);
            if (task.getThrowable() != null) {
                t = task.getThrowable();
                t.printStackTrace();
                if (t instanceof NoResourceFoundException) {
                    int answer = JOptionPane.showConfirmDialog(this.getDialog(), "Es existiert keine passende lokale Erhebungsbeschreibung.\nDie automatische Aktualisierung von Erhebungsbeschreibungen ist deaktiviert.\n\nM\u00f6chten Sie auf dem CORE.server automatisch nach einer passenden Erhebungsbeschreibung suchen und diese ggf. herunterladen?", "Lokale Ressourcen aktualisieren?", 1, 3);
                    if (answer != 0) {
                        canContinue = false;
                    }
                } else {
                    JOptionPane.showMessageDialog(this.getDialog(), t.getMessage(), "Fehler", 0);
                    canContinue = false;
                }
            } else {
                int answer = JOptionPane.showConfirmDialog(this.getDialog(), "Es existiert bereits eine passende lokale Erhebungsbeschreibung, welche Sie mit Hlfe der Liste der lokal gespeicherten Erhebungsbeschreibungen ausw\u00e4hlen k\u00f6nnen.\nDie automatische Aktualisierung von Erhebungsbeschreibungen ist deaktiviert.\n\nM\u00f6chten Sie auf dem CORE.server automatisch nach einer aktuelleren Erhebungsbeschreibung suchen und diese ggf. herunterladen?", "Lokale Ressourcen aktualisieren?", 1, 3);
                if (answer != 0) {
                    canContinue = false;
                }
            }
        }
        if (canContinue) {
            task = new Task(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void execute(final ProgressMonitor monitor) throws Exception {
                    Survey survey = CreateMappingWizard.this.selectSurveyStep.getSelectedSurvey();
                    Client client = CreateMappingWizard.this.resourceManager.getResourceConfig().getClient();
                    if (client == null && CreateMappingWizard.this.selectResourceStorageStep.isServerResourceStorageSelected()) {
                        client = new Client(CreateMappingWizard.this.promtAuthenticationStep.getUserName(), CreateMappingWizard.this.promtAuthenticationStep.getPassword(), CreateMappingWizard.this.clientProperties);
                    }
                    ClientStatusListener listener = null;
                    if (client != null) {
                        listener = new ClientStatusListener(){

                            @Override
                            public void statusChanged(ClientStatusEvent e) {
                                this.abortIfCanceled(monitor);
                                switch (e.getType()) {
                                    case 1: {
                                        monitor.processed(0.0);
                                        break;
                                    }
                                    case 2: {
                                        monitor.processed(0.05);
                                        break;
                                    }
                                    case 3: {
                                        monitor.processed(0.4);
                                        break;
                                    }
                                    case 4: {
                                        monitor.processed(0.45);
                                    }
                                }
                                monitor.processing(e.getDescription());
                            }
                        };
                        client.addStatusListener(listener);
                    }
                    try {
                        monitor.processing("Erhebungsbeschreibung wird ermittelt...");
                        DatmlSdfSource sdfSource = CreateMappingWizard.this.selectResourceStorageStep.isServerResourceStorageSelected() ? CreateMappingWizard.this.resourceManager.getSdfResource(survey.getStatId(), survey.getErhebungsId().getTimeId(), survey.getLkz(), true, client) : CreateMappingWizard.this.resourceManager.getSdfResource(survey.getStatId(), survey.getErhebungsId().getTimeId(), survey.getLkz());
                        if (CreateMappingWizard.this.selectResourceStorageStep.isServerResourceStorageSelected()) {
                            monitor.processed(0.5);
                        } else {
                            monitor.processed(0.2);
                        }
                        monitor.processing("Erhebungsbeschreibung wird geladen...");
                        CreateMappingWizard.this.surveyDefinition = sdfSource.getErhebungsbeschreibung();
                        monitor.processed(0.8);
                        monitor.processing("Mapping wird generiert...");
                        MappingBuilder builder = new MappingBuilder();
                        CreateMappingWizard.this.mapping = builder.build(CreateMappingWizard.this.surveyDefinition);
                    }
                    finally {
                        if (client != null) {
                            client.removeStatusListener(listener);
                        }
                    }
                }
            };
            task.execute(new ProgressDialog(this.getDialog(), "Neues Mapping wird erstellt...", true), true);
            if (task.getThrowable() != null) {
                t = task.getThrowable();
                t.printStackTrace();
                JOptionPane.showMessageDialog(this.getDialog(), t.getMessage(), "Fehler", 0);
                canContinue = false;
            } else if (task.isAborted()) {
                canContinue = false;
            }
            if (canContinue) {
                canContinue = super.finish();
            }
        }
        return canContinue;
    }
}

