/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor;

import de.destatis.core.map.Binding;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.editor.MappingEditorTool;
import de.destatis.core.map.model.MetaMapping;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class MappingTreeCellRenderer
extends DefaultTreeCellRenderer {
    private MappingEditorTool mappingEditorTool;

    public MappingTreeCellRenderer(MappingEditorTool mappingEditorTool) {
        this.mappingEditorTool = mappingEditorTool;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        Binding mappingElement = (Binding)value;
        Icon icon = mappingElement.getIcon();
        String text = mappingElement instanceof Mapping ? ((Mapping)mappingElement).getName() : (mappingElement instanceof MetaMapping ? ((MetaMapping)mappingElement).getName() : mappingElement.getId());
        if (icon != null) {
            this.setIcon(icon);
        }
        this.setText(text);
        if (this.mappingEditorTool.getMarkErrorBinding() != null && this.mappingEditorTool.getMarkErrorBinding() == mappingElement) {
            this.setForeground(Color.red);
        }
        return this;
    }
}

