/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map;

import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.HelpFeatureBinding;
import de.destatis.core.map.model.HelpFeatureConfigValue;
import de.destatis.core.map.model.SelectorBinding;
import de.statspez.sdf.generator.meta.SDFStructureTraverser;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabesatz;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.statspez.sdf.generator.util.SDFUtil;
import de.werum.sis.meta.ElementVisitorInterface;
import java.util.Iterator;

public class MappingBuilder {
    public Mapping build(MetaErhebungsbeschreibung surveyDefinition) {
        return this.build(surveyDefinition, null);
    }

    public Mapping build(MetaErhebungsbeschreibung surveyDefinition, HelpFeatureConfigValue helpFeatureConfig) {
        return this.build(surveyDefinition, helpFeatureConfig, true);
    }

    public Mapping build(MetaErhebungsbeschreibung surveyDefinition, HelpFeatureConfigValue helpFeatureConfig, boolean computePositions) {
        Mapping mapping;
        if (surveyDefinition != null) {
            String name = surveyDefinition.getAnzeigeName() != null && surveyDefinition.getAnzeigeName().length() > 0 ? surveyDefinition.getAnzeigeName() : surveyDefinition.getName();
            mapping = new Mapping("1" + surveyDefinition.getProzedurCode(), name);
            mapping.setCustomName("MappingNeu - " + name);
            mapping.setHelpFeatureConfig(helpFeatureConfig == null ? HelpFeatureConfigValue.getDefaultValue() : helpFeatureConfig);
            SDFStructureTraverser traverser = new SDFStructureTraverser(){
                private BindingGroup currentBindingGroup;
                private boolean isDataGroupTypeData;
                private boolean selectorsAdded;
                {
                    this.currentBindingGroup = mapping;
                    this.isDataGroupTypeData = false;
                    this.selectorsAdded = false;
                }

                public void visitErhebungsbeschreibung(MetaErhebungsbeschreibung erhebungsbeschreibung) {
                    MetaSDFAusgabegruppe ausgabegruppe;
                    MetaSDFAusgabesatz ausgabesatz = erhebungsbeschreibung.getAusgabesatz();
                    Iterator ausgabegruppen = ausgabesatz.getAusgabegruppen();
                    while (ausgabegruppen.hasNext()) {
                        ausgabegruppe = (MetaSDFAusgabegruppe)ausgabegruppen.next();
                        if (2 != ausgabegruppe.getAttributDaten()) continue;
                        ausgabegruppe.accept((ElementVisitorInterface)this);
                    }
                    this.isDataGroupTypeData = true;
                    ausgabegruppen = ausgabesatz.getAusgabegruppen();
                    while (ausgabegruppen.hasNext()) {
                        ausgabegruppe = (MetaSDFAusgabegruppe)ausgabegruppen.next();
                        if (1 != ausgabegruppe.getAttributDaten()) continue;
                        ausgabegruppe.accept((ElementVisitorInterface)this);
                    }
                }

                public void visitSDFAusgabegruppe(MetaSDFAusgabegruppe ausgabegruppe) {
                    if (this.isDataGroupTypeData) {
                        this.currentBindingGroup = new FieldSetBinding(ausgabegruppe.getName());
                    }
                    super.visitSDFAusgabegruppe(ausgabegruppe);
                    if (this.isDataGroupTypeData) {
                        mapping.addBinding(this.currentBindingGroup);
                        this.selectorsAdded = true;
                    }
                }

                public void visitSDFFeldReferenz(MetaSDFFeldReferenz feldReferenz) {
                    if (feldReferenz.getKlasse() instanceof MetaSDFMerkmalsgruppe) {
                        FieldGroupBinding fieldGroupBinding = new FieldGroupBinding(feldReferenz.getKlasse().getName());
                        int maximaleAnzahl = SDFUtil.getMaxOccurs((String)feldReferenz.getMaximaleAnzahl());
                        int minimaleAnzahl = SDFUtil.getMinOccurs((String)feldReferenz.getMinimaleAnzahl());
                        if (maximaleAnzahl != -1) {
                            fieldGroupBinding.setSize(new Integer(maximaleAnzahl));
                        } else if (minimaleAnzahl > 0) {
                            fieldGroupBinding.setSize(new Integer(minimaleAnzahl));
                        } else {
                            fieldGroupBinding.setSize(new Integer(1));
                        }
                        this.currentBindingGroup.addBinding(fieldGroupBinding);
                        BindingGroup parentBindingGroup = this.currentBindingGroup;
                        this.currentBindingGroup = fieldGroupBinding;
                        super.visitSDFFeldReferenz(feldReferenz);
                        this.currentBindingGroup = parentBindingGroup;
                    } else if (feldReferenz.isIstSelektor()) {
                        if (this.isDataGroupTypeData && !this.selectorsAdded) {
                            SelectorBinding selectorBinding = new SelectorBinding(feldReferenz.getKlasse().getName());
                            mapping.addBinding(selectorBinding);
                        }
                    } else {
                        FieldBinding fieldBinding = this.currentBindingGroup == mapping ? new HelpFeatureBinding(feldReferenz.getKlasse().getName()) : new FieldBinding(feldReferenz.getKlasse().getName());
                        this.currentBindingGroup.addBinding(fieldBinding);
                    }
                }
            };
            surveyDefinition.accept((ElementVisitorInterface)traverser);
            if (computePositions) {
                BindingHelper.computePositions(mapping);
            }
        } else {
            mapping = null;
        }
        return mapping;
    }
}

