/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.document;

import de.destatis.core.connect.document.DocumentSource;
import de.destatis.core.connect.document.DocumentSourceFactory;
import de.destatis.core.connect.document.StringDocumentSource;
import de.destatis.core.connect.document.ValidationException;
import de.destatis.core.connect.document.util.SaxWriter;
import de.destatis.core.connect.util.ClientLogger;
import de.destatis.core.connect.util.Contract;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLDocument {
    protected static final String XML_VERSION = "version";
    protected static final String XML_XMLNS = "xmlns";
    private static final String SAXParserFactoryProperty = "javax.xml.parsers.SAXParserFactory";
    private static final String CoreSAXParserFactoryImpl = "de.destatis.core.connect.document.util.CoreSAXParserFactoryImpl";
    protected static ClientLogger LOG = null;
    private DocumentSource content;

    public boolean isDocumentSet() {
        return this.content != null;
    }

    public abstract void setDocument(String var1) throws ValidationException;

    public abstract void setDocument(Source var1) throws TransformerException, ValidationException;

    public abstract void setDocument(Source var1, Source var2) throws TransformerException, ValidationException;

    public abstract String getDocument();

    public abstract void getDocument(Result var1) throws TransformerException;

    public abstract void getDocument(Source var1, Result var2) throws TransformerException;

    public DocumentSource getDocumentSource() {
        return this.content;
    }

    private InputStream getDocumentInputStream() {
        Contract.verify(this.isDocumentSet(), "Dokument ist erforderlich");
        return this.content.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws ValidationException {
        if (!this.isDocumentSet()) {
            throw new ValidationException("Das XML-Dokument ist leer!");
        }
        SAXParser reader = new SAXParser();
        DocumentValidater documentValidater = new DocumentValidater();
        try {
            reader.setFeature("http://xml.org/sax/features/namespaces", false);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception exc) {
            LOG.error("Unerwarteter Fehler:", exc);
            throw new RuntimeException(exc);
        }
        reader.setContentHandler(documentValidater);
        reader.setErrorHandler(documentValidater);
        try {
            InputStream in = null;
            try {
                in = this.getDocumentInputStream();
                reader.parse(new InputSource(in));
            }
            finally {
                if (reader != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (IOException exc) {
            LOG.error("Bei der Validierung des XML-Dokuments ist ein unerwarteter Fehler aufgetreten:", exc);
            throw new RuntimeException(exc);
        }
        catch (SAXParseException exc) {
            throw new ValidationException(exc);
        }
        catch (SAXException exc) {
            if (exc.getException() != null && exc.getException() instanceof ValidationException) {
                throw (ValidationException)exc.getException();
            }
            LOG.error("Unerwarteter Fehler beim Parsen des XML-Dokuments aufgetreten!", exc);
            throw new ValidationException(exc.getMessage());
        }
        if (!documentValidater.isRootElementFound()) {
            throw new ValidationException("Root-Element <" + this.getRootElement() + "> nicht gefunden!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected XMLDocument() {
        if (LOG != null) return;
        Class<XMLDocument> clazz = XMLDocument.class;
        synchronized (XMLDocument.class) {
            if (LOG != null) return;
            LOG = ClientLogger.getLogger(XMLDocument.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected XMLDocument(XMLDocument source) {
        this();
        Contract.verify(source.isDocumentSet(), "Ausgangsdokument ist leer!");
        try {
            this.setContent(source.getContent());
        }
        catch (ValidationException exc) {
            exc.printStackTrace();
        }
    }

    protected boolean validateAtSetting() {
        return true;
    }

    protected abstract String getRootElement();

    protected abstract void validateRootElement(Attributes var1) throws ValidationException;

    protected void setContent(DocumentSource source) throws ValidationException {
        this.content = source;
        if (this.validateAtSetting()) {
            this.validate();
        }
    }

    protected void setContent(String content) throws ValidationException {
        this.setContent(DocumentSourceFactory.createDocumentSource(content));
    }

    protected void setContent(Source source) throws TransformerException, ValidationException {
        InputSource inputSource = SAXSource.sourceToInputSource(source);
        if (inputSource != null) {
            this.setContent(inputSource, 0);
        } else {
            try {
                String oldProperty = System.getProperty(SAXParserFactoryProperty);
                System.setProperty(SAXParserFactoryProperty, CoreSAXParserFactoryImpl);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                StringWriter writer = new StringWriter();
                StreamResult dest = new StreamResult(writer);
                transformer.transform(source, dest);
                if (oldProperty == null) {
                    System.getProperties().remove(SAXParserFactoryProperty);
                } else {
                    System.setProperty(SAXParserFactoryProperty, oldProperty);
                }
                this.setContent(writer.toString());
            }
            catch (TransformerConfigurationException exc) {
                exc.printStackTrace();
            }
            catch (TransformerFactoryConfigurationError exc) {
                exc.printStackTrace();
            }
        }
    }

    protected void setContent(InputSource source, int sourceLen) throws ValidationException {
        StringWriter writer = sourceLen > 0 ? new StringWriter(sourceLen) : new StringWriter();
        CoreSaxWriter saxWriter = new CoreSaxWriter();
        saxWriter.setOutput(writer);
        try {
            saxWriter.parse(source);
        }
        catch (SAXParseException exc) {
            throw new ValidationException(exc);
        }
        catch (SAXException exc) {
            if (exc.getException() != null && exc.getException() instanceof ValidationException) {
                throw (ValidationException)exc.getException();
            }
            LOG.error("Unerwarteter Fehler beim Parsen des XML-Dokuments aufgetreten!", exc);
            throw new ValidationException(exc.getMessage());
        }
        if (this.validateAtSetting() && !saxWriter.isRootElementFound()) {
            throw new ValidationException("Root-Element <" + this.getRootElement() + "> nicht gefunden!");
        }
        this.content = new StringDocumentSource(writer.toString());
    }

    protected void setContent(Source source, Source stylesheet) throws TransformerException, ValidationException {
        try {
            String oldProperty = System.getProperty(SAXParserFactoryProperty);
            System.setProperty(SAXParserFactoryProperty, CoreSAXParserFactoryImpl);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(stylesheet);
            StringWriter writer = new StringWriter();
            StreamResult dest = new StreamResult(writer);
            transformer.transform(source, dest);
            if (oldProperty == null) {
                System.getProperties().remove(SAXParserFactoryProperty);
            } else {
                System.setProperty(SAXParserFactoryProperty, oldProperty);
            }
            this.setContent(writer.toString());
        }
        catch (TransformerConfigurationException exc) {
            exc.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError exc) {
            exc.printStackTrace();
        }
    }

    protected String getContent() {
        Contract.verify(this.isDocumentSet(), "Dieses Dokument ist leer!");
        return this.content.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getContent(Result result) throws TransformerException {
        Contract.verify(this.isDocumentSet(), "Dieses Dokument ist leer!");
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            InputStream in = null;
            try {
                in = this.getDocumentInputStream();
                StreamSource source = new StreamSource(in);
                transformer.transform(source, result);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable e) {}
                }
            }
        }
        catch (TransformerConfigurationException exc) {
            exc.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError exc) {
            exc.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getContent(Source stylesheet, Result result) throws TransformerException {
        Contract.verify(this.isDocumentSet(), "Dieses Dokument ist leer!");
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(stylesheet);
            InputStream in = null;
            try {
                in = this.getDocumentInputStream();
                StreamSource source = new StreamSource(in);
                transformer.transform(source, result);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable e) {}
                }
            }
        }
        catch (TransformerConfigurationException exc) {
            exc.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError exc) {
            exc.printStackTrace();
        }
    }

    protected class CoreSaxWriter
    extends SaxWriter {
        private boolean rootElementFound = false;

        public boolean isRootElementFound() {
            return this.rootElementFound;
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.rootElementFound = false;
        }

        @Override
        public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
            if (XMLDocument.this.validateAtSetting() && raw.equals(XMLDocument.this.getRootElement())) {
                this.rootElementFound = true;
                try {
                    XMLDocument.this.validateRootElement(attrs);
                }
                catch (ValidationException exc) {
                    throw new SAXException(exc);
                }
            }
            super.startElement(uri, local, raw, attrs);
        }

        @Override
        protected void errPrintln(String text) {
            LOG.error(text);
        }

        @Override
        protected void errPrintStackTrace(Exception exc) {
            LOG.error("Beim Parsen des XML-Dokuments ist eine Exception aufgetreten!", exc);
        }
    }

    protected class DocumentValidater
    extends DefaultHandler {
        private boolean rootElementFound = false;

        public boolean isRootElementFound() {
            return this.rootElementFound;
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.rootElementFound = false;
        }

        @Override
        public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
            if (raw.equals(XMLDocument.this.getRootElement())) {
                this.rootElementFound = true;
                try {
                    XMLDocument.this.validateRootElement(attrs);
                }
                catch (ValidationException exc) {
                    throw new SAXException(exc);
                }
            }
            super.startElement(uri, local, raw, attrs);
        }

        @Override
        public void error(SAXParseException exc) throws SAXException {
            throw exc;
        }

        @Override
        public void warning(SAXParseException exc) throws SAXException {
            throw exc;
        }
    }
}

