/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html.source;

import com.atlassian.clover.reporters.html.source.SourceListener;
import com.atlassian.clover.spi.reporters.html.source.HtmlRenderingSupport;
import com.atlassian.clover.spi.reporters.html.source.LineRenderInfo;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaintextHtmlSourceRenderer
implements SourceListener {
    protected StringBuffer out = new StringBuffer();
    protected final HtmlRenderingSupport renderingHelper;
    protected String emptyCoverageMsg;
    protected final String tab;
    protected final String space;
    protected final List<LineRenderInfo> lineInfo;

    public PlaintextHtmlSourceRenderer(List<LineRenderInfo> lineInfo, HtmlRenderingSupport renderingHelper, String emptyCoverageMsg, String tab, String space) {
        this.lineInfo = lineInfo;
        this.renderingHelper = renderingHelper;
        this.emptyCoverageMsg = emptyCoverageMsg;
        this.tab = tab;
        this.space = space;
    }

    @Override
    public void onChunk(String s) {
        this.out.append(this.renderingHelper.htmlEscapeStr(s, this.tab, this.space));
    }

    @Override
    public void onNewLine() {
        this.newLine();
    }

    @Override
    public void onStartDocument() {
    }

    @Override
    public void onEndDocument() {
        if (this.out.length() > 0) {
            this.newLine();
        }
    }

    private void newLine() {
        LineRenderInfo thisLine = new LineRenderInfo(this.emptyCoverageMsg);
        thisLine.setSrc(this.out.toString());
        this.lineInfo.add(thisLine);
        this.out = new StringBuffer();
    }
}

