/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.ErrorInfo;
import com.atlassian.clover.recorder.ActivePerTestRecorderAny;
import com.atlassian.clover.recorder.ActivePerTestRecorderNone;
import com.atlassian.clover.recorder.LivePerTestRecording;
import com.atlassian.clover.recorder.PerTestRecorder;
import com.atlassian.clover.recorder.RecordingResult;
import com_cenqua_clover.CoverageRecorder;
import org.jetbrains.annotations.Nullable;

public interface ThreadVisibilityStrategy
extends PerTestRecorder {

    public static class SingleThreaded
    implements ThreadVisibilityStrategy {
        private ActivePerTestRecorderAny recorders;

        public SingleThreaded(CoverageRecorder coverageRecorder) {
            this.recorders = new ActivePerTestRecorderNone(coverageRecorder);
        }

        public void testStarted(String runtimeType, long start, int slice, int testRunId) {
            this.recorders = this.recorders.testStarted(runtimeType, start, slice, testRunId);
        }

        public LivePerTestRecording testFinished(String runtimeType, String method, @Nullable String runtimeTestName, long end, int slice, int testRunId, int exitStatus, ErrorInfo ei) {
            RecordingResult sliceAndRecorders = this.recorders.testFinished(runtimeType, method, runtimeTestName, end, slice, testRunId, exitStatus, ei);
            this.recorders = sliceAndRecorders.recorders;
            return sliceAndRecorders.recording;
        }

        public void set(int index) {
            this.recorders.set(index);
        }
    }

    public static class Synchronized
    implements ThreadVisibilityStrategy {
        private ActivePerTestRecorderAny recorders;

        public Synchronized(CoverageRecorder coverageRecorder) {
            this.recorders = new ActivePerTestRecorderNone(coverageRecorder);
        }

        public synchronized void testStarted(String runtimeType, long start, int slice, int testRunId) {
            this.recorders = this.recorders.testStarted(runtimeType, start, slice, testRunId);
        }

        public synchronized LivePerTestRecording testFinished(String runtimeType, String method, @Nullable String runtimeTestName, long end, int slice, int testRunId, int exitStatus, ErrorInfo ei) {
            RecordingResult sliceAndRecorders = this.recorders.testFinished(runtimeType, method, runtimeTestName, end, slice, testRunId, exitStatus, ei);
            this.recorders = sliceAndRecorders.recorders;
            return sliceAndRecorders.recording;
        }

        public synchronized void set(int index) {
            this.recorders.set(index);
        }
    }

    public static class Volatile
    implements ThreadVisibilityStrategy {
        private volatile ActivePerTestRecorderAny recorders;

        public Volatile(CoverageRecorder coverageRecorder) {
            this.recorders = new ActivePerTestRecorderNone(coverageRecorder);
        }

        public synchronized void testStarted(String runtimeType, long start, int slice, int testRunId) {
            this.recorders = this.recorders.testStarted(runtimeType, start, slice, testRunId);
        }

        public synchronized LivePerTestRecording testFinished(String runtimeType, String method, @Nullable String runtimeTestName, long end, int slice, int testRunId, int exitStatus, ErrorInfo ei) {
            RecordingResult sliceAndRecorders = this.recorders.testFinished(runtimeType, method, runtimeTestName, end, slice, testRunId, exitStatus, ei);
            this.recorders = sliceAndRecorders.recorders;
            return sliceAndRecorders.recording;
        }

        public void set(int index) {
            this.recorders.set(index);
        }
    }
}

