/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import clover.com.atlassian.extras.api.AtlassianLicense;
import clover.com.atlassian.extras.api.LicenseManager;
import clover.com.atlassian.extras.api.Product;
import clover.com.atlassian.extras.core.LicenseManagerFactory;
import com.atlassian.clover.LicenseLogger;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com_cenqua_clover.CloverVersionInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public final class CloverLicense {
    private static final String GENERIC_ERROR = "Invalid license data";
    private static final String CLOVER_EDITION_PROPERTY = "clover.license.edition";
    private static final String CLOVER_EDITION_PROPERTY_DESKTOP = "desktop";
    public static final long ONE_DAY = 86400000L;
    public static final long PERMS_ALL = -1L;
    public static final long PERMS_HIST_PDF = 64L;
    public static final long PERMS_HIST_HTML = 32L;
    public static final long PERMS_TEST_OPT = 16L;
    public static final long PERMS_CURR_JSON = 8L;
    public static final long PERMS_CURR_PDF = 4L;
    public static final long PERMS_CURR_HTML = 2L;
    public static final long PERMS_CURR_XML = 1L;
    public static final long PERMS_HIST = 96L;
    public static final long PERMS_CURR = 15L;
    public static final long PERMS_DESKTOP = -128L;
    private final String productName;
    private final String licenseName;
    private final long softExpiry;
    private final long hardExpiry;
    private final String organisationName;
    private final String ownerStatement;
    private final String preExpiryStatement;
    private final String postExpiryStatement;
    private final String contactInfoStatement;
    private final String terminationStatement;
    private final String supportEntitlementNumber;
    private final boolean desktop;
    private final HashSet allowedPkgPrefixes;
    private long maintExpiry;
    private long supportedFeatures;

    public static String readFrom(InputStream licenseIn) throws CloverException {
        try {
            StringBuffer licenseCert = new StringBuffer();
            LineNumberReader lin = new LineNumberReader(new InputStreamReader(licenseIn, "UTF-8"));
            String line = lin.readLine();
            while (line != null) {
                licenseCert.append(line).append("\n");
                line = lin.readLine();
            }
            return licenseCert.toString();
        }
        catch (IOException e) {
            throw new CloverException("Error reading license. " + e.getMessage(), e);
        }
    }

    public CloverLicense(String licenseCert) throws CloverException {
        this.configureLoggingForExtras();
        if (licenseCert.indexOf("Product: Clover") != -1 && licenseCert.indexOf("Certificate: ") != -1) {
            throw new CloverException("Cenqua licenses are no longer compatible with this version of Clover: " + CloverVersionInfo.formatVersionInfo() + ".\n Please visit " + "http://www.atlassian.com/clover/renew" + " to obtain a new clover.license.");
        }
        LicenseManager manager = LicenseManagerFactory.getLicenseManager();
        AtlassianLicense atlLlicense = manager.getLicense(licenseCert);
        clover.com.atlassian.extras.api.clover.CloverLicense license = (clover.com.atlassian.extras.api.clover.CloverLicense)atlLlicense.getProductLicense(Product.CLOVER);
        if (license == null) {
            throw new CloverException("Not a Clover license. " + atlLlicense.getProductLicenses());
        }
        try {
            boolean expires = license.isEvaluation();
            this.productName = license.getProduct().getName();
            this.licenseName = license.getDescription();
            this.organisationName = license.getOrganisation().getName();
            this.supportEntitlementNumber = license.getSupportEntitlementNumber();
            this.maintExpiry = license.getMaintenanceExpiryDate().getTime();
            this.hardExpiry = license.getExpiryDate() == null ? 0L : license.getExpiryDate().getTime();
            this.softExpiry = expires ? license.getCreationDate().getTime() + 2592000000L : 0L;
            this.ownerStatement = license.getDescription() + " License registered to " + license.getOrganisation().getName() + ".";
            this.preExpiryStatement = expires ? "You have $daysleft day(s) before your license expires." : "";
            this.postExpiryStatement = expires ? "Your license has expired." : "";
            this.terminationStatement = expires ? "Your license has expired." : "";
            this.contactInfoStatement = "Please visit http://www.atlassian.com/ex/GenerateLicense.jspa to obtain a license.";
            String allowedPkgPrefixesStr = license.getProperty("allowedpkgprefixes");
            if (allowedPkgPrefixesStr != null && allowedPkgPrefixesStr.trim().length() > 0) {
                this.allowedPkgPrefixes = new HashSet();
                StringTokenizer prefixes = new StringTokenizer(allowedPkgPrefixesStr, ", ");
                while (prefixes.hasMoreTokens()) {
                    this.allowedPkgPrefixes.add(prefixes.nextToken());
                }
            } else {
                this.allowedPkgPrefixes = null;
            }
            String edition = license.getProperty(CLOVER_EDITION_PROPERTY);
            this.desktop = CLOVER_EDITION_PROPERTY_DESKTOP.equalsIgnoreCase(edition);
            this.supportedFeatures = this.desktop ? -128L : -1L;
        }
        catch (NullPointerException e) {
            throw new CloverException("Invalid license data [E1300]. " + e.getMessage(), e);
        }
    }

    private void configureLoggingForExtras() {
        clover.com.atlassian.extras.common.log.Logger.setInstance(new LicenseLogger(Logger.getInstance()));
    }

    public CloverLicense(String name, String owner, String preExpiry, String postExpiry, String termination, String contactInfo, long softExpiryDate, long hardExpiryDate, long supportedFeatures) {
        this.productName = "Clover";
        this.licenseName = name;
        this.organisationName = owner;
        this.softExpiry = softExpiryDate;
        this.hardExpiry = hardExpiryDate;
        this.ownerStatement = "Clover Evaluation License registered to " + owner + ".";
        this.preExpiryStatement = preExpiry;
        this.postExpiryStatement = postExpiry;
        this.terminationStatement = termination;
        this.contactInfoStatement = contactInfo;
        this.supportedFeatures = supportedFeatures;
        this.allowedPkgPrefixes = null;
        this.supportEntitlementNumber = null;
        this.desktop = false;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public String getOrganisation() {
        return this.organisationName;
    }

    public String getSupportEntitlementNumber() {
        return this.supportEntitlementNumber;
    }

    public long getSoftExpiry() {
        return this.softExpiry;
    }

    public long getHardExpiry() {
        return this.hardExpiry;
    }

    public long getMaintExpiry() {
        return this.maintExpiry;
    }

    public boolean isDesktop() {
        return this.desktop;
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    public boolean isExpired(long time) {
        return this.expires() && time > this.softExpiry;
    }

    public boolean isTerminated() {
        return this.isTerminated(System.currentTimeMillis());
    }

    public boolean isTerminated(long time) {
        return this.terminates() && time > this.hardExpiry;
    }

    public boolean isMaintenanceExpired() {
        return this.isMaintenanceExpired(System.currentTimeMillis());
    }

    public boolean isMaintenanceExpired(long time) {
        return this.maintenanceExpires() && time > this.maintExpiry;
    }

    public boolean expires() {
        return this.softExpiry != 0L;
    }

    public boolean terminates() {
        return this.hardExpiry != 0L;
    }

    public boolean maintenanceExpires() {
        return this.maintExpiry != 0L;
    }

    public String getOwnerStatement() {
        return this.ownerStatement;
    }

    public String getPreExpiryStatement() {
        return this.preExpiryStatement;
    }

    public String getPostExpiryStatement() {
        return this.postExpiryStatement;
    }

    public String getContactInfoStatement() {
        return this.contactInfoStatement;
    }

    public String getTerminationStatement() {
        return this.terminationStatement;
    }

    public boolean isFeatureSupported(long feature) {
        return (this.supportedFeatures & feature) != 0L;
    }

    public long getFeaturesSupported() {
        return this.supportedFeatures;
    }

    Set getAllowedPkgPrefixes() {
        return this.allowedPkgPrefixes != null ? Collections.unmodifiableSet(this.allowedPkgPrefixes) : null;
    }

    public long getDaysTillExpiry() {
        return this.getDaysTillExpiry(System.currentTimeMillis());
    }

    public long getDaysTillExpiry(long now) {
        long days = this.countDays(this.softExpiry - now);
        return days < 0L ? 0L : days;
    }

    private long countDays(long aMilliseconds) {
        return aMilliseconds / 86400000L;
    }
}

