/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSet;
import clover.it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectCollection;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLong2ObjectMap
implements Long2ObjectMap,
Serializable {
    protected Object defRetValue;

    protected AbstractLong2ObjectMap() {
    }

    public void setDefRetValue(Object rv) {
        this.defaultReturnValue(rv);
    }

    public Object getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(Object rv) {
        this.defRetValue = rv;
    }

    public Object defaultReturnValue() {
        return this.defRetValue;
    }

    public Object put(long key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(long key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        long k = (Long)ok;
        return this.containsKey(k) ? this.get(k) : null;
    }

    public Object put(Object ok, Object ov) {
        long k = (Long)ok;
        Object v = this.put(k, ov);
        return this.containsKey(k) ? v : null;
    }

    public Object remove(Object ok) {
        long k = (Long)ok;
        Object v = this.remove(k);
        return this.containsKey(k) ? v : null;
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Long)ok);
    }

    public boolean containsValue(Object v) {
        return ((ObjectCollection)this.values()).contains(v);
    }

    public boolean containsKey(long k) {
        return ((LongSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Long2ObjectMap) {
            while (n-- != 0) {
                Long2ObjectMap.Entry e = (Long2ObjectMap.Entry)i.next();
                this.put(e.getLongKey(), e.getValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractLongSet(){

            public boolean contains(long k) {
                return AbstractLong2ObjectMap.this.containsKey(k);
            }

            public int size() {
                return AbstractLong2ObjectMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2ObjectMap.this.entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Long2ObjectMap.Entry)this.i.next()).getLongKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractObjectCollection(){

            public boolean contains(Object k) {
                return AbstractLong2ObjectMap.this.containsValue(k);
            }

            public int size() {
                return AbstractLong2ObjectMap.this.size();
            }

            public ObjectIterator objectIterator() {
                return new AbstractObjectIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2ObjectMap.this.entrySet().iterator();
                    }

                    public Object next() {
                        return ((Long2ObjectMap.Entry)this.i.next()).getValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Long2ObjectMap.Entry e = (Long2ObjectMap.Entry)i.next();
            s.append(String.valueOf(e.getLongKey()));
            s.append("=>");
            if (this == e.getValue()) {
                s.append("(this map)");
                continue;
            }
            s.append(String.valueOf(e.getValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2ObjectMap.Entry {
        protected long key;
        protected Object value;

        public BasicEntry(Object key, Object value) {
            this.key = (Long)key;
            this.value = value;
        }

        public BasicEntry(long key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

