/*
 * Decompiled with CFR 0.152.
 */
package clover.com.atlassian.extras.core;

import clover.com.atlassian.extras.api.LicenseManager;
import clover.com.atlassian.extras.api.Product;
import clover.com.atlassian.extras.core.DefaultAtlassianLicenseFactory;
import clover.com.atlassian.extras.core.DefaultLicenseManager;
import clover.com.atlassian.extras.core.ProductLicenseFactory;
import clover.com.atlassian.extras.core.bamboo.BambooProductLicenseFactory;
import clover.com.atlassian.extras.core.clover.CloverProductLicenseFactory;
import clover.com.atlassian.extras.core.confluence.ConfluenceProductLicenseFactory;
import clover.com.atlassian.extras.core.crowd.CrowdProductLicenseFactory;
import clover.com.atlassian.extras.core.crucible.CrucibleProductLicenseFactory;
import clover.com.atlassian.extras.core.fisheye.FisheyeProductLicenseFactory;
import clover.com.atlassian.extras.core.greenhopper.GreenHopperProductLicenseFactory;
import clover.com.atlassian.extras.core.jira.JiraProductLicenseFactory;
import clover.com.atlassian.extras.core.plugins.PluginLicenseFactory;
import clover.com.atlassian.extras.decoder.api.DelegatingLicenseDecoder;
import clover.com.atlassian.extras.decoder.api.LicenseDecoder;
import clover.com.atlassian.extras.decoder.v1.Version1LicenseDecoder;
import clover.com.atlassian.extras.decoder.v2.Version2LicenseDecoder;
import java.util.ArrayList;
import java.util.HashMap;

public final class LicenseManagerFactory {
    private static final LicenseManager LICENCE_MANAGER;

    public static LicenseManager getLicenseManager() {
        return LICENCE_MANAGER;
    }

    static {
        ArrayList<LicenseDecoder> delegateLicenseDecoders = new ArrayList<LicenseDecoder>();
        delegateLicenseDecoders.add(new Version2LicenseDecoder());
        delegateLicenseDecoders.add(new Version1LicenseDecoder());
        DelegatingLicenseDecoder licenseDecoder = new DelegatingLicenseDecoder(delegateLicenseDecoders);
        HashMap<Product, ProductLicenseFactory> licenseFactoryMap = new HashMap<Product, ProductLicenseFactory>();
        licenseFactoryMap.put(Product.JIRA, new JiraProductLicenseFactory());
        licenseFactoryMap.put(Product.CONFLUENCE, new ConfluenceProductLicenseFactory());
        licenseFactoryMap.put(Product.BAMBOO, new BambooProductLicenseFactory());
        licenseFactoryMap.put(Product.CROWD, new CrowdProductLicenseFactory());
        licenseFactoryMap.put(Product.CLOVER, new CloverProductLicenseFactory());
        licenseFactoryMap.put(Product.FISHEYE, new FisheyeProductLicenseFactory());
        licenseFactoryMap.put(Product.CRUCIBLE, new CrucibleProductLicenseFactory());
        licenseFactoryMap.put(Product.EDIT_LIVE_PLUGIN, new PluginLicenseFactory(Product.EDIT_LIVE_PLUGIN));
        licenseFactoryMap.put(Product.VSS_PLUGIN, new PluginLicenseFactory(Product.VSS_PLUGIN));
        licenseFactoryMap.put(Product.SHAREPOINT_PLUGIN, new PluginLicenseFactory(Product.SHAREPOINT_PLUGIN));
        licenseFactoryMap.put(Product.PERFORCE_PLUGIN, new PluginLicenseFactory(Product.PERFORCE_PLUGIN));
        licenseFactoryMap.put(Product.GREENHOPPER, new GreenHopperProductLicenseFactory());
        DefaultAtlassianLicenseFactory atlassianLicenseFactory = new DefaultAtlassianLicenseFactory(licenseFactoryMap);
        LICENCE_MANAGER = new DefaultLicenseManager(licenseDecoder, atlassianLicenseFactory);
    }
}

