/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template;

import info.bliki.wiki.filter.TemplateParser;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import info.bliki.wiki.template.expr.eval.DoubleEvaluator;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expr
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Expr();

    @Override
    public String parseFunction(List<String> list, IWikiModel model, char[] src, int beginIndex, int endIndex) throws IOException {
        if (list.size() > 0) {
            String expression = list.get(0);
            if (expression.length() == 0) {
                return null;
            }
            StringBuilder conditionBuffer = new StringBuilder(expression.length());
            TemplateParser.parse(expression, model, conditionBuffer, false);
            if (conditionBuffer.length() > 0) {
                try {
                    DoubleEvaluator engine = new DoubleEvaluator();
                    double d = engine.evaluate(conditionBuffer.toString());
                    double dInt = Math.rint(d);
                    if (Math.abs(dInt - d) < DoubleEvaluator.EPSILON) {
                        return Long.toString(Math.round(d));
                    }
                    String result = Double.toString(d);
                    return result.toUpperCase();
                }
                catch (Exception e) {
                    return "<div class=\"error\">Expression error: " + e.getMessage() + "</div>";
                }
            }
        }
        return null;
    }
}

