/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.api.AbstractXMLParser;
import info.bliki.api.Link;
import info.bliki.api.Page;
import info.bliki.api.PageInfo;
import info.bliki.api.Revision;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPagesParser
extends AbstractXMLParser {
    private static final String REV_ID = "rev";
    private static final String CATEGORY_ID = "cl";
    private static final String URL_ID = "url";
    private static final String THUMB_URL_ID = "thumburl";
    private static final String ANON_ID = "anon";
    private static final String PL_ID = "pl";
    private static final String TIMESTAMP_ID = "timestamp";
    private static final String IMAGEINFO_ID = "imageinfo";
    private static final String II_ID = "ii";
    private static final String EDIT_TOKEN_ID = "edittoken";
    private Page fPage;
    private Revision fRevision;
    private List<Page> pagesList = new ArrayList<Page>();

    public XMLPagesParser(String xmlText) throws SAXException {
        super(xmlText);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        this.fAttributes = atts;
        if ("page".equals(qName) || "p".equals(qName)) {
            this.fPage = new Page();
            this.fPage.setPageid(this.fAttributes.getValue("pageid"));
            this.fPage.setNs(this.fAttributes.getValue("ns"));
            this.fPage.setTitle(this.fAttributes.getValue("title"));
            this.fPage.setEditToken(this.fAttributes.getValue(EDIT_TOKEN_ID));
        } else if (REV_ID.equals(qName)) {
            this.fRevision = new Revision();
            this.fRevision.setAnon(this.fAttributes.getValue(ANON_ID));
            this.fRevision.setTimestamp(this.fAttributes.getValue(TIMESTAMP_ID));
            this.fPage.setCurrentRevision(this.fRevision);
        } else if (CATEGORY_ID.equals(qName)) {
            if (this.fPage != null) {
                PageInfo cat = new PageInfo();
                cat.setNs(this.fAttributes.getValue("ns"));
                cat.setTitle(this.fAttributes.getValue("title"));
                this.fPage.addCategory(cat);
            }
        } else if (PL_ID.equals(qName)) {
            if (this.fPage != null) {
                Link link = new Link();
                link.setNs(this.fAttributes.getValue("ns"));
                link.setTitle(this.fAttributes.getValue("title"));
                this.fPage.addLink(link);
            }
        } else if (II_ID.equals(qName) && this.fPage != null) {
            this.fPage.setImageUrl(this.fAttributes.getValue(URL_ID));
            this.fPage.setImageThumbUrl(this.fAttributes.getValue(THUMB_URL_ID));
        }
        this.fData = null;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        try {
            if (REV_ID.equals(qName)) {
                if (this.fRevision != null) {
                    this.fRevision.setContent(this.getString());
                }
            } else if (("page".equals(qName) || "p".equals(qName)) && this.fPage != null) {
                this.pagesList.add(this.fPage);
            }
            this.fData = null;
            this.fAttributes = null;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    public List<Page> getPagesList() {
        return this.pagesList;
    }
}

