/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.api.Link;
import info.bliki.api.PageInfo;
import info.bliki.api.Revision;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;

public class Page
extends PageInfo {
    List<Link> links = new ArrayList<Link>();
    List<PageInfo> categories = new ArrayList<PageInfo>();
    String editToken;
    String imageUrl = "";
    String imageThumbUrl;
    Revision revision = null;
    protected static final int BLOCK_SIZE = 8192;

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getImageThumbUrl() {
        return this.imageThumbUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setImageThumbUrl(String imageThumbUrl) {
        this.imageThumbUrl = imageThumbUrl;
    }

    public String toString() {
        String content = "";
        if (this.revision != null) {
            content = this.revision.getContent();
        }
        return "PageID: " + this.pageid + "; NS: " + this.ns + "; Title: " + this.title + "; \nImage url: " + this.imageUrl + "\nContent:\n" + content;
    }

    public boolean addCategory(PageInfo arg0) {
        return this.categories.add(arg0);
    }

    public boolean containsCategory(PageInfo o) {
        return this.categories.contains(o);
    }

    public PageInfo getCategory(int index) {
        return this.categories.get(index);
    }

    public int sizeOfCategoryList() {
        return this.categories.size();
    }

    public boolean addLink(Link arg0) {
        return this.links.add(arg0);
    }

    public boolean containsLink(Link o) {
        return this.links.contains(o);
    }

    public Link getLink(int index) {
        return this.links.get(index);
    }

    public String getEditToken() {
        return this.editToken;
    }

    public void setEditToken(String editToken) {
        this.editToken = editToken;
    }

    public void downloadImageUrl(OutputStream outputStream) {
        this.downloadImageUrl(outputStream, this.imageUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadImageUrl(OutputStream outputStream, String url) {
        if (url != null && url.length() > 3) {
            BufferedInputStream bis = null;
            GetMethod method = null;
            try {
                String extension2;
                HttpClient client = new HttpClient();
                client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
                client.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
                String extension = "jpg";
                int index = url.lastIndexOf(46);
                if (index > 0 && ((extension2 = url.substring(index + 1).toLowerCase()).equals("svg") || extension2.equals("gif") || extension2.equals("png") || extension2.equals("jpg") || extension2.equals("jpeg"))) {
                    extension = extension2;
                }
                method = new GetMethod(url);
                method.setFollowRedirects(false);
                method.setRequestHeader("accept", "image/" + extension);
                method.setRequestHeader("User-Agent", "plog4u.org/3.0");
                method.setFollowRedirects(false);
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode == 200) {
                    InputStream is = method.getResponseBodyAsStream();
                    bis = new BufferedInputStream(is);
                    byte[] b = new byte[8192];
                    int count = bis.read(b);
                    while (count != -1 && count <= 8192) {
                        outputStream.write(b, 0, count);
                        count = bis.read(b);
                    }
                    if (count != -1) {
                        outputStream.write(b, 0, count);
                    }
                }
            }
            catch (ConnectException e) {
                e.printStackTrace();
            }
            catch (HttpException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
    }

    public int sizeOfLinksList() {
        return this.links.size();
    }

    public Revision getCurrentRevision() {
        return this.revision;
    }

    public void setCurrentRevision(Revision revision) {
        this.revision = revision;
    }

    public String getCurrentContent() {
        String content = "";
        if (this.revision != null) {
            content = this.revision.getContent();
        }
        return content;
    }
}

