/*
 * Decompiled with CFR 0.152.
 */
package de.superx.transfer;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import de.memtext.db.DataSource;
import de.memtext.icons.MBStandardIcons;
import de.memtext.util.IconUtils;
import de.memtext.util.PlafUtils;
import de.memtext.util.WindowUtils;
import de.memtext.widgets.HorizontalBox;
import de.memtext.widgets.InfoMessage;
import de.memtext.widgets.MBFrame;
import de.memtext.widgets.VerticalBox;
import de.memtext.widgets.WarningMessage;
import de.superx.transfer.ActionPanel;
import de.superx.transfer.DataSourcePanel;
import de.superx.transfer.Target;
import de.superx.transfer.TargetPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;

public class TransferTool
extends MBFrame
implements ActionListener,
Observer {
    private JButton btnSave;
    private JPanel mainPanel;
    private JComboBox cbExtractionJob;
    private JComboBox cbDataSource;
    private Vector extractionJobs = new Vector();
    private Vector datasources = new Vector();
    private Vector targets = new Vector();
    HorizontalBox centerBox = new HorizontalBox();
    private boolean isAllSaved = true;
    static final Color TARGET_COLOR = new Color(63, 176, 239);
    static final Color DATASOURCE_COLOR = new Color(111, 237, 204);
    public static final String TITLE = "SuperX Transfer Tool";
    private Font headerFont = new Font("SansSerif", 1, 16);

    TransferTool() {
        super(TITLE);
        this.setIconImage(IconUtils.get("de/superx/transfer/transferIcon.gif").getImage());
        try {
            UIManager.setLookAndFeel((LookAndFeel)new KunststoffLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e2) {
            PlafUtils.setWindowsLook(this);
        }
        this.mainPanel = new JPanel(new BorderLayout());
        VerticalBox top = this.initTop();
        this.mainPanel.add((Component)top, "North");
        this.initDataSources();
        this.centerBox.addGlue();
        this.centerBox.addStrut(20);
        ActionPanel actionPanel = new ActionPanel();
        actionPanel.addObserver(this);
        this.centerBox.add(actionPanel);
        this.centerBox.addStrut(20);
        this.centerBox.addGlue();
        this.initTargets();
        this.mainPanel.add(this.centerBox);
        this.setCenter(this.mainPanel);
        this.initBottom();
        this.pack();
        WindowUtils.center(this);
    }

    private void initBottom() {
        JPanel pSouth = new JPanel(new FlowLayout(2));
        this.btnSave = new JButton("\u00c4nderungen speichern", MBStandardIcons.get("floppy.gif"));
        this.btnSave.addActionListener(this);
        this.btnSave.setEnabled(false);
        pSouth.add(this.btnSave);
        JButton btnInfoBatch = new JButton("Info zum Batchmodus", MBStandardIcons.get("i.gif"));
        btnInfoBatch.addActionListener(this);
        pSouth.add(btnInfoBatch);
        this.mainPanel.add((Component)pSouth, "South");
    }

    private VerticalBox initTop() {
        VerticalBox top = new VerticalBox();
        JLabel lblTitle = new JLabel(TITLE);
        lblTitle.setFont(new Font("SansSerif", 1, 20));
        top.addWithCenterAlignment(lblTitle);
        this.extractionJobs.add("SOSPOS Export f\u00fcr Uni-Assist");
        this.cbExtractionJob = new JComboBox(this.extractionJobs);
        top.addWithCenterAlignment(this.cbExtractionJob);
        top.addStrut(40);
        return top;
    }

    private void initTargets() {
        Target t = new Target("Assist WebDAV-Server");
        this.targets.add(t);
        t = new Target("FTP-Server HIS");
        this.targets.add(t);
        TargetPanel targetPanel = new TargetPanel(this.targets);
        targetPanel.addObserver(this);
        JPanel dummyp = new JPanel();
        dummyp.setBackground(TARGET_COLOR);
        dummyp.add(targetPanel);
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Ziel", 2, 2, this.headerFont);
        dummyp.setBorder(border);
        this.centerBox.add(dummyp);
    }

    private void initDataSources() {
        DataSource dsInformix = new DataSource();
        dsInformix.setName("sospos_informix");
        dsInformix.setInformixSampleValues();
        DataSource dsAccess = new DataSource();
        dsAccess.setAccessSampleValues();
        dsAccess.setName("sospos_access");
        this.datasources.add(dsAccess);
        this.datasources.add(dsInformix);
        DataSourcePanel dsp = new DataSourcePanel(this.datasources);
        dsp.addObserver(this);
        JPanel dummyp = new JPanel();
        dummyp.setBackground(DATASOURCE_COLOR);
        dummyp.add(dsp);
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Datenquelle", 2, 2, this.headerFont);
        dummyp.setBorder(border);
        this.centerBox.add(dummyp);
    }

    public static void main(String[] args) {
        TransferTool et = new TransferTool();
        et.show();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getActionCommand().equals("\u00c4nderungen speichern")) {
            this.save();
        }
        if (e2.getActionCommand().equals("Info zum Batchmodus")) {
            if (System.getProperty("os.name").indexOf("Windows") > -1) {
                InfoMessage.show((Component)this, "Durch Aufruf der Datei\n  sosUniAssist.bat\nwird der Transfer automatisch vorgenommen.", TITLE);
            } else {
                InfoMessage.show((Component)this, "Durch Aufruf der Datei\n  sosUniAssist.sh\nwird der Transfer automatisch vorgenommen.", TITLE);
            }
        }
    }

    private void save() {
        try {
            XMLEncoder e2 = new XMLEncoder(new BufferedOutputStream(new FileOutputStream("datasources.xml")));
            e2.writeObject(this.datasources);
            e2.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            WarningMessage.show((Component)this, "Speichern fehlgeschlagen\n" + e1, TITLE);
        }
    }

    private void setDirty() {
        this.isAllSaved = false;
        this.btnSave.setEnabled(true);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setDirty();
    }
}

