/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.DBAccess;
import de.superx.servlet.TokenChecker;
import de.superx.servlet.UserAndRightsStreamliner;
import java.sql.Connection;
import java.sql.DriverManager;
import junit.framework.TestCase;

public class TokenCheckerTest
extends TestCase {
    private Connection con;
    private int sachgebieteCount = 0;
    private int viewSachgebieteCount = 0;
    private int adminSachgebieteCount = 0;

    public TokenCheckerTest() {
        try {
            Class.forName("org.postgresql.Driver");
            this.con = DriverManager.getConnection("jdbc:postgresql://localhost:5433/eduetl_dummy", "superx", "password");
            this.con.createStatement();
            DBAccess.addConnection("superx", this.con);
            this.sachgebieteCount = DBAccess.get("superx").getInt("select count(*) from sachgebiete");
            this.viewSachgebieteCount = DBAccess.get("superx").getInt("select count(*) from sachgebiete where rightname  not like '%CS_BIA_STANDARDREPORTS_ADMIN%'");
            this.adminSachgebieteCount = DBAccess.get("superx").getInt("select count(*) from sachgebiete where rightname   like '%CS_BIA_STANDARDREPORTS_ADMIN%'");
        }
        catch (Exception cnfe) {
            cnfe.printStackTrace();
            System.exit(1);
        }
    }

    public void testBIAdminRole() {
        String token = "1.0/1309953513/superx/meikel/bi_admin///1/11/08fe5c9b29ee453a090ca4fa257a4d43";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)0, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertEquals((int)0, (int)this.getUserInstCount(user));
    }

    public void testTechAdmin() {
        String token = "1.0/1309953513/superx/meikel/admin///1/11/fe5c9b29ee453a090ca4fa257a4d43";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)0, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertEquals((int)0, (int)this.getUserInstCount(user));
        TokenCheckerTest.assertFalse((boolean)this.hasUserInst(user, "0"));
    }

    public void testAdminViewAlleSachgebiete() {
        String token = "1.0/1309953513/superx/stud/bistud/9/RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS,RIGHT_CS_BIA_STANDARDREPORTS_ADMIN/1/11/08fe5c9b29ee453a090ca4fa257a4d43";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)this.sachgebieteCount, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasUserInst(user, "0"));
        TokenCheckerTest.assertTrue((this.isAdminInUserInfo(user) == 1 ? 1 : 0) != 0);
        TokenCheckerTest.assertTrue((this.hasAdminSachgeb(user) == 1 ? 1 : 0) != 0);
    }

    public void testAdminAlleSachgebiete() {
        String token = "1.0/1309953513/superx/stud/bistud/9/RIGHT_CS_BIA_STANDARDREPORTS_ADMIN/1/11/08fe5c9b29ee453a090ca4fa257a4d43";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)this.sachgebieteCount, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasUserInst(user, "0"));
        TokenCheckerTest.assertTrue((this.isAdminInUserInfo(user) == 1 ? 1 : 0) != 0);
        TokenCheckerTest.assertTrue((this.hasAdminSachgeb(user) == 1 ? 1 : 0) != 0);
    }

    private void checkNotAdminAndInst9(String user) {
        TokenCheckerTest.assertEquals((int)1, (int)this.getUserInstCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasUserInst(user, "06"));
        TokenCheckerTest.assertTrue((this.isAdminInUserInfo(user) == 0 ? 1 : 0) != 0);
        TokenCheckerTest.assertTrue((this.hasAdminSachgeb(user) == 0 ? 1 : 0) != 0);
        TokenCheckerTest.assertTrue((this.isInAdminGroup(user) == 0 ? 1 : 0) != 0);
    }

    public void testViewAlleSachgebiete() {
        String token = "1.0/1309953513/superx/stud/bistud/9/RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS/1/11/08fe5c9b29ee453a090ca4fa257a4d43";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)this.viewSachgebieteCount, (int)this.getUserSachgebCount(user));
        this.checkNotAdminAndInst9(user);
    }

    public void testViewAlleAdminStud() {
        String token = "1.0/1310722422/superx/studadmin/studadminrole/9/RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS,RIGHT_CS_BIA_STANDARDREPORTS_ADMIN[edustore.topic_area=stu]/1/11/6fcf981a308d475b16b1290754dd8f3e";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)(this.viewSachgebieteCount + 1), (int)this.getUserSachgebCount(user));
        this.checkNotAdminAndInst9(user);
    }

    public void testAdminViewStud() {
        String token = "1.0/1309954039/superx/stud/bistud/9/RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS[edustore.topic_area=stu],RIGHT_CS_BIA_STANDARDREPORTS_ADMIN[edustore.topic_area=stu]/1/11/9687a8350101933fd8b6de8df39e3ec7";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)2, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 16));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 41));
        this.checkNotAdminAndInst9(user);
    }

    public void testViewStud() {
        String token = "1.0/1309954039/superx/stud/bistud/9/RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS[edustore.topic_area=stu]/1/11/9687a8350101933fd8b6de8df39e3ec7";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)1, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 16));
        this.checkNotAdminAndInst9(user);
    }

    public void testAdminStud() {
        String token = "1.0/1309954039/superx/stud/bistud/9/RIGHT_CS_BIA_STANDARDREPORTS_ADMIN[edustore.topic_area=stu]/1/11/9687a8350101933fd8b6de8df39e3ec7";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)1, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 41));
        this.checkNotAdminAndInst9(user);
    }

    public void testAdminViewIVS() {
        String token = "1.0/1309954039/superx/stud/bistud/9/RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS[edustore.topic_area=opm],RIGHT_CS_BIA_STANDARDREPORTS_ADMIN[edustore.topic_area=opm]/1/11/9687a8350101933fd8b6de8df39e3ec7";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)2, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 140));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 141));
        this.checkNotAdminAndInst9(user);
    }

    public void testAdminStudViewCob() {
        String token = "1.0/1310723675/superx/stud/studadminrole/9/RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS[edustore.topic_area=coa],RIGHT_CS_BIA_STANDARDREPORTS_ADMIN[edustore.topic_area=stu]/1/11/76adf989f610500a58828b3a27d6be58";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)2, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 27));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 41));
        this.checkNotAdminAndInst9(user);
    }

    public void testViewIVS() {
        String token = "1.0/1309954039/superx/stud/bistud/9/RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS[edustore.topic_area=opm]/1/11/9687a8350101933fd8b6de8df39e3ec7";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)1, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 140));
        this.checkNotAdminAndInst9(user);
    }

    public void testAdminIVS() {
        String token = "1.0/1309954039/superx/stud/bistud/9/RIGHT_CS_BIA_STANDARDREPORTS_ADMIN[edustore.topic_area=opm]/1/11/9687a8350101933fd8b6de8df39e3ec7";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)1, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 141));
        this.checkNotAdminAndInst9(user);
    }

    public void testAdminViewIVS_STUD() {
        String token = "1.0/1309954039/superx/stud/bistud/9/RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS[edustore.topic_area=opm,stu],RIGHT_CS_BIA_STANDARDREPORTS_ADMIN[edustore.topic_area=opm,stu]/1/11/9687a8350101933fd8b6de8df39e3ec7";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)4, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 140));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 141));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 16));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 41));
        this.checkNotAdminAndInst9(user);
    }

    public void testViewIVS_STUD() {
        String token = "1.0/1309954039/superx/stud/bistud/9/RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS[edustore.topic_area=stu]/1/11/9687a8350101933fd8b6de8df39e3ec7";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)1, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 16));
        this.checkNotAdminAndInst9(user);
    }

    public void testAdminIVS_STUD() {
        String token = "1.0/1309954039/superx/stud/bistud/9/RIGHT_CS_BIA_STANDARDREPORTS_ADMIN[edustore.topic_area=opm,stu]/1/11/9687a8350101933fd8b6de8df39e3ec7";
        String user = this.streamlineToken(token);
        TokenCheckerTest.assertEquals((int)2, (int)this.getUserSachgebCount(user));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 141));
        TokenCheckerTest.assertTrue((boolean)this.hasSachgeb(user, 41));
        this.checkNotAdminAndInst9(user);
    }

    private boolean hasSachgeb(String user, int sachgeb) {
        return DBAccess.get("superx").getInt("select count(*) from user_sachgeb_bez where sachgebiete_id=" + sachgeb + " and userinfo_id=(select tid from userinfo where benutzer='" + user + "')") == 1;
    }

    private String streamlineToken(String token) {
        String user = null;
        try {
            TokenChecker.checkingActive = false;
            TokenChecker tc = new TokenChecker(token);
            UserAndRightsStreamliner str = new UserAndRightsStreamliner("default");
            str.streamline(this.con, tc);
            user = tc.getKennung();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return user;
    }

    private boolean hasUserInst(String userid, String inst) {
        String read = "select count(*) from user_institution where userid=(select tid from userinfo where benutzer='" + userid + "') and ch110_institut='" + inst + "'";
        return DBAccess.get("superx").getInt(read) == 1;
    }

    private int getUserSachgebCount(String user) {
        return DBAccess.get("superx").getInt("select count(*) from user_sachgeb_bez where userinfo_id=(select tid from userinfo where benutzer='" + user + "')");
    }

    private int getUserInstCount(String user) {
        return DBAccess.get("superx").getInt("select count(*) from user_institution where   userid=(select tid from userinfo where benutzer='" + user + "')");
    }

    private int isAdminInUserInfo(String user) {
        return DBAccess.get("superx").getInt("select administration from userinfo where benutzer='" + user + "'");
    }

    private int hasAdminSachgeb(String user) {
        return DBAccess.get("superx").getInt("select count(*) from user_sachgeb_bez where sachgebiete_id=0 and userinfo_id=(select tid from userinfo where benutzer='" + user + "')");
    }

    private int isInAdminGroup(String user) {
        return DBAccess.get("superx").getInt("select count(*) from user_group_bez where  userinfo_id=(select tid from userinfo where benutzer='" + user + "')\tand groupinfo_id=(select tid from groupinfo where name='Administratoren')");
    }
}

