/*
 * Decompiled with CFR 0.152.
 */
package de.superx.applet;

import de.memtext.util.ClipboardUtils;
import de.memtext.util.DateUtils;
import de.memtext.util.WindowUtils;
import de.memtext.widgets.HorizontalBox;
import de.memtext.widgets.VerticalBox;
import de.memtext.widgets.WarningMessage;
import de.superx.applet.ConnectionDlg;
import de.superx.applet.ExplanationFrame;
import de.superx.applet.MaskeninfoElement;
import de.superx.applet.Sachgebiete;
import de.superx.applet.SichtApplet;
import de.superx.applet.SuperX;
import de.superx.applet.SxDate;
import de.superx.applet.SxDefaults;
import de.superx.applet.SxDlgListener;
import de.superx.applet.SxDlgManager;
import de.superx.applet.SxField;
import de.superx.applet.SxForm;
import de.superx.applet.SxLogoPanel;
import de.superx.applet.SxPasswdChangeDlg;
import de.superx.applet.SxSQL;
import de.superx.applet.SxSQLMetaData;
import de.superx.applet.SxTablePanel;
import de.superx.applet.SxThemenbaum;
import de.superx.applet.SxUtils;
import de.superx.applet.SxWaitCursor;
import de.superx.common.DBServletException;
import de.superx.common.Sichten;
import de.superx.common.Sichtgruppe;
import de.superx.common.SxResultRow;
import de.superx.common.SxUser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SxMask
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    private static final Font SMALL_BOLD_FONT = new Font("SansSerif", 1, 10);
    private static final Font NORMAL_BOLD_FONT = new Font("SansSerif", 1, 12);
    private static final Font NORMAL_FONT = new Font("SansSerif", 0, 12);
    private static final Font SMALL_FONT = new Font("SansSerif", 0, 10);
    private SxUser user = new SxUser();
    private static boolean isApplet = false;
    private static boolean isLogin = false;
    private boolean helpsetfound = false;
    private static int countFrame = 0;
    private boolean dummyLogin = false;
    private JFrame sxFrame;
    private SxMask sxMask;
    private SxLogoPanel logo;
    private Hashtable sx_map = null;
    private Thread activeThread = null;
    private boolean isInterrupted = false;
    private JTabbedPane tabPane;
    private ConnectionDlg connectionDlg;
    private ExplanationFrame explanationFrame = new ExplanationFrame();
    private JButton btnExplanation = new JButton("Erl\u00e4uterung");
    private MaskeninfoElement selectedMaskeninfoElement = new MaskeninfoElement();
    private String sxTitle;
    private String serverURL;
    private String logToKonsole;
    private ParameterPanel parameterPanel = new ParameterPanel();
    private Vector V_thema = new Vector(100);
    private SxTablePanel sxTablePanel = null;
    private Integer lastMaskeID = new Integer(-1);
    private JButton dbBtn;
    private JButton openBtn;
    private JButton searchBtn;
    private JButton resetBtn;
    private JButton stopBtn;
    private JButton themenAuswahlBtn;
    private JButton cloneBtn;
    private JButton copyBtn;
    private JButton saveBtn;
    private JButton printBtn;
    private JButton infoBtn;
    private JButton passwdBtn;
    private JScrollPane themenwahlscroll;
    private JTree themenwahltree;
    private GridBagConstraints gbctree = new GridBagConstraints();
    private GridBagLayout gbl = new GridBagLayout();
    JEditorPane terlaeuterung = new JEditorPane("text/html", "");
    private JButton suchAbfrBtn;
    private JButton themenStandBtn;
    private JButton helpBtn;
    private SxThemenbaum sxThemenbaum;
    private JLabel themenStandLabel;
    private JLabel aktuelleNachrichtL;
    private SxForm maskeForm;
    private JPanel sxSpanel;
    private JTextField statusField;
    private HelpSet hs;
    private HelpBroker hb;
    private String helpItemString = "SuperXAnleitung.htm";

    public SxMask(String title, Hashtable img_map, boolean ifApplet) {
        isApplet = ifApplet;
        this.sxMask = this;
        this.sx_map = img_map;
        this.sxFrame = new JFrame(title);
        this.init();
        this.sxFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                SxMask.this.close();
            }
        });
        this.sxFrame.getContentPane().add((Component)this.sxMask, "Center");
        if (++countFrame > 1) {
            try {
                this.installThemenbaum(DateUtils.getTodayString());
            }
            catch (SQLException e1) {
                ClipboardUtils.setContents(e1.toString(), null);
                WarningMessage.show((Component)this.sxMask, e1.toString(), "Fehler");
            }
        }
        this.sxFrame.pack();
        this.sxFrame.setBounds(100 + countFrame * 50, 100 + countFrame * 50, 600, 500);
        this.sxFrame.setVisible(true);
        this.connectionDlg = new ConnectionDlg(this.user);
    }

    private void installThemenbaum(String date) throws SQLException {
        this.sxThemenbaum = new SxThemenbaum(this.sxMask);
        this.themenwahltree = this.sxThemenbaum.getTree(date);
        this.themenwahlscroll.setViewportView(this.themenwahltree);
        this.openBtn.setEnabled(true);
    }

    void clearThemenbaum() {
        this.themenwahltree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Abfragen")));
    }

    public int showConnectionDialog() {
        int rc = -999;
        if (!this.dummyLogin) {
            rc = this.connectionDlg.showDlg(this.getFrame());
            this.user.setName(this.connectionDlg.getUserName());
            this.user.setPasswd(this.connectionDlg.getPassword());
        } else {
            rc = 0;
            this.user.setName("admin");
            this.user.setPasswd("anfang12");
        }
        return rc;
    }

    protected void addMouseListenerToLogo() {
        MouseAdapter listMouseListenerToLogo = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                int button1 = e2.getModifiers() & 0x10;
                if (button1 != 0 && SxMask.this.activeThread != null) {
                    try {
                        SxMask.this.activeThread.interrupt();
                    }
                    catch (Exception ex) {
                        System.err.println(ex.toString());
                    }
                }
            }
        };
        this.logo.addMouseListener(listMouseListenerToLogo);
    }

    public synchronized void close() {
        --countFrame;
        if (SxSQL.isActive()) {
            try {
                SxSQL.close();
            }
            catch (Exception ex) {
                System.err.println(ex.toString());
            }
        }
        if (countFrame <= 1) {
            this.connectionDlg.setPassword("");
            this.user.setPasswd("");
        }
        if (countFrame <= 0) {
            isLogin = false;
            this.clearThemenbaum();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e2) {
    }

    @Override
    public void componentMoved(ComponentEvent e2) {
    }

    @Override
    public void componentResized(ComponentEvent e2) {
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e2) {
    }

    protected void createMask() throws SQLException, DBServletException {
        int oldx = 20;
        int oldy = 20;
        int leftmargin = 20;
        int x_ofs = 20;
        int y_ofs = 20;
        int oldnw = 0;
        int oldfw = 0;
        Object fieldname = null;
        Object relation = null;
        Object attribut = null;
        Object fielddefault = null;
        String sx_db = (String)SxDefaults.getPropertyValue("SxDB");
        this.maskeForm.removeAll();
        this.maskeForm.addComp(this.selectedMaskeninfoElement.getName(), "M_headline", "JLabel", 0, 0, 0, 0);
        this.maskeForm.setPreferredCompWidth("M_headline", 500);
        this.maskeForm.setCompXY("M_headline", 20, 20);
        JLabel L_M_headline = (JLabel)this.maskeForm.getComp("M_headline");
        L_M_headline.setFont(new Font("SansSerif", 1, 14));
        this.lastMaskeID = new Integer(-1);
        this.sxTablePanel.setData(new Vector(), new Vector(), new Vector(), null);
        int m_breite = this.selectedMaskeninfoElement.getBreite();
        int m_hoehe = this.selectedMaskeninfoElement.getHoehe();
        this.maskeForm.addComp("UserID", "L_UserID", "JLabel", 0, 0, 0, 0);
        JLabel L_userid = (JLabel)this.maskeForm.getComp("L_UserID");
        L_userid.setVisible(false);
        this.maskeForm.addComp(SxSQL.getUserID().toString(), "F_UserID", "SxField", 0, 1, 4, 0);
        SxField F_userid = (SxField)this.maskeForm.getComp("F_UserID");
        F_userid.setVisible(false);
        this.addIndividualFields(oldy, leftmargin, x_ofs, y_ofs, oldnw, oldfw, sx_db);
        this.maskeForm.setFieldVector(this.selectedMaskeninfoElement.getFelderinfos());
        this.maskeForm.restoreValuesFromFormerSelections();
        this.maskeForm.setDefaultBtn(this.searchBtn);
        int diff_height = 0;
        this.maskeForm.revalidate();
        this.maskeForm.setPreferredSize(new Dimension(m_breite, m_hoehe));
        Rectangle m_rect = new Rectangle(0, 0, m_breite, m_hoehe);
        Rectangle f_rect = this.maskeForm.getBounds();
        Container toplevel = this.maskeForm.getTopLevelAncestor();
        Rectangle top_rect = toplevel.getBounds();
        if (!f_rect.contains(m_rect)) {
            diff_height = m_rect.height - f_rect.height;
            f_rect.width += m_rect.width - f_rect.width + 5;
            f_rect.height += m_rect.height - f_rect.height;
        }
        if (!top_rect.contains(f_rect)) {
            top_rect.width += f_rect.width - top_rect.width;
        }
        top_rect.height += diff_height;
        if (top_rect.height > 600) {
            top_rect.height = 600;
        }
        toplevel.setBounds(top_rect);
        this.sxFrame.invalidate();
        this.sxFrame.validate();
        this.sxFrame.repaint();
    }

    private void addIndividualFields(int oldy, int leftmargin, int x_ofs, int y_ofs, int oldnw, int oldfw, String sx_db) throws SQLException, DBServletException {
        SichtApplet defaultsicht = null;
        int i2 = 0;
        while (i2 < this.selectedMaskeninfoElement.getFelderinfos().size()) {
            String fielddefault;
            String attribut;
            int buttonbreite;
            int y;
            defaultsicht = null;
            Vector V_field = (Vector)this.selectedMaskeninfoElement.getFelderinfos().elementAt(i2);
            String fieldname = (String)V_field.elementAt(1);
            if (fieldname != null) {
                fieldname = fieldname.trim();
            }
            SxSQL.executeQuery("select contents_short, contents_long  from sx_captions  where table_name='felderinfo'  and field_name='" + fieldname + "' and (record_no is null or record_no=" + V_field.elementAt(0) + ")");
            Vector v_captions = SxSQL.getResultVector();
            String erl\u00e4uterung = "";
            String fieldCaption = fieldname;
            if (v_captions.size() > 0) {
                Vector row = (Vector)v_captions.get(0);
                String cap = (String)row.get(0);
                if (cap != null) {
                    fieldCaption = cap;
                }
                erl\u00e4uterung = (String)row.get(1);
            }
            int fieldnr = (Integer)V_field.elementAt(2);
            int x = (Integer)V_field.elementAt(3);
            if (x == 0) {
                x += leftmargin;
            }
            if (x < 0) {
                x = 0;
            }
            if ((y = ((Integer)V_field.elementAt(4)).intValue()) == 0) {
                y = oldy + 25 + y_ofs;
            }
            if (y == -1) {
                x += 2 * x_ofs;
                y = oldy;
            }
            buttonbreite = (buttonbreite = ((Integer)V_field.elementAt(5)).intValue()) == 0 ? oldnw : (buttonbreite += x_ofs);
            int feldbreite = (Integer)V_field.elementAt(6);
            if (feldbreite == 0) {
                feldbreite = oldfw;
            }
            int zeilenanzahl = (Integer)V_field.elementAt(7);
            String typ = (String)V_field.elementAt(8);
            if (typ != null) {
                typ = typ.trim();
            }
            int laenge = (Integer)V_field.elementAt(9);
            int obligatorisch = (Integer)V_field.elementAt(10);
            int art = (Integer)V_field.elementAt(11);
            String relation = (String)V_field.elementAt(12);
            if (relation != null) {
                relation = relation.trim();
            }
            if ((attribut = (String)V_field.elementAt(13)) != null) {
                attribut = attribut.trim();
            }
            if ((fielddefault = (String)V_field.elementAt(14)) != null) {
                fielddefault = fielddefault.trim();
            }
            if (art > 0 && art <= 7 || art == 12) {
                defaultsicht = this.addButtonField(fieldname, fieldCaption, obligatorisch, art, relation, zeilenanzahl, erl\u00e4uterung, i2);
            } else {
                this.addLabelField(fieldname, x, y, buttonbreite, obligatorisch);
            }
            JComponent comp = this.maskeForm.getComp("L_" + fieldname);
            if (art == 13 || art == 15) {
                comp.setVisible(false);
            }
            comp.setToolTipText(erl\u00e4uterung);
            FontMetrics font_m = comp.getFontMetrics(comp.getFont());
            int label_width = font_m.stringWidth(fieldCaption) + 10;
            this.maskeForm.setPreferredCompWidth("L_" + fieldname, label_width);
            this.maskeForm.setCompXY("L_" + fieldname, x + buttonbreite - label_width, y);
            String field_type = "SxField";
            if (zeilenanzahl > 1) {
                field_type = "JComboBox";
            }
            if (art == 10) {
                field_type = "JCheckbox";
            }
            if (art == 11) {
                field_type = "JPasswordField";
            }
            if (art != 8 && art != 13 && art != 15) {
                if (typ.toLowerCase().equals("integer")) {
                    this.maskeForm.addComp("", "F_" + fieldname, field_type, 0, 1, laenge, obligatorisch);
                }
                if (typ.toLowerCase().equals("date")) {
                    this.maskeForm.addComp("", "F_" + fieldname, field_type, 0, 3, laenge, obligatorisch);
                }
                if (typ.toLowerCase().equals("char")) {
                    this.maskeForm.addComp("", "F_" + fieldname, field_type, 0, 0, laenge, obligatorisch);
                }
                if (typ.toLowerCase().equals("decimal")) {
                    this.maskeForm.addComp("", "F_" + fieldname, field_type, 0, 2, laenge, obligatorisch);
                }
                if (typ.toLowerCase().equals("sql")) {
                    this.maskeForm.addComp("", "F_" + fieldname, field_type, 0, 4, laenge, obligatorisch);
                }
                this.maskeForm.setPreferredCompWidth("F_" + fieldname, feldbreite);
                this.maskeForm.setCompXY("F_" + fieldname, x_ofs + buttonbreite + x, y);
                SxField valuefield = this.maskeForm.getField("F_" + fieldname);
                if (art == 1 || art == 12) {
                    valuefield.setEditable(false);
                }
                if (defaultsicht != null) {
                    valuefield.setSelectedSicht(defaultsicht);
                }
                this.setFieldDefault(sx_db, fieldname, art, fielddefault, valuefield);
            }
            int oldx = x;
            oldy = y;
            oldnw = buttonbreite;
            oldfw = feldbreite;
            ++i2;
        }
    }

    private void setFieldDefault(String sx_db, String fieldname, int art, String fielddefault, SxField field) {
        if (fielddefault != null) {
            String stmt = "";
            if (fielddefault.startsWith("<<SQL>>") || fielddefault.startsWith("sp_")) {
                this.readFieldDefaultFromDb(sx_db, fieldname, fielddefault, field, stmt);
            } else {
                if (field != null) {
                    field.setText(fielddefault);
                }
                field.setKey(new Integer(-1));
            }
            if (art == 4 || art == 6 || art == 7 || art == 12) {
                field.setKey("null");
                field.setDefaultValue("null");
            }
        }
    }

    private void readFieldDefaultFromDb(String sx_db, String fieldname, String fielddefault, SxField field, String stmt) {
        try {
            Object value;
            Object key;
            stmt = fielddefault;
            if (fielddefault.startsWith("<<SQL>>")) {
                stmt = fielddefault.substring(7);
            }
            if ((stmt = stmt.trim()).startsWith("sp_")) {
                stmt = sx_db.equals("Postgres") ? "select " + stmt : "execute procedure " + stmt;
            }
            stmt = SxUtils.generateSQL(this.maskeForm, stmt);
            SxSQL.executeAll(stmt);
            Vector result = SxSQL.getResultVector();
            if (result.size() == 0) {
                throw new IllegalStateException("Defaultwert konnte nicht ermittelt werden, da der select nichts lieferte.");
            }
            Vector V_default = (Vector)result.elementAt(0);
            if (V_default.size() == 2) {
                key = V_default.elementAt(0);
                field.setKey(key);
                value = V_default.elementAt(1);
                if (value instanceof java.sql.Date) {
                    value = SxDate.toString((java.sql.Date)value);
                }
                field.setText(value.toString());
            }
            if (V_default.size() == 1) {
                key = value = V_default.elementAt(0);
                if (value instanceof java.sql.Date) {
                    value = SxDate.toString((java.sql.Date)value);
                }
                field.setText(value.toString());
            }
        }
        catch (Exception ex) {
            System.out.println("Fehler beim Lesen von Defaultwert f\u00fcr Feld " + fieldname + "\n Sql-stmt=" + stmt);
            ex.printStackTrace();
        }
    }

    private void addLabelField(String fieldname, int x, int y, int buttonbreite, int obligatorisch) {
        this.maskeForm.addComp(fieldname, "L_" + fieldname, "JLabel", 0, 0, 0, 0);
        this.maskeForm.setPreferredCompWidth("L_" + fieldname, buttonbreite);
        this.maskeForm.setCompXY("L_" + fieldname, x, y);
        JLabel L_fieldname = (JLabel)this.maskeForm.getComp("L_" + fieldname);
        L_fieldname.setHorizontalAlignment(4);
        if (obligatorisch != 0) {
            L_fieldname.setFont(NORMAL_BOLD_FONT);
        } else {
            L_fieldname.setFont(NORMAL_FONT);
        }
    }

    private SichtApplet addButtonField(String fieldname, String fieldCaption, int obligatorisch, int art, String relation, int zeilenanzahl, String erl\u00e4uterung, int i2) throws SQLException, DBServletException {
        SichtApplet defaultsicht = null;
        this.maskeForm.addComp(fieldCaption, "L_" + fieldname, "JButton", 0, 0, 0, 0);
        JButton btn = (JButton)this.maskeForm.getComp("L_" + fieldname);
        btn.setHorizontalAlignment(4);
        if (obligatorisch != 0) {
            btn.setFont(NORMAL_BOLD_FONT);
        } else {
            btn.setFont(NORMAL_FONT);
        }
        Sichtgruppe sichtgruppe = null;
        if (art == 4 || art == 6 || art == 7 || art == 12) {
            Vector<Integer> sichtentids = new Vector<Integer>();
            try {
                if (art == 12 && relation != null && relation.startsWith("<<SQL>>")) {
                    SxSQL.executeQuery(relation.substring(7));
                    Vector result = SxSQL.getResultVector();
                    for (Vector aRow : result) {
                        Integer eineSichtTid = (Integer)aRow.get(0);
                        sichtentids.add(eineSichtTid);
                    }
                }
                sichtgruppe = this.user.getSichten().getGruppe(fieldname, art, sichtentids, relation, zeilenanzahl, this.maskeForm.getDefaultStand());
            }
            catch (Exception e2) {
                String msg = "Konnte Sichten nicht einlesen:" + e2.toString();
                ClipboardUtils.setContents(msg, null);
                WarningMessage.show((Component)this.sxMask, msg, "SuperX");
                e2.printStackTrace();
            }
        }
        SxDlgListener dlgl = new SxDlgListener(this.sxMask, this.maskeForm, btn, erl\u00e4uterung, i2, art);
        if (sichtgruppe != null) {
            defaultsicht = (SichtApplet)sichtgruppe.getSelectedSicht();
            dlgl.setSichtgruppe(sichtgruppe);
        }
        btn.addActionListener(dlgl);
        return defaultsicht;
    }

    void initUser(int mode) {
        try {
            this.stopBtn.setEnabled(true);
            this.statusField.setBackground(Color.yellow);
            if (mode == 0) {
                this.logo.start();
                if (SxSQL.isActive()) {
                    SxSQL.close();
                }
                SxDlgManager.clear();
                SxDefaults.clear();
                SxDefaults.init();
                this.V_thema = null;
                this.user.getSichten().clear();
                this.statusField.setText("Anmelden ..");
                this.passwdBtn.setEnabled(false);
                this.passwdBtn.setVisible(SuperX.remoteUser == null);
                SxSQL.setLogMode(this.logToKonsole);
                SxSQL.setUrl(this.serverURL);
                if (!SuperX.isAuthentificationFound) {
                    SxSQL.check(this.user);
                }
                SxSQL.readFMTemplates();
                if (SuperX.remoteUser != null) {
                    this.passwdBtn.setEnabled(true);
                }
                this.statusField.setText("Lade Standardwerte ..");
                SxSQL.executeQuery(Sichten.getReadingSql(this.user));
                this.user.getSichten().init(SxSQL.mandantenID, SxSQL.getResult(), SichtApplet.class);
                SxSQL.executeQuery("select distinct tid,type from sichten S where " + Sichten.getErlaubteSichtenSql(this.user));
                this.user.getSichten().setAllowedSichten(SxSQL.getResult(), this.user.isAdmin());
                if (SuperX.isSachgebieteNeeded) {
                    Sachgebiete.init();
                }
                this.installThemenbaum(DateUtils.getTodayString());
                this.terlaeuterung.setText("");
                this.statusField.setBackground(Color.white);
                this.statusField.setText("Anmeldung erfolgreich");
                ImageIcon connect_icon = (ImageIcon)this.sx_map.get("connect");
                this.dbBtn.setIcon(connect_icon);
                this.dbBtn.setDisabledIcon(connect_icon);
                if (countFrame == 1) {
                    this.passwdBtn.setEnabled(true);
                }
                this.openBtn.setEnabled(true);
                isLogin = true;
                this.cloneBtn.setEnabled(true);
                this.tabPane.setSelectedIndex(0);
                JRootPane root = this.sxMask.getRootPane();
                root.setDefaultButton(this.openBtn);
            }
            if (mode == 1) {
                this.logo.start();
                this.statusField.setText("Abmelden ..");
                if (SxSQL.isActive()) {
                    SxSQL.close();
                }
                SxDlgManager.clear();
                SxDefaults.clear();
                this.statusField.setBackground(Color.white);
                this.statusField.setText("Keine DB-Verbindung");
                ImageIcon disconnect_icon = (ImageIcon)this.sx_map.get("disconnect");
                this.dbBtn.setIcon(disconnect_icon);
                this.dbBtn.setDisabledIcon(disconnect_icon);
                if (countFrame == 1) {
                    this.passwdBtn.setEnabled(false);
                }
                this.openBtn.setEnabled(false);
                this.lastMaskeID = new Integer(-1);
                if (countFrame <= 1) {
                    isLogin = false;
                    this.cloneBtn.setEnabled(false);
                }
                this.close();
            }
        }
        catch (Exception ex) {
            String msg = ex.toString();
            ex.printStackTrace();
            this.statusField.setText(msg);
            ClipboardUtils.setContents(msg, null);
        }
        this.dbBtn.setEnabled(true);
        this.stopBtn.setEnabled(false);
        this.logo.stop();
        this.sxMask.repaint();
        this.activeThread = null;
    }

    void setUser(SxUser user) {
        this.user = user;
    }

    public Vector getFieldVector() {
        return this.selectedMaskeninfoElement.getFelderinfos();
    }

    public SxForm getForm() {
        return this.maskeForm;
    }

    public JFrame getFrame() {
        return this.sxFrame;
    }

    public SxLogoPanel getLogo() {
        return this.logo;
    }

    public JTextField getStatusField() {
        return this.statusField;
    }

    public void init() {
        int start_x = 20;
        int start_y = 20;
        this.sxMask.setLayout(new BorderLayout());
        JPanel heading = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        heading.setLayout(gridbag);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        int[] logo_pixels = (int[])this.sx_map.get("logo_pixels");
        JPanel sxTpanel = new JPanel();
        sxTpanel.setLayout(new BoxLayout(sxTpanel, 0));
        this.initHelpSystem();
        SxToolbar toolbar = new SxToolbar(this.getFrame());
        sxTpanel.add(toolbar);
        constraints.anchor = 10;
        gridbag.setConstraints(sxTpanel, constraints);
        heading.add(sxTpanel);
        ImageIcon logo_icon = (ImageIcon)this.sx_map.get("logo");
        this.logo = new SxLogoPanel(logo_icon, logo_pixels, 20, 50);
        this.addMouseListenerToLogo();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.anchor = 13;
        gridbag.setConstraints(this.logo, constraints);
        heading.add(this.logo);
        this.sxMask.add((Component)heading, "North");
        JPanel sxWpanel = new JPanel();
        sxWpanel.setLayout(new BorderLayout());
        sxWpanel.setBorder(BorderFactory.createEtchedBorder());
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(NORMAL_BOLD_FONT);
        ThemenwahlPanel themap = new ThemenwahlPanel();
        this.tabPane.addTab("Themenauswahl", themap);
        this.helpItemString = "Themaauswhlen.htm";
        CSH.setHelpIDString((Component)themap, (String)this.helpItemString);
        if (this.helpsetfound) {
            this.hb.enableHelpKey((Component)themap, this.helpItemString, this.hs);
            this.hb.enableHelp((Component)themap, this.helpItemString, this.hs);
        }
        this.initMaskeTab();
        this.initTableTab();
        this.tabPane.setSelectedIndex(0);
        sxWpanel.add((Component)this.tabPane, "Center");
        this.sxSpanel = new JPanel();
        this.sxSpanel.setLayout(new BorderLayout());
        this.sxSpanel.setBorder(BorderFactory.createEtchedBorder());
        this.statusField = new JTextField("");
        this.statusField.setFont(NORMAL_FONT);
        this.statusField.setMargin(new Insets(5, 5, 5, 5));
        this.statusField.setEditable(false);
        this.sxSpanel.add((Component)this.statusField, "Center");
        this.sxMask.add((Component)sxWpanel, "Center");
        this.sxMask.add((Component)this.sxSpanel, "South");
        SxDefaults.init();
        try {
            this.serverURL = (String)SxDefaults.getPropertyValue("SxServerURL");
            SxSQL.setUrl(this.serverURL);
        }
        catch (Exception ex) {
            ClipboardUtils.setContents(ex.toString(), null);
            System.err.println(ex);
            JOptionPane.showMessageDialog(this.sxMask, ex.toString(), "Fehler", 0);
        }
        try {
            this.logToKonsole = (String)SxDefaults.getPropertyValue("logToKonsole");
        }
        catch (Exception ex) {
            this.logToKonsole = "none";
        }
        this.sxTitle = this.sxFrame.getTitle();
        try {
            this.sxTitle = String.valueOf(this.sxTitle) + ", " + (String)SxDefaults.getPropertyValue("SxTitle");
            this.sxFrame.setTitle(this.sxTitle);
        }
        catch (Exception ex) {
            this.sxFrame.setTitle(this.sxTitle);
        }
    }

    ParameterPanel getParameterPanel() {
        return this.parameterPanel;
    }

    private void initTableTab() {
        JPanel tableTab = new JPanel();
        tableTab.setLayout(new BorderLayout());
        this.sxTablePanel = new SxTablePanel();
        this.parameterPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                int button1 = e2.getModifiers() & 0x10;
                if (button1 == 0) {
                    return;
                }
                ((SxMask)SxMask.this).sxTablePanel.table.setColumnSelectionAllowed(false);
                ((SxMask)SxMask.this).sxTablePanel.rowheaderTable.setColumnSelectionAllowed(false);
                ((SxMask)SxMask.this).sxTablePanel.table.setRowSelectionAllowed(true);
                ((SxMask)SxMask.this).sxTablePanel.rowheaderTable.setRowSelectionAllowed(true);
                ((SxMask)SxMask.this).sxTablePanel.table.clearSelection();
                ((SxMask)SxMask.this).sxTablePanel.rowheaderTable.clearSelection();
            }
        });
        HorizontalBox hbox = new HorizontalBox();
        hbox.add(this.parameterPanel);
        hbox.addGlue();
        tableTab.add((Component)hbox, "North");
        tableTab.add((Component)this.sxTablePanel, "Center");
        if (this.helpsetfound) {
            this.helpItemString = "Auswertungsmglichkei.htm";
            CSH.setHelpIDString((Component)tableTab, (String)this.helpItemString);
            this.hb.enableHelpKey((Component)tableTab, this.helpItemString, this.hs);
            this.hb.enableHelp((Component)tableTab, this.helpItemString, this.hs);
        }
        JPanel pSouth = new JPanel();
        pSouth.add(this.btnExplanation);
        tableTab.add((Component)pSouth, "South");
        this.btnExplanation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SxMask.this.explanationFrame.set(SxMask.this.selectedMaskeninfoElement);
                SxMask.this.explanationFrame.show();
            }
        });
        this.tabPane.addTab("Tabelle", tableTab);
    }

    private void initMaskeTab() {
        JPanel maskep = new JPanel(new BorderLayout());
        JPanel sxCMpanel = new JPanel();
        sxCMpanel.setLayout(new FlowLayout());
        sxCMpanel.setBorder(BorderFactory.createEtchedBorder());
        this.searchBtn = new JButton("Suchen");
        this.searchBtn.setMnemonic(83);
        SearchListener searchl = new SearchListener();
        this.searchBtn.addActionListener(searchl);
        this.searchBtn.setFont(NORMAL_BOLD_FONT);
        this.searchBtn.setEnabled(false);
        this.helpItemString = "WeitereThemeneingren.htm";
        sxCMpanel.add((Component)this.searchBtn, 0);
        this.resetBtn = new JButton("Reset");
        ResetListener resetl = new ResetListener();
        this.resetBtn.addActionListener(resetl);
        this.resetBtn.setFont(NORMAL_BOLD_FONT);
        this.resetBtn.setEnabled(true);
        sxCMpanel.add((Component)this.resetBtn, 1);
        this.stopBtn = new JButton("Abbrechen");
        this.stopBtn.setMnemonic(67);
        StopListener stopl = new StopListener();
        this.stopBtn.addActionListener(stopl);
        this.stopBtn.setFont(NORMAL_BOLD_FONT);
        this.stopBtn.setEnabled(false);
        this.stopBtn.setVisible(false);
        sxCMpanel.add((Component)this.stopBtn, 2);
        this.maskeForm = new SxForm(0, 0, 0, 0);
        this.selectedMaskeninfoElement.setMaskeForm(this.maskeForm);
        this.maskeForm.setLogo(this.logo);
        maskep.add((Component)new JScrollPane(this.maskeForm), "Center");
        maskep.add((Component)sxCMpanel, "South");
        if (this.helpsetfound) {
            this.helpItemString = "WeitereThemeneingren.htm";
            CSH.setHelpIDString((Component)maskep, (String)this.helpItemString);
            this.hb.enableHelpKey((Component)maskep, this.helpItemString, this.hs);
            this.hb.enableHelp((Component)maskep, this.helpItemString, this.hs);
        }
        this.tabPane.addTab("Maske", maskep);
    }

    private void initHelpSystem() {
        ClassLoader loader = this.getClass().getClassLoader();
        URL url = null;
        try {
            url = HelpSet.findHelpSet((ClassLoader)loader, (String)"superx_help/superx");
            if (url == null) {
                url = HelpSet.findHelpSet((ClassLoader)loader, (String)"superx_help/superx.hs");
            }
            this.hs = new HelpSet(loader, url);
        }
        catch (NoClassDefFoundError e2) {
            JOptionPane.showMessageDialog(null, "Java Hilfesystem nicht gefunden. ", "SuperX", 2);
        }
        catch (Exception ee) {
            System.out.println("Hilfesystem nicht gefunden!");
        }
        if (url != null) {
            this.hb = this.hs.createHelpBroker();
            this.helpsetfound = true;
        }
    }

    public void maskeOeffnen() {
        this.openBtn.setEnabled(false);
        this.statusField.setText("Bitte warten ..");
        SxWaitCursor.set(this.sxMask, true);
        try {
            try {
                this.readMaskenFelderInfoFromDb();
                this.sxMask.createMask();
                this.searchBtn.setEnabled(true);
                JRootPane root = this.sxMask.getRootPane();
                root.setDefaultButton(this.searchBtn);
                this.tabPane.setSelectedIndex(1);
                this.statusField.setText("");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String msg = ex.toString();
                ClipboardUtils.setContents(msg, null);
                System.out.println(msg);
                this.statusField.setText("Maske konnte nicht aufgebaut werden :" + msg.substring(msg.lastIndexOf(":") + 1) + "-" + SxSQL.getErrorString());
                this.logo.stop();
                this.openBtn.setEnabled(true);
                SxWaitCursor.set(this.sxMask, false);
                this.sxMask.repaint();
            }
        }
        finally {
            this.logo.stop();
            this.openBtn.setEnabled(true);
            SxWaitCursor.set(this.sxMask, false);
            this.sxMask.repaint();
        }
    }

    private void readMaskenFelderInfoFromDb() throws SQLException, IOException {
        String sql = "select M.tid, M.select_stmt, M.xil_proplist, M.cleanup_stmt, M.breite, M.hoehe, S.datum, M.hinweis,M.erlaeuterung from maskeninfo M, maske_system_bez B, systeminfo S where M.tid = " + this.selectedMaskeninfoElement.getTid() + "  and M.tid = B.maskeninfo_id" + "  and S.tid = B.systeminfo_id" + ";";
        SxSQL.executeQuery(sql);
        Vector vectorMaskeninfoEntries = SxSQL.getResultVector();
        if (vectorMaskeninfoEntries.size() == 0) {
            throw new SQLException("Keine Daten zu dieser Maske (Nr." + this.selectedMaskeninfoElement.getTid() + ") in der Datenbank gefunden");
        }
        this.selectedMaskeninfoElement.init(vectorMaskeninfoEntries);
        sql = "select F.tid, F.name, F.nummer, F.x, F.y, F.buttonbreite, F.feldbreite, F.zeilenanzahl, F.typ, F.laenge, F.obligatorisch, F.art, F.relation, F.attribut, F.defaultwert from felderinfo F, masken_felder_bez B where F.art!=999 and B.maskeninfo_id = " + this.selectedMaskeninfoElement.getTid() + " and F.tid = B.felderinfo_id " + "order by F.nummer;";
        SxSQL.executeQuery(sql);
        this.selectedMaskeninfoElement.setFelderinfos(SxSQL.getResultVector());
        if (SuperX.isSachgebieteNeeded) {
            this.selectedMaskeninfoElement.readSachgebiete();
        }
    }

    void setConnectPwBtnsSVisible(boolean vis) {
        this.dbBtn.setVisible(vis);
        this.passwdBtn.setVisible(vis);
    }

    public void open() {
        this.sxFrame.setVisible(true);
        JRootPane root = this.sxMask.getRootPane();
        if (SuperX.isAuthentificationFound) {
            root.setDefaultButton(this.dbBtn);
        }
        if (!isLogin) {
            this.user.setPasswd("");
            this.connectionDlg.setPassword("");
        }
        if (!SuperX.isAuthentificationFound && SuperX.remoteUser == null) {
            this.dbBtn.doClick();
        }
        this.passwdBtn.setVisible(SuperX.remoteUser == null);
    }

    public MaskeninfoElement getSelectedMaskeninfoElement() {
        return this.selectedMaskeninfoElement;
    }

    class CloneListener
    implements ActionListener,
    Runnable {
        CloneListener clone_th;

        CloneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (!isLogin) {
                return;
            }
            this.clone_th = new CloneListener();
            new Thread(this.clone_th).start();
        }

        @Override
        public void run() {
            SxMask cloneM = new SxMask("SuperX", SxMask.this.sx_map, isApplet);
            cloneM.setUser(SxMask.this.user);
        }
    }

    class ConnectListener
    implements ActionListener,
    Runnable {
        private ConnectListener connect_th;
        private int mode;

        ConnectListener(int mode) {
            this.mode = mode;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SxMask.this.dbBtn.setEnabled(false);
            int rc = -1;
            rc = isLogin && countFrame > 1 ? 0 : SxMask.this.showConnectionDialog();
            if (rc < 0 || rc == 2) {
                SxMask.this.dbBtn.setEnabled(true);
                return;
            }
            DefaultTreeModel model = (DefaultTreeModel)SxMask.this.themenwahltree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)SxMask.this.themenwahltree.getModel().getRoot();
            root.removeAllChildren();
            model.reload(root);
            this.connect_th = new ConnectListener(rc);
            SxMask.this.activeThread = new Thread(this.connect_th);
            SxMask.this.activeThread.start();
        }

        @Override
        public void run() {
            SuperX.isAuthentificationFound = false;
            SxMask.this.initUser(this.mode);
        }
    }

    class CopyListener
    implements ActionListener,
    Runnable {
        CopyListener copy_th;

        CopyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            this.copy_th = new CopyListener();
            new Thread(this.copy_th).start();
        }

        @Override
        public void run() {
            if (SxMask.this.sxTablePanel == null) {
                return;
            }
            StringBuffer data = new StringBuffer();
            data.append(SxDefaults.getPropertyValue("SxTitle"));
            data.append("\n\n");
            data.append(SxMask.this.selectedMaskeninfoElement.getName());
            data.append("\n");
            data.append(SxMask.this.selectedMaskeninfoElement.getStand());
            data.append("\n\nEingabeparameter:\n");
            data.append(SxMask.this.maskeForm.getParamList(SxMask.this.user.getName(), false));
            data.append("\n\n");
            String s1 = SxUtils.replace(SxMask.this.sxTablePanel.getText(), "\\n", "");
            s1 = SxUtils.replace(s1, "\"", "'");
            data.append(s1);
            ClipboardUtils.setContents(data, null);
        }
    }

    class OpenListener
    implements ActionListener,
    Runnable {
        OpenListener open_th;

        OpenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (SxMask.this.selectedMaskeninfoElement.getTid() != null) {
                SxMask.this.helpItemString = "M" + SxMask.this.selectedMaskeninfoElement.getTid() + ".htm";
            }
            if (SxMask.this.helpsetfound) {
                CSH.setHelpIDString((Component)SxMask.this.helpBtn, (String)SxMask.this.helpItemString);
                SxMask.this.hb.enableHelpKey((Component)SxMask.this.getRootPane(), SxMask.this.helpItemString, SxMask.this.hs);
            }
            this.open_th = new OpenListener();
            SxMask.this.activeThread = new Thread(this.open_th);
            SxMask.this.activeThread.start();
        }

        @Override
        public void run() {
            if (SxMask.this.selectedMaskeninfoElement.getTid() == null) {
                SxMask.this.getToolkit().beep();
                SxMask.this.statusField.setText("Bitte ein Thema ausw\u00e4hlen !");
                return;
            }
            SxMask.this.maskeOeffnen();
            SxMask.this.activeThread = null;
        }
    }

    class ParameterPanel
    extends JPanel {
        JLabel lblAbfragename;
        JLabel lblEingabeparam;
        JLabel lblParams;
        JLabel lblStand;

        ParameterPanel() {
            super(new BorderLayout());
            VerticalBox topBox = new VerticalBox();
            topBox.addStrut(10);
            this.lblAbfragename = new JLabel();
            this.lblAbfragename.setFont(new Font("SansSerif", 1, 14));
            this.lblParams = new JLabel();
            this.setMaximumSize(new Dimension(200, 1000));
            this.lblEingabeparam = new JLabel("Parameter:   ");
            topBox.add(this.lblAbfragename);
            topBox.addStrut(5);
            topBox.add(this.lblEingabeparam);
            topBox.addStrut(5);
            this.add((Component)topBox, "North");
            this.add((Component)this.lblParams, "Center");
            this.lblStand = new JLabel();
            this.add((Component)this.lblStand, "South");
        }

        public void setAbfragename(String name) {
            this.lblAbfragename.setText(name);
        }

        public void setParams(String params) {
            this.lblParams.setText(params);
        }

        public void setStand(String stand) {
            this.lblStand.setText("Stand: " + stand);
        }
    }

    class PrintListener
    implements ActionListener,
    Runnable {
        PrintListener print_th;

        PrintListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            this.print_th = new PrintListener();
            new Thread(this.print_th).start();
        }

        @Override
        public void run() {
            try {
                SxMask.this.printBtn.setEnabled(false);
                SxMask.this.sxTablePanel.printTable(SxMask.this.sxMask);
            }
            catch (Exception ex) {
                String msg = ex.toString();
                ClipboardUtils.setContents(msg, null);
                SxMask.this.statusField.setText(msg.substring(msg.lastIndexOf(":") + 1));
            }
            SxMask.this.printBtn.setEnabled(true);
        }
    }

    class PwdListener
    implements ActionListener {
        JFrame frame;

        PwdListener(JFrame frame) {
            this.frame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            int rc = -1;
            if (SxMask.this.helpsetfound) {
                SxMask.this.helpItemString = "Anmelden.htm";
                CSH.setHelpIDString((Component)SxMask.this.passwdBtn, (String)SxMask.this.helpItemString);
                SxMask.this.hb.enableHelpKey((Component)SxMask.this.passwdBtn, SxMask.this.helpItemString, SxMask.this.hs);
                SxMask.this.hb.enableHelp((Component)SxMask.this.passwdBtn, SxMask.this.helpItemString, SxMask.this.hs);
            }
            SxPasswdChangeDlg passwdChangeDlg = new SxPasswdChangeDlg((Frame)this.frame, "Passwort \u00e4ndern");
            passwdChangeDlg.setNewPasswordChecker(SxSQL.newPasswordChecker);
            passwdChangeDlg.setUsername(SxMask.this.user.getName());
            passwdChangeDlg.setUsernameFieldEnabled(false);
            passwdChangeDlg.setCheckOldPasswdWanted(true);
            passwdChangeDlg.show();
            if (!passwdChangeDlg.wasOkSelected()) {
                return;
            }
            try {
                try {
                    WindowUtils.setWaitCursor(SxMask.this.statusField, true);
                    SxUser userToBeChanged = null;
                    userToBeChanged = SxMask.this.user.getName().equals(passwdChangeDlg.getUsername()) ? SxMask.this.user : new SxUser(passwdChangeDlg.getUsername(), passwdChangeDlg.getOldPasswd());
                    SxSQL.storePwd(userToBeChanged, passwdChangeDlg.getNewPasswd(), true);
                    SxMask.this.statusField.setBackground(Color.white);
                    SxMask.this.statusField.setText("Kennwort ge\u00e4ndert");
                    passwdChangeDlg.clear();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    String msg = ex.toString();
                    ClipboardUtils.setContents(msg, null);
                    msg = msg.substring(msg.lastIndexOf(":") + 1);
                    SxMask.this.statusField.setBackground(Color.red);
                    SxMask.this.statusField.setText(msg);
                    JOptionPane.showMessageDialog(SxMask.this.sxMask, msg, "Fehler", 0);
                    SxMask.this.statusField.setBackground(Color.white);
                    SxMask.this.statusField.setText("");
                    WindowUtils.setWaitCursor(SxMask.this.statusField, false);
                }
            }
            finally {
                WindowUtils.setWaitCursor(SxMask.this.statusField, false);
            }
        }
    }

    class ResetListener
    implements ActionListener {
        ResetListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SxMask.this.resetBtn.setEnabled(false);
            String fielddefault = new String();
            String fieldname = new String();
            int i2 = 0;
            while (i2 < SxMask.this.selectedMaskeninfoElement.getFelderinfos().size()) {
                SxField field;
                Vector V_field = (Vector)SxMask.this.selectedMaskeninfoElement.getFelderinfos().elementAt(i2);
                fieldname = (String)V_field.elementAt(1);
                if (fieldname != null) {
                    fieldname = fieldname.trim();
                }
                if ((fielddefault = (String)V_field.elementAt(14)) != null) {
                    fielddefault = fielddefault.trim();
                }
                if ((field = SxMask.this.maskeForm.getField("F_" + fieldname)) != null && field.hasSichten()) {
                    field.clearSichtSelections();
                }
                if (fielddefault != null) {
                    if (fielddefault.startsWith("<<SQL>>")) {
                        try {
                            Object value;
                            String stmt = fielddefault.substring(7);
                            SxSQL.executeAll(stmt);
                            Vector V_default = (Vector)SxSQL.getResultVector().elementAt(0);
                            if (V_default.size() == 2) {
                                Object key = V_default.elementAt(0);
                                field.setKey(key);
                                value = V_default.elementAt(1);
                                if (value instanceof java.sql.Date) {
                                    value = SxDate.toString((java.sql.Date)value);
                                }
                                field.setText(value.toString());
                            }
                            if (V_default.size() == 1) {
                                field.setKey(new Integer("-1"));
                                value = V_default.elementAt(0);
                                if (value instanceof java.sql.Date) {
                                    value = SxDate.toString((java.sql.Date)value);
                                }
                                field.setText(value.toString());
                            }
                        }
                        catch (Exception ex) {
                            System.err.println(ex.toString());
                            ClipboardUtils.setContents(ex.toString(), null);
                        }
                    } else if (field != null) {
                        field.setText(fielddefault);
                        field.setKey(new Integer(-1));
                    }
                }
                ++i2;
            }
            SxMask.this.maskeForm.rememberSelectionsAsDefaults();
            SxMask.this.resetBtn.setEnabled(true);
            SxMask.this.logo.stop();
        }
    }

    class SaveDlgListener
    implements ActionListener {
        SaveDlgListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                JFileChooser file_dlg = new JFileChooser();
                file_dlg.setDialogType(1);
                SaveListener savel = new SaveListener(file_dlg);
                file_dlg.addActionListener(savel);
                file_dlg.showDialog(SxMask.this.sxMask, "Sichern ..");
            }
            catch (Exception ex) {
                ClipboardUtils.setContents(ex.toString(), null);
                JOptionPane.showMessageDialog(SxMask.this.sxMask, ex.toString(), "Fehler", 0);
            }
        }
    }

    class SaveListener
    implements ActionListener,
    Runnable {
        SaveListener save_th;
        JFileChooser file_dlg;

        SaveListener(JFileChooser aFile_dlg) {
            this.file_dlg = aFile_dlg;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (e2.getActionCommand().equals("CancelSelection")) {
                return;
            }
            this.save_th = new SaveListener(this.file_dlg);
            new Thread(this.save_th).start();
        }

        @Override
        public void run() {
            File out_file = this.file_dlg.getSelectedFile();
        }
    }

    class SearchListener
    implements ActionListener,
    Runnable {
        SearchListener search_th;

        SearchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (SxMask.this.selectedMaskeninfoElement.getTid() != null) {
                SxMask.this.helpItemString = "T" + SxMask.this.selectedMaskeninfoElement.getTid() + ".htm";
            }
            if (SxMask.this.helpsetfound) {
                CSH.setHelpIDString((Component)SxMask.this.helpBtn, (String)SxMask.this.helpItemString);
                SxMask.this.hb.enableHelpKey((Component)SxMask.this.getRootPane(), SxMask.this.helpItemString, SxMask.this.hs);
            }
            this.search_th = new SearchListener();
            SxMask.this.activeThread = new Thread(this.search_th);
            SxMask.this.activeThread.start();
        }

        @Override
        public void run() {
            try {
                String nachr;
                SxMask.this.logo.start();
                SxMask.this.isInterrupted = false;
                SxMask.this.searchBtn.setEnabled(false);
                SxMask.this.resetBtn.setEnabled(false);
                Integer fixedColumns = new Integer(SxMask.this.selectedMaskeninfoElement.getXilProps().getProperty("fixed_columns", "1"));
                SxMask.this.sxTablePanel.setFixedColumns(fixedColumns);
                String hinweis = SxMask.this.selectedMaskeninfoElement.getHinweis();
                if (hinweis != null && hinweis.startsWith("<<SQL>>")) {
                    hinweis = hinweis.substring(7, hinweis.length());
                    try {
                        String sql = SxUtils.generateSQL(SxMask.this.maskeForm, hinweis);
                        SxSQL.executeQuery(sql);
                        SxResultRow r = (SxResultRow)SxSQL.getResult().first();
                        hinweis = (String)r.get(0);
                    }
                    catch (Exception e2) {
                        hinweis = null;
                    }
                }
                SxMask.this.maskeForm.setHinweis(hinweis);
                SxMask.this.maskeForm.checkFields();
                boolean isTemplate = SxMask.this.selectedMaskeninfoElement.getSelectStmt().toUpperCase().indexOf("FREEMARKER TEMPLATE") > -1;
                String selectString = SxUtils.generateSQL(SxMask.this.maskeForm, String.valueOf(SxMask.this.selectedMaskeninfoElement.getSelectStmt()) + "\n" + SxMask.this.selectedMaskeninfoElement.getCleanupStmt());
                if (isTemplate) {
                    HashMap map = SxMask.this.maskeForm.getHashMap(SxMask.this.selectedMaskeninfoElement.getTid());
                    selectString = SxSQL.templateProcessor.process("Maske " + SxMask.this.selectedMaskeninfoElement.getName(), selectString, map, (String)SxDefaults.getPropertyValue("SxDB"));
                }
                SxMask.this.statusField.setBackground(Color.yellow);
                SxMask.this.statusField.setText("Bitte warten ..");
                SxMask.this.maskeForm.rememberSelectionsAsDefaults();
                SxMask.this.parameterPanel.setParams(SxMask.this.maskeForm.getParamList(SxMask.this.user.getName(), true));
                SxMask.this.parameterPanel.setStand(SxMask.this.selectedMaskeninfoElement.getStandString());
                SxMask.this.parameterPanel.setAbfragename(SxMask.this.selectedMaskeninfoElement.getName());
                SxMask.this.stopBtn.setEnabled(true);
                SxSQL.executeAll("--Abfrage\n" + selectString);
                if (SxSQL.getRowCount() == 0) {
                    SxMask.this.lastMaskeID = new Integer(-1);
                }
                if (!SxMask.this.selectedMaskeninfoElement.isSqlInHeaders() && SxMask.this.selectedMaskeninfoElement.getTid().equals(SxMask.this.lastMaskeID)) {
                    SxMask.this.sxTablePanel.setData(SxSQL.getResultVector());
                } else {
                    Vector headerVector = SxMask.this.selectedMaskeninfoElement.getHeaderVector();
                    Vector resultVector = SxSQL.getResultVector();
                    SxSQLMetaData metaData = SxSQL.getResultSetMetaData();
                    if (SxMask.this.selectedMaskeninfoElement.isSqlInHeaders()) {
                        this.runSqlInTableHeaders(headerVector);
                    }
                    SxMask.this.sxTablePanel.setData(resultVector, headerVector, SxMask.this.selectedMaskeninfoElement.getWidthVector(), metaData);
                }
                if (SxSQL.getRowCount() > 0) {
                    SxMask.this.lastMaskeID = SxMask.this.selectedMaskeninfoElement.getTid();
                }
                if ((nachr = SxSQL.getAktuelleNachricht()) != null && !nachr.equals("")) {
                    SxMask.this.statusField.setText("Bei der Abfrage ist ein SQL-Fehler aufgetreten (siehe Java-Konsole)");
                    System.out.println("SQL-Fehler: " + nachr);
                }
                JScrollBar vsbar = SxMask.this.sxTablePanel.getScrollPane().getVerticalScrollBar();
                vsbar.setValue(vsbar.getMinimum());
                SxMask.this.tabPane.setSelectedIndex(2);
                SxMask.this.sxMask.repaint();
                SxMask.this.statusField.setBackground(Color.white);
                if (nachr == null || nachr.length() < 1) {
                    SxMask.this.statusField.setText(String.valueOf(SxMask.this.sxTablePanel.getTable().getRowCount()) + " S\u00e4tze gefunden");
                }
            }
            catch (SQLException ex) {
                String msg = ex.toString();
                ex.printStackTrace();
                SxMask.this.statusField.setText(msg.substring(msg.lastIndexOf(":") + 1));
                ClipboardUtils.setContents(msg, null);
                SxMask.this.statusField.setBackground(Color.red);
                try {
                    SxSQL.close();
                    ImageIcon disconnect_icon = (ImageIcon)SxMask.this.sx_map.get("disconnect");
                    SxMask.this.dbBtn.setIcon(disconnect_icon);
                    SxMask.this.dbBtn.setDisabledIcon(disconnect_icon);
                    if (countFrame == 1) {
                        SxMask.this.passwdBtn.setEnabled(false);
                    }
                    SxMask.this.passwdBtn.setVisible(SuperX.remoteUser == null);
                    SxMask.this.openBtn.setEnabled(false);
                    SxMask.this.lastMaskeID = new Integer(-1);
                    SxMask.this.statusField.setBackground(Color.white);
                    ImageIcon connect_icon = (ImageIcon)SxMask.this.sx_map.get("connect");
                    SxMask.this.dbBtn.setIcon(connect_icon);
                    SxMask.this.dbBtn.setDisabledIcon(connect_icon);
                    if (countFrame == 1) {
                        SxMask.this.passwdBtn.setEnabled(true);
                    }
                    SxMask.this.passwdBtn.setVisible(SuperX.remoteUser == null);
                    SxMask.this.openBtn.setEnabled(true);
                }
                catch (Exception ex2) {
                    String msg2 = ex2.toString();
                    ex2.printStackTrace();
                    SxMask.this.statusField.setText(msg2.substring(msg2.lastIndexOf(":") + 1));
                    ClipboardUtils.setContents(msg2, null);
                }
            }
            catch (Exception ex_input) {
                String msg = ex_input.toString();
                ex_input.printStackTrace();
                System.out.println(ex_input.toString());
                JOptionPane.showMessageDialog(SxMask.this.sxMask, msg.substring(msg.lastIndexOf(":") + 1), "Eingabefehler", 0);
                ClipboardUtils.setContents(msg, null);
            }
            SxMask.this.searchBtn.setEnabled(true);
            SxMask.this.resetBtn.setEnabled(true);
            SxMask.this.stopBtn.setEnabled(false);
            SxMask.this.logo.stop();
            JRootPane root = SxMask.this.sxMask.getRootPane();
            root.setDefaultButton(SxMask.this.searchBtn);
            SxMask.this.sxMask.repaint();
            SxMask.this.activeThread = null;
        }

        private void runSqlInTableHeaders(Vector headerVector) {
            int i2 = 0;
            while (i2 < headerVector.size()) {
                String aHeader = headerVector.get(i2).toString();
                if (aHeader.trim().startsWith("<<SQL>>")) {
                    try {
                        String query = SxUtils.generateSQL(SxMask.this.maskeForm, aHeader.substring(7));
                        SxSQL.executeQuery(query);
                        Vector row0 = (Vector)SxSQL.getResultVector().get(0);
                        String newHeader = row0.get(0).toString();
                        headerVector.remove(i2);
                        headerVector.add(i2, newHeader);
                        SxMask.this.selectedMaskeninfoElement.adaptExplanation(i2, newHeader);
                    }
                    catch (SQLException e2) {
                        WarningMessage.show((Component)SxMask.this.sxMask, "Spalten\u00fcberschrift mit dem Ausdruck\n" + aHeader + "\nkonnte nicht aufgebaut werden", "SuperX");
                        ClipboardUtils.setContents(e2.toString(), null);
                    }
                }
                ++i2;
            }
        }
    }

    class StopListener
    implements ActionListener {
        StopListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SxMask.this.stopBtn.setEnabled(false);
            try {
                SxMask.this.logo.start();
                SxMask.this.statusField.setBackground(Color.red);
                SxMask.this.statusField.setText("Abbrechen ..");
                if (SxMask.this.activeThread != null) {
                    SxMask.this.activeThread.interrupt();
                    SxMask.this.isInterrupted = true;
                    SxSQL.cancel();
                    SxMask.this.isInterrupted = true;
                    SxMask.this.searchBtn.setEnabled(true);
                }
            }
            catch (Exception ex) {
                String msg = ex.toString();
                ex.printStackTrace();
                SxMask.this.statusField.setText(msg.substring(msg.lastIndexOf(":") + 1));
                ClipboardUtils.setContents(msg, null);
            }
            SxMask.this.stopBtn.setEnabled(true);
            SxMask.this.logo.stop();
        }
    }

    class SuchAbfrListener
    implements ActionListener,
    Runnable {
        SuchAbfrListener SuchAbfr_th;
        JTree tree;

        SuchAbfrListener(JTree ltree) {
            this.tree = ltree;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            this.SuchAbfr_th = new SuchAbfrListener(this.tree);
            new Thread(this.SuchAbfr_th).start();
        }

        @Override
        public void run() {
            DefaultMutableTreeNode test;
            JTree tree = SxMask.this.themenwahltree;
            String such = JOptionPane.showInputDialog(null, "Suche nach Abfragen:", "SuperX", 3);
            if (such.length() < 1) {
                return;
            }
            such = such.toLowerCase();
            boolean gefunden = false;
            DefaultMutableTreeNode ausgesucht = null;
            Vector<String> treffer = new Vector<String>();
            Vector<DefaultMutableTreeNode> treffernodes = new Vector<DefaultMutableTreeNode>();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
            Enumeration<TreeNode> en = root.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                test = (DefaultMutableTreeNode)en.nextElement();
                String teststring = test.toString().toLowerCase();
                if (teststring.indexOf(such) <= -1) continue;
                treffer.addElement(test.toString());
                treffernodes.addElement(test);
            }
            if (treffer.size() > 0) {
                TreePath tp;
                if (treffer.size() > 1) {
                    Object[] trefferstring = new String[treffer.size()];
                    treffer.copyInto(trefferstring);
                    String selectedValue = (String)this.showBigChoiceDialog(null, "Mehrere Treffer- bitte ausw\u00e4hlen...", "SuperX", 1, null, trefferstring, trefferstring[0]);
                    if (selectedValue == null) {
                        return;
                    }
                    gefunden = false;
                    en = treffernodes.elements();
                    while (en.hasMoreElements() && !gefunden) {
                        test = (DefaultMutableTreeNode)en.nextElement();
                        if (!test.toString().equals(selectedValue)) continue;
                        ausgesucht = test;
                        gefunden = true;
                    }
                }
                if (ausgesucht == null) {
                    ausgesucht = (DefaultMutableTreeNode)treffernodes.elementAt(0);
                }
                tree.clearSelection();
                en = root.depthFirstEnumeration();
                while (en.hasMoreElements()) {
                    test = (DefaultMutableTreeNode)en.nextElement();
                    tp = new TreePath(test.getPath());
                    if (!tree.isExpanded(tp)) continue;
                    tree.collapsePath(tp);
                }
                tp = new TreePath(ausgesucht.getPath());
                tree.clearSelection();
                tree.setSelectionPath(tp);
                tree.scrollPathToVisible(tp);
            } else {
                JOptionPane.showMessageDialog(null, "Keine Treffer!", "SuperX", 1);
            }
        }

        private Object showBigChoiceDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
            JOptionPane pane = new JOptionPane(message, messageType, 2, icon, null, null);
            pane.setWantsInput(true);
            pane.setSelectionValues(selectionValues);
            pane.setInitialSelectionValue(initialSelectionValue);
            JDialog dialog = pane.createDialog(parentComponent, title);
            dialog.setSize(400, 200);
            pane.selectInitialValue();
            dialog.show();
            Object value = pane.getInputValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return null;
            }
            return value;
        }
    }

    class SxToolbar
    extends JToolBar {
        SxToolbar(JFrame frame) {
            ImageIcon disconnect_icon = (ImageIcon)SxMask.this.sx_map.get("disconnect");
            ImageIcon clone_icon = (ImageIcon)SxMask.this.sx_map.get("clone");
            ImageIcon copy_icon = (ImageIcon)SxMask.this.sx_map.get("copy");
            ImageIcon save_icon = (ImageIcon)SxMask.this.sx_map.get("save");
            ImageIcon print_icon = (ImageIcon)SxMask.this.sx_map.get("print");
            ImageIcon info_icon = (ImageIcon)SxMask.this.sx_map.get("info");
            ImageIcon passwd_icon = (ImageIcon)SxMask.this.sx_map.get("passwd");
            ImageIcon help_icon = (ImageIcon)SxMask.this.sx_map.get("help");
            this.setFloatable(false);
            SxMask.this.dbBtn = new JButton("Anmelden", disconnect_icon);
            SxMask.this.dbBtn.setMargin(new Insets(2, 2, 2, 2));
            SxMask.this.dbBtn.setDisabledIcon(disconnect_icon);
            SxMask.this.dbBtn.setMnemonic(68);
            SxMask.this.dbBtn.setHorizontalTextPosition(0);
            SxMask.this.dbBtn.setVerticalTextPosition(3);
            SxMask.this.dbBtn.setFont(NORMAL_FONT);
            ConnectListener conl = new ConnectListener(0);
            SxMask.this.dbBtn.addActionListener(conl);
            this.add(SxMask.this.dbBtn);
            SxMask.this.dbBtn.setVisible(SuperX.remoteUser == null);
            SxMask.this.passwdBtn = new JButton("Passwort", passwd_icon);
            SxMask.this.passwdBtn.setMargin(new Insets(2, 2, 2, 2));
            SxMask.this.passwdBtn.setHorizontalTextPosition(0);
            SxMask.this.passwdBtn.setVerticalTextPosition(3);
            SxMask.this.passwdBtn.setFont(NORMAL_FONT);
            PwdListener pwdl = new PwdListener(frame);
            SxMask.this.passwdBtn.addActionListener(pwdl);
            SxMask.this.passwdBtn.setEnabled(countFrame == 1);
            SxMask.this.passwdBtn.setEnabled(false);
            this.add(SxMask.this.passwdBtn);
            SxMask.this.passwdBtn.setVisible(SuperX.remoteUser == null);
            SxMask.this.cloneBtn = new JButton("Clone", clone_icon);
            SxMask.this.cloneBtn.setToolTipText("\u00f6ffnet weiteres SuperX-Fenster! Anschlie\u00dfend Anmelden anklicken!");
            SxMask.this.cloneBtn.setMargin(new Insets(2, 2, 2, 2));
            SxMask.this.cloneBtn.setHorizontalTextPosition(0);
            SxMask.this.cloneBtn.setVerticalTextPosition(3);
            SxMask.this.cloneBtn.setFont(NORMAL_FONT);
            SxMask.this.cloneBtn.setEnabled(false);
            CloneListener clonel = new CloneListener();
            SxMask.this.cloneBtn.addActionListener(clonel);
            this.add(SxMask.this.cloneBtn);
            SxMask.this.copyBtn = new JButton("Kopieren", copy_icon);
            SxMask.this.copyBtn.setToolTipText("Ergebnisse in Zwischenablage kopieren (als Trennzeichen wird Tabulator benutzt)");
            SxMask.this.copyBtn.setMargin(new Insets(2, 2, 2, 2));
            SxMask.this.copyBtn.setHorizontalTextPosition(0);
            SxMask.this.copyBtn.setVerticalTextPosition(3);
            SxMask.this.copyBtn.setFont(NORMAL_FONT);
            CopyListener copyl = new CopyListener();
            SxMask.this.copyBtn.addActionListener(copyl);
            this.add(SxMask.this.copyBtn);
            SxMask.this.saveBtn = new JButton("Sichern", save_icon);
            SxMask.this.saveBtn.setToolTipText("Ergebnisse in Datei speichern");
            SxMask.this.saveBtn.setMargin(new Insets(2, 2, 2, 2));
            SxMask.this.saveBtn.setHorizontalTextPosition(0);
            SxMask.this.saveBtn.setVerticalTextPosition(3);
            SxMask.this.saveBtn.setFont(NORMAL_FONT);
            SaveDlgListener savedlgl = new SaveDlgListener();
            SxMask.this.saveBtn.addActionListener(savedlgl);
            SxMask.this.printBtn = new JButton("Drucken", print_icon);
            SxMask.this.printBtn.setMargin(new Insets(2, 2, 2, 2));
            SxMask.this.printBtn.setHorizontalTextPosition(0);
            SxMask.this.printBtn.setVerticalTextPosition(3);
            SxMask.this.printBtn.setFont(NORMAL_FONT);
            PrintListener printl = new PrintListener();
            SxMask.this.printBtn.addActionListener(printl);
            this.add(SxMask.this.printBtn);
            if (SxMask.this.helpsetfound) {
                SxMask.this.helpBtn = new JButton("Hilfe", help_icon);
                SxMask.this.helpBtn.setMargin(new Insets(2, 2, 2, 2));
                SxMask.this.helpBtn.setHorizontalTextPosition(0);
                SxMask.this.helpBtn.setVerticalTextPosition(3);
                SxMask.this.helpBtn.setFont(NORMAL_FONT);
                SxMask.this.helpBtn.addActionListener((ActionListener)new CSH.DisplayHelpAfterTracking(SxMask.this.hb));
                SxMask.this.helpBtn.setEnabled(true);
                SxMask.this.helpBtn.setToolTipText("Hilfesystem aufrufen");
                this.add(SxMask.this.helpBtn);
            }
            SxMask.this.infoBtn = new JButton("Info", info_icon);
            SxMask.this.infoBtn.setMargin(new Insets(2, 5, 2, 5));
            SxMask.this.infoBtn.setHorizontalTextPosition(0);
            SxMask.this.infoBtn.setVerticalTextPosition(3);
            SxMask.this.infoBtn.setFont(NORMAL_FONT);
            SxMask.this.infoBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JOptionPane.showMessageDialog(null, "SuperX Version @version@\nbuild:@sxtimestamp@\nDas Data Warehouse f\u00fcr Hochschulen\nwww.superx-projekt.de\nKontakt: info@superx-projekt.de\nMandant: " + SxSQL.mandantenID + ",public/private key " + (SxSQL.dsaHandler == null ? "nicht aktiv" : "aktiv"), "SuperX", 1);
                }
            });
            this.add(SxMask.this.infoBtn);
        }
    }

    class ThemenStandListener
    implements ActionListener {
        ThemenStandListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            String neuerStand = JOptionPane.showInputDialog(null, "Neues Datum eingeben:", "SuperX", 3);
            DateFormat df = DateFormat.getDateInstance(2);
            df.setTimeZone(TimeZone.getDefault());
            df.setLenient(false);
            String geprueft = null;
            try {
                if (neuerStand.endsWith("00")) {
                    switch (neuerStand.charAt(neuerStand.length() - 3)) {
                        case '-': 
                        case '.': 
                        case '/': {
                            neuerStand = String.valueOf(neuerStand.substring(0, neuerStand.length() - 2)) + "2000";
                        }
                    }
                }
                Date date = df.parse(neuerStand);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int year = calendar.get(1);
                if (year >= 0 && year < 30) {
                    calendar.add(1, 2000);
                }
                if (year >= 30 && year < 100) {
                    calendar.add(1, 1900);
                }
                java.sql.Date adate = new java.sql.Date(calendar.getTime().getTime());
                geprueft = df.format(adate);
            }
            catch (ParseException date) {
            }
            catch (IllegalArgumentException date) {
                // empty catch block
            }
            if (geprueft != null) {
                SxMask.this.sxMask.setCursor(new Cursor(3));
                SxMask.this.themenStandLabel.setText(neuerStand);
                try {
                    SxMask.this.installThemenbaum(neuerStand);
                }
                catch (SQLException e1) {
                    ClipboardUtils.setContents(e1.toString(), null);
                    WarningMessage.show((Component)SxMask.this.sxMask, e1.toString(), "Fehler");
                }
                SxMask.this.sxMask.validate();
                SxMask.this.sxMask.setCursor(new Cursor(0));
            } else {
                JOptionPane.showMessageDialog(null, "Ung\u00fcltige Eingabe!", "SuperX", 0);
            }
        }
    }

    class ThemenwahlPanel
    extends JPanel {
        ThemenwahlPanel() {
            super(new BorderLayout());
            JPanel centerp = new JPanel();
            GridBagConstraints gbc = new GridBagConstraints();
            centerp.setLayout(SxMask.this.gbl);
            SxMask.this.themenStandLabel = new JLabel(DateUtils.getTodayString());
            SxMask.this.themenStandLabel.setFont(SMALL_FONT);
            JLabel lerlaueterung = new JLabel("Erl\u00e4uterung");
            lerlaueterung.setBackground(Color.orange);
            JLabel platzhalterl = new JLabel("                ");
            JLabel platzhalterr = new JLabel("                ");
            SxMask.this.themenStandBtn = new JButton("anderer Stand");
            SxMask.this.themenStandBtn.setFont(SMALL_FONT);
            SxMask.this.themenStandBtn.setToolTipText("Zugriff auf alte Abfragen");
            ThemenStandListener tsl = new ThemenStandListener();
            SxMask.this.themenStandBtn.addActionListener(tsl);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(10, 2, 2, 0);
            gbc.fill = 0;
            gbc.anchor = 10;
            SxMask.this.gbl.setConstraints(platzhalterl, gbc);
            centerp.add(platzhalterl);
            JPanel pstand = new JPanel();
            gbc.gridx = 1;
            gbc.gridy = 0;
            SxMask.this.gbl.setConstraints(pstand, gbc);
            centerp.add(pstand);
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridx = 2;
            gbc.gridy = 0;
            SxMask.this.gbl.setConstraints(platzhalterr, gbc);
            centerp.add(platzhalterr);
            gbc.gridx = 5;
            gbc.gridy = 0;
            SxMask.this.gbl.setConstraints(lerlaueterung, gbc);
            centerp.add(lerlaueterung);
            DefaultMutableTreeNode dummy = new DefaultMutableTreeNode("Abfragen");
            dummy.add(new DefaultMutableTreeNode(""));
            SxMask.this.themenwahltree = new JTree(dummy);
            TreePath tp = new TreePath(dummy.getPath());
            SxMask.this.themenwahltree.collapsePath(tp);
            SxMask.this.themenwahlscroll = new JScrollPane(SxMask.this.themenwahltree);
            SxMask.this.themenwahlscroll.setHorizontalScrollBarPolicy(30);
            ((SxMask)SxMask.this).gbctree.gridx = 0;
            ((SxMask)SxMask.this).gbctree.gridy = 1;
            ((SxMask)SxMask.this).gbctree.gridwidth = 4;
            ((SxMask)SxMask.this).gbctree.gridheight = 4;
            ((SxMask)SxMask.this).gbctree.insets = new Insets(0, 0, 0, 0);
            ((SxMask)SxMask.this).gbctree.weightx = 100.0;
            ((SxMask)SxMask.this).gbctree.weighty = 100.0;
            ((SxMask)SxMask.this).gbctree.fill = 1;
            SxMask.this.gbl.setConstraints(SxMask.this.themenwahlscroll, SxMask.this.gbctree);
            centerp.add(SxMask.this.themenwahlscroll);
            SxMask.this.terlaeuterung.setFont(NORMAL_FONT);
            SxMask.this.terlaeuterung.setEditable(false);
            SxMask.this.terlaeuterung.setAlignmentX(0.5f);
            JScrollPane erlScroll = new JScrollPane(SxMask.this.terlaeuterung);
            gbc.gridx = 4;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.gridheight = 4;
            gbc.weightx = 100.0;
            gbc.weighty = 1000.0;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 0, 0, 0);
            SxMask.this.gbl.setConstraints(erlScroll, gbc);
            centerp.add(erlScroll);
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.insets = new Insets(5, 0, 5, 0);
            SxMask.this.suchAbfrBtn = new JButton("Abfrage suchen");
            SxMask.this.suchAbfrBtn.setFont(SMALL_FONT);
            SxMask.this.suchAbfrBtn.setToolTipText("Suchen von Abfragen mittels Stichwort");
            SuchAbfrListener sabl = new SuchAbfrListener(SxMask.this.themenwahltree);
            SxMask.this.suchAbfrBtn.addActionListener(sabl);
            gbc.gridx = 2;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.insets = new Insets(5, 0, 5, 0);
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.ipadx = 0;
            SxMask.this.gbl.setConstraints(SxMask.this.suchAbfrBtn, gbc);
            centerp.add(SxMask.this.suchAbfrBtn);
            JButton anpassenBtn = new JButton("anpassen");
            anpassenBtn.setVisible(false);
            anpassenBtn.setFont(SMALL_FONT);
            gbc.gridx = 4;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.insets = new Insets(5, 0, 5, 0);
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            SxMask.this.gbl.setConstraints(anpassenBtn, gbc);
            centerp.add(anpassenBtn);
            SxMask.this.aktuelleNachrichtL = new JLabel("");
            SxMask.this.aktuelleNachrichtL.setBackground(Color.orange);
            SxMask.this.aktuelleNachrichtL.setVisible(true);
            SxMask.this.aktuelleNachrichtL.setFont(SMALL_FONT);
            gbc.gridx = 1;
            gbc.gridy = 6;
            gbc.gridwidth = 5;
            gbc.gridheight = 1;
            gbc.insets = new Insets(5, 0, 5, 0);
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            SxMask.this.gbl.setConstraints(SxMask.this.aktuelleNachrichtL, gbc);
            centerp.add(SxMask.this.aktuelleNachrichtL);
            JPanel openBtnPanel = new JPanel();
            openBtnPanel.setBorder(BorderFactory.createEtchedBorder());
            SxMask.this.openBtn = new JButton("\u00d6ffnen");
            SxMask.this.openBtn.setMnemonic(79);
            SxMask.this.openBtn.addActionListener(new OpenListener());
            SxMask.this.openBtn.setFont(NORMAL_BOLD_FONT);
            SxMask.this.openBtn.setEnabled(false);
            SxMask.this.helpItemString = "Themaauswhlen.htm";
            CSH.setHelpIDString((Component)SxMask.this.openBtn, (String)SxMask.this.helpItemString);
            openBtnPanel.add(SxMask.this.openBtn);
            this.add((Component)centerp, "Center");
            this.add((Component)openBtnPanel, "South");
        }
    }
}

