/*
 * Decompiled with CFR 0.152.
 */
package de.superx.applet;

import de.superx.applet.SxDate;
import de.superx.applet.SxDefaults;
import de.superx.applet.SxDeleteListener;
import de.superx.applet.SxDlg;
import de.superx.applet.SxField;
import de.superx.applet.SxForm;
import de.superx.applet.SxInsertListener;
import de.superx.applet.SxMask;
import de.superx.applet.SxSQL;
import de.superx.applet.SxSQLMetaData;
import de.superx.applet.SxTableModel;
import de.superx.applet.SxTablePanel;
import de.superx.applet.SxUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.TableColumnModel;

public class SxDlgManager {
    private static boolean isSQLstatic;
    static Hashtable dlg_map;
    static Component dlg_panel;
    static SxTablePanel sxTablePanel;
    static SxTablePanel sxTablePanel2;
    static Vector V_header;
    static Vector V_sql;
    static Vector V_sql2;
    static Vector V_empty;
    static SxSQLMetaData meta;

    static {
        dlg_map = null;
        dlg_panel = null;
        sxTablePanel = null;
        sxTablePanel2 = null;
        V_header = null;
        V_sql = null;
        V_sql2 = null;
        V_empty = null;
        meta = null;
        dlg_map = new Hashtable();
        V_header = new Vector();
        V_sql = new Vector();
        V_sql2 = new Vector();
        V_empty = new Vector();
        sxTablePanel = new SxTablePanel();
        sxTablePanel.getTable().setAutoResizeMode(4);
        sxTablePanel2 = new SxTablePanel();
        sxTablePanel2.getTable().setAutoResizeMode(4);
    }

    static synchronized void openDlg(SxMask mask, SxForm form, String name, String caption, int fieldnr, int dlg_art) {
        if (dlg_art != 1 && dlg_art != 2 && dlg_art != 10) {
            return;
        }
        Vector v_field = (Vector)form.getFieldVector().elementAt(fieldnr);
        isSQLstatic = true;
        int zeilenanzahl = (Integer)v_field.elementAt(7);
        SxField field = form.getField("F_" + name.substring(2));
        V_header.removeAllElements();
        V_sql.removeAllElements();
        V_sql2.removeAllElements();
        V_empty.removeAllElements();
        String stmt = SxDlgManager.getReadingSql(dlg_art, form, v_field);
        boolean isTemplate = stmt.toUpperCase().indexOf("FREEMARKER TEMPLATE") > -1;
        try {
            if (isTemplate) {
                HashMap map = form.getHashMap(null);
                stmt = SxSQL.templateProcessor.process("Feld sql ", stmt, map, (String)SxDefaults.getPropertyValue("SxDB"));
            }
            Object dlg_prop = null;
            form.getLogo().start();
            SxSQL.executeAll(stmt);
            form.getLogo().stop();
            JComponent dlg_comp = SxDlgManager.prepareDlgComp(form, name, caption, zeilenanzahl, field);
            SxDlg dlg = new SxDlg((Frame)form.getTopLevelAncestor(), caption, dlg_comp);
            dlg.show();
            if (dlg.wasOkSelected()) {
                if (zeilenanzahl == 1) {
                    SxDlgManager.setField(field, dlg_art, false);
                }
                if (zeilenanzahl > 1) {
                    SxDlgManager.setField(field, dlg_art, true);
                }
            }
            if (dlg.wasClearSelected()) {
                JComboBox combo;
                field.setKey(new String("-1"));
                field.setText("");
                if (field.isWithCombo() && (combo = (JComboBox)form.getComp("F_" + name.substring(2))).getItemCount() > 0) {
                    combo.removeAllItems();
                }
            }
            field.setBackground(Color.white);
            field.repaint();
        }
        catch (Exception ex) {
            String msg = ex.toString();
            JOptionPane.showMessageDialog(form, msg.substring(msg.lastIndexOf(":") + 1), "SQL-Fehler", 0);
        }
    }

    private static JComponent prepareDlgComp(SxForm form, String name, String caption, int zeilenanzahl, SxField field) {
        int row;
        meta = SxSQL.getResultSetMetaData();
        if (meta.getColumnCount() > 1) {
            V_header.addElement("ID");
        }
        V_header.addElement(caption);
        V_sql = SxSQL.getResultVector();
        if (isSQLstatic) {
            SxDlgManager.addDialogSet(name, V_header.clone(), V_sql.clone(), meta);
        }
        int cols = meta.getColumnCount();
        sxTablePanel.setData(V_sql, V_header, null, meta);
        if (zeilenanzahl > 1) {
            Object key = field.getKey();
            if (key instanceof String[]) {
                String[] keys = (String[])key;
                JComboBox combo = (JComboBox)form.getComp("F_" + name.substring(2));
                int n = combo.getItemCount();
                int i2 = 0;
                while (i2 < n) {
                    Vector<Object> V_row = new Vector<Object>();
                    switch (meta.getColumnType(1)) {
                        case 5: {
                            V_row.addElement(new Short(keys[i2]));
                            break;
                        }
                        case 4: {
                            V_row.addElement(new Integer(keys[i2]));
                            break;
                        }
                        case 3: 
                        case 8: {
                            V_row.addElement(new Double(keys[i2]));
                            break;
                        }
                        case 91: {
                            V_row.addElement(SxDate.getDate(keys[i2]));
                            break;
                        }
                        default: {
                            V_row.addElement(keys[i2]);
                        }
                    }
                    V_row.addElement(combo.getItemAt(i2));
                    V_sql2.addElement(V_row);
                    ++i2;
                }
                sxTablePanel2.setData(V_sql2, V_header, null, meta);
            } else if (key.toString().compareTo(new String("-1")) != 0) {
                Vector<Object> V_row = new Vector<Object>();
                V_row.addElement(key);
                V_row.addElement(field.getText());
                V_sql2.addElement(V_row);
                sxTablePanel2.setData(V_sql2, V_header, null, meta);
            } else {
                if (cols > 1) {
                    V_empty.addElement(new Integer(Integer.MIN_VALUE));
                }
                V_empty.addElement(new String(""));
                V_sql2.addElement(V_empty);
                sxTablePanel2.setData(V_sql2, V_header, null, meta);
                V_sql2.removeAllElements();
            }
        }
        Dimension dim = sxTablePanel.getTable().getPreferredSize();
        if (dim.height > 300) {
            dim.height = 300;
        }
        TableColumnModel cmodel = sxTablePanel.getTable().getColumnModel();
        if (cols > 1 && SxSQL.getRowCount() > 0) {
            sxTablePanel.getTable().removeColumn(cmodel.getColumn(0));
            if (zeilenanzahl > 1) {
                TableColumnModel cmodel2 = sxTablePanel2.getTable().getColumnModel();
                sxTablePanel2.getTable().removeColumn(cmodel2.getColumn(0));
            }
            --cols;
        }
        if (cols > 1 && SxSQL.getRowCount() > 0) {
            cmodel.getColumn(0).setMaxWidth(80);
        }
        dim.width = cmodel.getTotalColumnWidth();
        if (dim.width < 250) {
            dim.width = 250;
        }
        if ((row = sxTablePanel.getTable().getSelectedRow()) >= 0) {
            sxTablePanel.getTable().setRowSelectionInterval(row, row);
        }
        sxTablePanel.getTable().setPreferredScrollableViewportSize(dim);
        sxTablePanel2.getTable().setPreferredScrollableViewportSize(dim);
        sxTablePanel.setMinimumSize(new Dimension(dim.width + 5, dim.height + 5));
        sxTablePanel2.setMinimumSize(new Dimension(dim.width + 5, dim.height + 5));
        JComponent dlg_comp = zeilenanzahl > 1 ? SxDlgManager.createTwoTablesPanel() : sxTablePanel;
        return dlg_comp;
    }

    private static String getReadingSql(int dlg_art, SxForm form, Vector v_field) {
        String stmt = null;
        String sx_db = (String)SxDefaults.getPropertyValue("SxDB");
        String relation = (String)v_field.elementAt(12);
        if (relation != null) {
            relation = relation.trim();
        }
        boolean isTemplate = relation.toUpperCase().indexOf("FREEMARKER TEMPLATE") > -1;
        String attribut = (String)v_field.elementAt(13);
        if (attribut != null) {
            attribut = attribut.trim();
        }
        switch (dlg_art) {
            case 1: {
                if (relation.startsWith("sp_")) {
                    stmt = "execute procedure " + relation;
                    if (!sx_db.equals("Postgres")) break;
                    stmt = "select " + relation;
                    break;
                }
                if (relation.startsWith("<<SQL>>")) {
                    stmt = relation.substring(7);
                    break;
                }
                if (attribut.indexOf(44) == -1) {
                    attribut = "tid, " + attribut;
                }
                stmt = "select " + attribut + " from " + relation + " order by 2";
                break;
            }
            case 2: {
                stmt = "execute procedure " + relation;
                if (!sx_db.equals("Postgres")) break;
                stmt = "select " + relation;
                break;
            }
            case 10: {
                if (relation.startsWith("sp_")) {
                    stmt = "execute procedure " + relation;
                    if (!sx_db.equals("Postgres")) break;
                    stmt = "select " + relation;
                    break;
                }
                stmt = relation.startsWith("<<SQL>>") ? relation.substring(7) : relation;
            }
        }
        String prefix = SxUtils.getFieldPrefix();
        if (stmt.indexOf(prefix) >= 0) {
            isSQLstatic = false;
            stmt = SxUtils.generateSQL(form, stmt);
            int err_start = -1;
            err_start = stmt.indexOf(prefix);
            if (err_start >= 0) {
                String suffix = SxUtils.getFieldSuffix();
                int err_stop = stmt.indexOf(suffix, err_start);
                String err_field = stmt.substring(err_start += prefix.length(), err_stop);
                String msg = "SQL-Fehler durch '" + err_field + "' !";
                JOptionPane.showMessageDialog(form, msg, "Dialogfehler", 0);
                throw new IllegalArgumentException(msg);
            }
        }
        if (isTemplate) {
            stmt = "--Freemarker Template\n" + stmt;
        }
        return stmt;
    }

    public static void setField(SxField field, int dlg_art, boolean isMultiDlg) throws SQLException {
        SxTableModel tmodel;
        SxForm form = field.getForm();
        if (form == null) {
            return;
        }
        if (!isMultiDlg) {
            tmodel = (SxTableModel)sxTablePanel.getTable().getModel();
            int row = sxTablePanel.getTable().getSelectedRow();
            if (row < 0) {
                return;
            }
            switch (dlg_art) {
                case 1: 
                case 2: {
                    if (meta.getColumnCount() > 1) {
                        field.setKey(tmodel.getValueAt2(row, 0));
                        field.setText((String)tmodel.getValueAt(row, 1));
                        break;
                    }
                    field.setKey(new String("-1"));
                    field.setText((String)tmodel.getValueAt(row, 0));
                    break;
                }
            }
        } else {
            tmodel = (SxTableModel)sxTablePanel2.getTable().getModel();
            int rows = tmodel.getRowCount();
            int cols = tmodel.getColumnCount();
            switch (dlg_art) {
                case 1: 
                case 2: {
                    if (rows < 0) break;
                    JComboBox combo = null;
                    if (!field.isWithCombo()) break;
                    combo = (JComboBox)form.getComp(field.getName());
                    if (combo.getItemCount() > 0) {
                        combo.removeAllItems();
                    }
                    String[] keys = new String[rows];
                    int i2 = 0;
                    while (i2 < rows) {
                        keys[i2] = (String)tmodel.getValueAt(i2, 0);
                        if (cols == 1) {
                            combo.insertItemAt(tmodel.getValueAt2(i2, 0), i2);
                        } else {
                            combo.insertItemAt(tmodel.getValueAt(i2, 1), i2);
                        }
                        ++i2;
                    }
                    field.setKey(keys);
                    break;
                }
            }
            if (rows > 0) {
                field.setText(" < Ihre Auswahl > ");
            } else {
                field.setKey(new String("-1"));
                field.setText("");
            }
        }
        Component err_comp = form.getErrorComp(field.getName());
        if (err_comp != null) {
            form.removeErrorComp(err_comp);
        }
    }

    public static void addDialogSet(String name, Object nheader, Object ndata, Object nmeta) {
        Properties prop = new Properties();
        prop.put("header", nheader);
        prop.put("data", ndata);
        prop.put("meta", nmeta);
        dlg_map.put(name, prop);
    }

    public static Properties getDialogSet(String name) {
        Properties prop = (Properties)dlg_map.get(name);
        return prop;
    }

    public static void clear() {
        dlg_map.clear();
        dlg_map = new Hashtable();
    }

    public static SxTablePanel getDlgTable() {
        return sxTablePanel;
    }

    public static SxTablePanel getChoiceTable() {
        return sxTablePanel2;
    }

    public static Vector getDlgData() {
        return V_sql;
    }

    public static Vector getChoiceData() {
        return V_sql2;
    }

    protected static JComponent createTwoTablesPanel() {
        JPanel dlgPanel = new JPanel(new GridLayout(1, 3));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 2, 5, 2);
        dlgPanel.setLayout(gridbag);
        JPanel btnPanel = new JPanel(new GridLayout(0, 1));
        BasicArrowButton insertBtn = new BasicArrowButton(3);
        insertBtn.setHorizontalAlignment(0);
        SxInsertListener insertl = new SxInsertListener();
        insertBtn.addActionListener(insertl);
        JLabel insertLabel = new JLabel("Einf\u00fcgen");
        insertLabel.setHorizontalAlignment(0);
        BasicArrowButton deleteBtn = new BasicArrowButton(7);
        deleteBtn.setHorizontalAlignment(0);
        SxDeleteListener deletel = new SxDeleteListener();
        deleteBtn.addActionListener(deletel);
        JLabel deleteLabel = new JLabel("L\u00f6schen");
        deleteLabel.setHorizontalAlignment(0);
        btnPanel.add(insertLabel);
        btnPanel.add(insertBtn);
        btnPanel.add(deleteLabel);
        btnPanel.add(deleteBtn);
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        gridbag.setConstraints(sxTablePanel, constraints);
        dlgPanel.add(sxTablePanel);
        constraints.anchor = 10;
        constraints.fill = 0;
        constraints.weightx = 0.25;
        constraints.weighty = 0.25;
        gridbag.setConstraints(btnPanel, constraints);
        dlgPanel.add(btnPanel);
        constraints.anchor = 13;
        constraints.fill = 2;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        gridbag.setConstraints(sxTablePanel2, constraints);
        dlgPanel.add(sxTablePanel2);
        return dlgPanel;
    }
}

