/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;

public class TransletUtils {
    private static TransformerFactory tFactory;
    private static String usedProcessor;

    static {
        usedProcessor = null;
    }

    private TransletUtils() {
    }

    public static synchronized void initFactory() {
        tFactory = TransformerFactory.newInstance();
    }

    public static synchronized void initFactory(String preferredParser, String secondaryParser) {
        String key = "javax.xml.transform.TransformerFactory";
        String oldvalue = System.getProperty(key);
        System.setProperty(key, preferredParser);
        try {
            tFactory = TransformerFactory.newInstance();
            usedProcessor = preferredParser;
        }
        catch (TransformerFactoryConfigurationError e2) {
            if (secondaryParser != null) {
                System.setProperty(key, secondaryParser);
                try {
                    tFactory = TransformerFactory.newInstance();
                    usedProcessor = secondaryParser;
                }
                catch (TransformerFactoryConfigurationError e22) {
                    System.err.println("Weder " + preferredParser + " noch " + secondaryParser + " gefunden");
                    e22.printStackTrace();
                }
            }
            e2.printStackTrace();
            throw new IllegalStateException("Kein XML  Parser " + e2);
        }
        if (oldvalue == null) {
            System.getProperties().remove(key);
        } else {
            System.setProperty(key, oldvalue);
        }
    }

    public static synchronized Templates createTemplate(String xslInURI) throws TransformerConfigurationException {
        if (tFactory == null) {
            TransletUtils.initFactory("org.apache.xalan.xsltc.trax.TransformerFactoryImpl", "net.sf.saxon.TransformerFactoryImpl");
        }
        return tFactory.newTemplates(new StreamSource(xslInURI));
    }

    public static void main(String[] args) {
        System.out.println("javax.xml.transform.TransformerFactory was " + System.getProperty("javax.xml.transform.TransformerFactory"));
        System.getProperties().remove("javax.xml.transform.TransformerFactory");
        System.out.println("after unsetting " + System.getProperty("javax.xml.transform.TransformerFactory"));
    }

    public static String getUsedProcessor() {
        return usedProcessor;
    }
}

