/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util.logging;

import java.io.ObjectStreamException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;

final class LogManagerProperties
extends Properties {
    private static final long serialVersionUID = -2239983349056806252L;
    static final LogManager manager;
    private final String prefix;
    static final /* synthetic */ boolean $assertionsDisabled;

    static final Class findClass(String name) throws ClassNotFoundException {
        Class clazz;
        ClassLoader[] loaders = LogManagerProperties.getClassLoaders();
        if (loaders[0] != null) {
            try {
                clazz = Class.forName(name, false, loaders[0]);
            }
            catch (ClassNotFoundException tryContext) {
                clazz = LogManagerProperties.tryLoad(name, loaders[1]);
            }
        } else {
            clazz = LogManagerProperties.tryLoad(name, loaders[1]);
        }
        return clazz;
    }

    private static Class tryLoad(String name, ClassLoader l2) throws ClassNotFoundException {
        if (l2 != null) {
            return Class.forName(name, false, l2);
        }
        return Class.forName(name);
    }

    private static ClassLoader[] getClassLoaders() {
        return (ClassLoader[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader[] loaders = new ClassLoader[2];
                try {
                    loaders[0] = ClassLoader.getSystemClassLoader();
                }
                catch (SecurityException ignore) {
                    loaders[0] = null;
                }
                try {
                    loaders[1] = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException ignore) {
                    loaders[1] = null;
                }
                return loaders;
            }
        });
    }

    LogManagerProperties(Properties parent, String prefix) {
        super(parent);
        if (prefix == null) {
            throw new NullPointerException();
        }
        this.prefix = prefix;
    }

    public String getProperty(String key) {
        String value = super.getProperty(key);
        if (value == null && key.length() > 0 && (value = manager.getProperty(this.prefix + '.' + key)) == null) {
            value = manager.getProperty(key);
        }
        return value;
    }

    public Enumeration propertyNames() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return super.propertyNames();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Properties)) {
            return false;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return super.equals(o);
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return super.hashCode();
    }

    private synchronized Object writeReplace() throws ObjectStreamException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        Properties out = new Properties(this.defaults);
        if (!super.isEmpty()) {
            out.putAll((Map<?, ?>)this);
        }
        return out;
    }

    static {
        $assertionsDisabled = !LogManagerProperties.class.desiredAssertionStatus();
        manager = LogManager.getLogManager();
    }
}

