/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.web.bruteforce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BruteForceDefender {
    public static final int DEFAULT_MAX_BLACK_LIST_SIZE = 200000;
    public static final int DEFAULT_INITIAL_BLACK_LIST_SIZE = 1000;
    public static final long DEFAULT_MAX_BLOCKING_DURATION = TimeUnit.MINUTES.toMillis(30L);
    public static final long DEFAULT_AUTO_CLEAN_UP_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    public static final int DEFAULT_NOT_BLOCKED_LOGIN_ATTEMPTS = 3;
    private int maxBlackListSize = 200000;
    private long maxBlockingDuration;
    private long autoCleanUpInterval;
    private int notBlockedLoginAttempts = 3;
    private final Map<String, ListEntry> blackList = new LinkedHashMap<String, ListEntry>(1000){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ListEntry> eldest) {
            return this.size() > BruteForceDefender.this.maxBlackListSize;
        }
    };
    private Thread autoCleanUpThread;

    public BruteForceDefender() {
        this.maxBlockingDuration = DEFAULT_MAX_BLOCKING_DURATION;
        this.autoCleanUpInterval = DEFAULT_AUTO_CLEAN_UP_INTERVAL;
        this.autoCleanUpThread = new Thread(new CleanUpRunnable());
        this.autoCleanUpThread.setDaemon(true);
    }

    public void setMaxBlackListSize(int maxBlackListSize) {
        this.maxBlackListSize = maxBlackListSize;
    }

    public int getMaxBlackListSize() {
        return this.maxBlackListSize;
    }

    public void setMaxBlockingDuration(long maxBlockingDuration) {
        this.maxBlockingDuration = maxBlockingDuration;
    }

    public long getMaxBlockingDuration() {
        return this.maxBlockingDuration;
    }

    public void setAutoCleanUpInterval(long autoCleanUpInterval) {
        this.autoCleanUpInterval = autoCleanUpInterval;
    }

    public long getAutoCleanUpInterval() {
        return this.autoCleanUpInterval;
    }

    public void setNotBlockedLoginAttempts(int notBlockedLoginAttempts) {
        this.notBlockedLoginAttempts = notBlockedLoginAttempts;
    }

    public int getNotBlockedLoginAttempts() {
        return this.notBlockedLoginAttempts;
    }

    public void startAutoCleanUpThread() {
        if (!this.autoCleanUpThread.isAlive()) {
            this.autoCleanUpThread.start();
        }
    }

    public void stopAutoCleanUpThread() {
        if (this.autoCleanUpThread.isAlive()) {
            this.autoCleanUpThread.interrupt();
            try {
                this.autoCleanUpThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isLoginBlocked(String user) {
        ListEntry entry = this.getEntry(user);
        return entry != null && entry.isBlocked();
    }

    public synchronized void loginFailed(String user) {
        ListEntry entry = this.getEntry(user);
        if (entry == null) {
            this.blackList.put(user, new ListEntry());
        } else {
            entry.loginFailed();
        }
    }

    public synchronized void loginSuccessed(String user) {
        this.blackList.remove(user);
    }

    public int getBlackListSize() {
        return this.blackList.size();
    }

    private synchronized ListEntry getEntry(String user) {
        ListEntry entry = this.blackList.get(user);
        if (entry != null && entry.isObsolete()) {
            this.blackList.remove(user);
            entry = null;
        }
        return entry;
    }

    private synchronized Collection<String> getUsers() {
        return new ArrayList<String>(this.blackList.keySet());
    }

    public void cleanUp() {
        for (String user : this.getUsers()) {
            this.getEntry(user);
        }
    }

    private final class CleanUpRunnable
    implements Runnable {
        private CleanUpRunnable() {
        }

        @Override
        public void run() {
            while (true) {
                BruteForceDefender.this.cleanUp();
                try {
                    Thread.sleep(BruteForceDefender.this.autoCleanUpInterval);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    private final class ListEntry {
        private int numOfFailedLogins = 1;
        private long timeOfLastFailedLogin = System.currentTimeMillis();

        public boolean isObsolete() {
            return this.timeOfLastFailedLogin < System.currentTimeMillis() - BruteForceDefender.this.maxBlockingDuration;
        }

        public boolean isBlocked() {
            return this.numOfFailedLogins > BruteForceDefender.this.notBlockedLoginAttempts && System.currentTimeMillis() < this.timeOfLastFailedLogin + TimeUnit.SECONDS.toMillis(1 << this.numOfFailedLogins - BruteForceDefender.this.notBlockedLoginAttempts - 1);
        }

        public void loginFailed() {
            ++this.numOfFailedLogins;
            this.timeOfLastFailedLogin = System.currentTimeMillis();
        }
    }
}

