/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.cpp.CppCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppErrorTextProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppSettings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;

public class CppPlausiElementCodeGenerator
extends CppCodeGenerator {
    protected void createFehlerMethod(Scope scope, String programName, String schluessel, MetaProgram fehlerKurzProgram, MetaProgram fehlerLangProgram, MetaProgram korrekturhinweisProgram, String referenzTB, String[] referenzFeldStruktur, String[] referenzFeldTypen, int[][] referenzFeldIndizes, short art) {
        this.defineMethod("PL_VOID", "prb_" + programName, "RuntimeContext* context, ProblemInfoType infoType, const PL_STRING exception = PL_NULL");
        this.openBlock();
        this.indentNewLine();
        this.out.print("PlausiProblem");
        this.out.print("* problem = createPlausiProblem(context, \"");
        this.out.print(schluessel);
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("problem->setInfoType(infoType);");
        if (fehlerKurzProgram != null || fehlerLangProgram != null || korrekturhinweisProgram != null) {
            this.indentNewLine();
            this.out.print("try");
            this.openBlock();
            CppErrorTextProgramCodeGenerator prgGen = new CppErrorTextProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            if (fehlerKurzProgram != null) {
                this.indentNewLine();
                this.out.print("PL_CHAR __shortDescription[MAX_PROBLEM_TEXT_LENGTH];");
                this.indentNewLine();
                this.out.print("std::ostrstream __shortDescriptionOut(__shortDescription, MAX_PROBLEM_TEXT_LENGTH);");
                this.indentNewLine();
                this.out.print("__shortDescriptionOut << ");
                prgGen.generate(fehlerKurzProgram, scope, false);
                this.out.print(" << std::ends;");
                this.indentNewLine();
                this.out.print("problem->setShortDescription(__shortDescription);");
            }
            if (fehlerLangProgram != null) {
                this.indentNewLine();
                this.out.print("PL_CHAR __longDescription[MAX_PROBLEM_TEXT_LENGTH];");
                this.indentNewLine();
                this.out.print("std::ostrstream __longDescriptionOut(__longDescription, MAX_PROBLEM_TEXT_LENGTH);");
                this.indentNewLine();
                this.out.print("__longDescriptionOut << ");
                prgGen.generate(fehlerLangProgram, scope, false);
                this.out.print(" << std::ends;");
                this.indentNewLine();
                this.out.print("problem->setLongDescription(__longDescription);");
            }
            if (korrekturhinweisProgram != null) {
                this.indentNewLine();
                this.out.print("PL_CHAR __correctionInfo[MAX_PROBLEM_TEXT_LENGTH];");
                this.indentNewLine();
                this.out.print("std::ostrstream __correctionInfoOut(__correctionInfo, MAX_PROBLEM_TEXT_LENGTH);");
                this.indentNewLine();
                this.out.print("__correctionInfoOut << ");
                prgGen.generate(korrekturhinweisProgram, scope, false);
                this.out.print(" << std::ends;");
                this.indentNewLine();
                this.out.print("problem->setCorrectionInfo(__correctionInfo);");
            }
            this.closeBlock();
            this.indentNewLine();
            this.out.print("catch (...)");
            this.openBlock();
            this.closeBlock();
        }
        boolean referenzFeldHatListen = false;
        if (referenzFeldStruktur != null && referenzFeldStruktur.length > 0) {
            int i = 0;
            while (i < referenzFeldIndizes.length) {
                if (referenzFeldIndizes[i] != null && referenzFeldIndizes[i].length > 0) {
                    referenzFeldHatListen = true;
                    break;
                }
                ++i;
            }
            if (referenzFeldHatListen) {
                this.indentNewLine();
                this.out.print("try");
                this.openBlock();
            }
            this.indentNewLine();
            this.out.print("Field* __refField = ");
            i = 0;
            while (i < referenzFeldStruktur.length) {
                if (i > 0) {
                    this.out.print("->");
                }
                boolean referenzFeldIstListe = referenzFeldIndizes[i] != null && referenzFeldIndizes[i].length > 0;
                this.out.print(StringHelper.getEscapedName(referenzFeldStruktur[i]));
                if (referenzFeldIstListe) {
                    this.out.print("->getElement(context, ");
                    this.out.print(referenzFeldIndizes[i].length);
                    int j = 0;
                    while (j < referenzFeldIndizes[i].length) {
                        this.out.print(", ");
                        int index = referenzFeldIndizes[i][j];
                        if (index > 0) {
                            --index;
                        }
                        this.out.print(index);
                        ++j;
                    }
                    this.out.print(")");
                }
                ++i;
            }
            this.out.print(";");
            this.indentNewLine();
            this.out.print("PL_CHAR problemId[MAX_FIELD_NAME_LENGTH];");
            this.indentNewLine();
            this.out.print("__refField->getHierarchyAsString(problemId);");
            this.indentNewLine();
            this.out.print("strcat(problemId, \"#");
            this.out.print(schluessel);
            this.out.print("\");");
            this.indentNewLine();
            this.out.print("problem->setId(problemId);");
            this.indentNewLine();
            this.out.print("problem->setReferenceField(__refField);");
            if (referenzFeldHatListen) {
                this.closeBlock();
                this.indentNewLine();
                this.out.print("catch (PlausiException& ex)");
                this.openBlock();
                this.indentNewLine();
                this.out.print("context->getLogger()->error() << \"Fehler beim Zugriff auf Indizes im Hauptbezugsfeld von " + programName + " (\" << ex.getMessage() << \")\";");
            }
        } else {
            this.indentNewLine();
            this.out.print("problem->setReferenceField(context->getCurrentField());");
        }
        if (referenzFeldHatListen || referenzFeldStruktur == null || referenzFeldStruktur.length == 0) {
            this.indentNewLine();
            this.out.print("if (context->getCurrentField() != PL_NULL)");
            this.openBlock();
            this.indentNewLine();
            this.out.print("PL_CHAR problemId[MAX_FIELD_NAME_LENGTH];");
            this.indentNewLine();
            this.out.print("context->getCurrentField()->getHierarchyAsString(problemId);");
            this.indentNewLine();
            this.out.print("strcat(problemId, \"#");
            this.out.print(schluessel);
            this.out.print("\");");
            this.indentNewLine();
            this.out.print("problem->setId(problemId);");
            this.closeBlock();
            this.indentNewLine();
            this.out.print("else");
            this.openBlock();
            this.indentNewLine();
            this.out.print("problem->setId(\"#");
            this.out.print(schluessel);
            this.out.print("\");");
            this.closeBlock();
        }
        if (referenzFeldHatListen) {
            this.closeBlock();
        }
        this.indentNewLine();
        this.out.print("problem->setException(exception);");
        this.indentNewLine();
        this.out.print("context->getLogger()->trace() << \"FehlerID angeschrieben: \" << problem->getId();");
        this.indentNewLine();
        this.out.print("context->setSectionInfosToProblem(problem);");
        this.closeBlock();
    }

    protected void createPlausiFehlerErzeugung(String schluessel, String fehlerKurz, String kommentar, String korrekturhinweis, String referenzTB, short gewicht, short art, int[] referenzFeldIndizes, short merkmalstyp, String maske, long wertlaenge, String wertebereich, String merkmalsbezeichnung) {
        this.indentNewLine();
        this.out.print("PlausiProblem");
        this.out.print("* problem = context->createProblem(");
        this.out.print(CppSettings.getRuntimeProblemType(art));
        this.out.print(", ");
        this.out.print(gewicht);
        this.out.print(");");
        if (schluessel != null) {
            this.indentNewLine();
            this.out.print("problem->setId(\"");
            this.out.print(schluessel);
            this.out.print("\");");
        }
        this.indentNewLine();
        this.out.print("problem->setShortDescription(\"");
        this.out.print(StringHelper.getEscapedStringValue(fehlerKurz));
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("problem->setLongDescription(\"");
        this.out.print(StringHelper.getEscapedStringValue(kommentar));
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("problem->setCorrectionInfo(\"");
        this.out.print(StringHelper.getEscapedStringValue(korrekturhinweis));
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("problem->setReferenceTopic(\"");
        this.out.print(referenzTB);
        this.out.print("\");");
        if (referenzFeldIndizes != null && referenzFeldIndizes.length > 0) {
            this.indentNewLine();
            this.out.print("problem->setReferenceFieldIndices(");
            this.out.print(referenzFeldIndizes.length);
            int i = 0;
            while (i < referenzFeldIndizes.length) {
                this.out.print(", ");
                int index = referenzFeldIndizes[i];
                if (index > 0) {
                    --index;
                }
                this.out.print(index);
                ++i;
            }
            this.out.print(");");
        }
        if (merkmalstyp > 0) {
            this.indentNewLine();
            this.out.print("problem->setFieldType(");
            this.out.print(CppSettings.getRuntimeFieldType(merkmalstyp));
            this.out.print(");");
        }
        if (merkmalsbezeichnung != null && merkmalsbezeichnung.length() > 0) {
            this.indentNewLine();
            this.out.print("problem->setFieldDisplayName(\"");
            this.out.print(StringHelper.getEscapedStringValue(merkmalsbezeichnung));
            this.out.print("\");");
        }
        if (maske != null && maske.length() > 0) {
            this.indentNewLine();
            this.out.print("problem->setFieldMask(\"");
            this.out.print(StringHelper.getEscapedStringValue(maske));
            this.out.print("\");");
        }
        if (wertlaenge > 0L) {
            this.indentNewLine();
            this.out.print("problem->setFieldLength(");
            this.out.print(wertlaenge);
            this.out.print(");");
        }
        if (wertebereich != null && wertebereich.length() > 0) {
            this.indentNewLine();
            this.out.print("problem->setFieldValueSpace(\"");
            this.out.print(StringHelper.getEscapedStringValue(wertebereich));
            this.out.print("\");");
        }
    }

    protected String getTbClass(MetaThemenbereich tb) {
        return StringHelper.getEscapedName("TB_" + tb.getName());
    }
}

