/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.Type;

public class MemberExpr
extends ExpBase
implements Exp {
    private final Member member;
    private MemberType type;

    public MemberExpr(Member member) {
        Util.assertPrecondition(member != null, "member != null");
        this.member = member;
    }

    public Member getMember() {
        return this.member;
    }

    public String toString() {
        return this.member.getUniqueName();
    }

    @Override
    public Type getType() {
        if (this.type == null) {
            this.type = MemberType.forMember(this.member);
        }
        return this.type;
    }

    @Override
    public MemberExpr clone() {
        return new MemberExpr(this.member);
    }

    @Override
    public int getCategory() {
        return 6;
    }

    @Override
    public Exp accept(Validator validator) {
        return this;
    }

    @Override
    public Calc accept(ExpCompiler compiler) {
        return ConstantCalc.constantMember(this.member);
    }

    @Override
    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }
}

