/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.olapinput.olap4jhelper;

import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.impl.CoordinateIterator;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Member;
import org.pentaho.di.trans.steps.olapinput.olap4jhelper.AbstractBaseCell;
import org.pentaho.di.trans.steps.olapinput.olap4jhelper.DataCell;
import org.pentaho.di.trans.steps.olapinput.olap4jhelper.Matrix;
import org.pentaho.di.trans.steps.olapinput.olap4jhelper.MemberCell;

public class CellSetFormatter {
    private Matrix matrix;

    public static String getValueString(String formattedValue) {
        String[] values = formattedValue.split("\\|");
        if (values.length > 1) {
            return values[1];
        }
        return values[0];
    }

    private static Iterable<Cell> cellIter(final int[] pageCoords, final CellSet cellSet) {
        return new Iterable<Cell>(){

            @Override
            public Iterator<Cell> iterator() {
                int[] axisDimensions = new int[cellSet.getAxes().size() - pageCoords.length];
                assert (pageCoords.length <= axisDimensions.length);
                for (int i = 0; i < axisDimensions.length; ++i) {
                    CellSetAxis axis = (CellSetAxis)cellSet.getAxes().get(i);
                    axisDimensions[i] = axis.getPositions().size();
                }
                final CoordinateIterator coordIter = new CoordinateIterator(axisDimensions, true);
                return new Iterator<Cell>(){

                    @Override
                    public boolean hasNext() {
                        return coordIter.hasNext();
                    }

                    @Override
                    public Cell next() {
                        final int[] ints = coordIter.next();
                        AbstractList<Integer> intList = new AbstractList<Integer>(){

                            @Override
                            public Integer get(int index) {
                                return index < ints.length ? ints[index] : pageCoords[index - ints.length];
                            }

                            @Override
                            public int size() {
                                return pageCoords.length + ints.length;
                            }
                        };
                        return cellSet.getCell((List)intList);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Matrix format(CellSet cellSet) {
        CellSetAxis columnsAxis = cellSet.getAxes().size() > 0 ? (CellSetAxis)cellSet.getAxes().get(0) : null;
        AxisInfo columnsAxisInfo = this.computeAxisInfo(columnsAxis);
        CellSetAxis rowsAxis = cellSet.getAxes().size() > 1 ? (CellSetAxis)cellSet.getAxes().get(1) : null;
        AxisInfo rowsAxisInfo = this.computeAxisInfo(rowsAxis);
        if (cellSet.getAxes().size() > 2) {
            int[] dimensions = new int[cellSet.getAxes().size() - 2];
            for (int i = 2; i < cellSet.getAxes().size(); ++i) {
                CellSetAxis cellSetAxis = (CellSetAxis)cellSet.getAxes().get(i);
                dimensions[i - 2] = cellSetAxis.getPositions().size();
            }
            for (int[] pageCoords : CoordinateIterator.iterate((int[])dimensions)) {
                this.matrix = this.formatPage(cellSet, pageCoords, columnsAxis, columnsAxisInfo, rowsAxis, rowsAxisInfo);
            }
        } else {
            this.matrix = this.formatPage(cellSet, new int[0], columnsAxis, columnsAxisInfo, rowsAxis, rowsAxisInfo);
        }
        return this.matrix;
    }

    private AxisInfo computeAxisInfo(CellSetAxis axis) {
        if (axis == null) {
            return new AxisInfo(0);
        }
        AxisInfo axisInfo = new AxisInfo(axis.getAxisMetaData().getHierarchies().size());
        int p = -1;
        for (Position position : axis.getPositions()) {
            ++p;
            int k = -1;
            for (Member member : position.getMembers()) {
                int topDepth;
                AxisOrdinalInfo axisOrdinalInfo = axisInfo.ordinalInfos.get(++k);
                int n = member.isAll() ? member.getDepth() : (topDepth = member.getHierarchy().hasAll() ? 1 : 0);
                if (axisOrdinalInfo.minDepth > topDepth || p == 0) {
                    axisOrdinalInfo.minDepth = topDepth;
                }
                axisOrdinalInfo.maxDepth = Math.max(axisOrdinalInfo.maxDepth, member.getDepth());
            }
        }
        return axisInfo;
    }

    private Matrix formatPage(CellSet cellSet, int[] pageCoords, CellSetAxis columnsAxis, AxisInfo columnsAxisInfo, CellSetAxis rowsAxis, AxisInfo rowsAxisInfo) {
        int yOffset = columnsAxisInfo.getWidth();
        int xOffsset = rowsAxisInfo.getWidth();
        Matrix matrix = new Matrix(xOffsset + (columnsAxis == null ? 1 : columnsAxis.getPositions().size()), yOffset + (rowsAxis == null ? 1 : rowsAxis.getPositions().size()));
        for (int x = 0; x < xOffsset; ++x) {
            for (int y = 0; y < yOffset; ++y) {
                MemberCell memberInfo = new MemberCell(false, x > 0);
                matrix.set(x, y, memberInfo);
            }
        }
        this.populateAxis(matrix, columnsAxis, columnsAxisInfo, true, xOffsset);
        this.populateAxis(matrix, rowsAxis, rowsAxisInfo, false, yOffset);
        for (Cell cell : CellSetFormatter.cellIter(pageCoords, cellSet)) {
            String cellValue;
            AbstractBaseCell headerCell;
            int z;
            List coordList = cell.getCoordinateList();
            int x = xOffsset;
            if (coordList.size() > 0) {
                x += ((Integer)coordList.get(0)).intValue();
            }
            int y = yOffset;
            if (coordList.size() > 1) {
                y += ((Integer)coordList.get(1)).intValue();
            }
            DataCell cellInfo = new DataCell(true, false);
            for (z = 0; z < matrix.getMatrixHeight(); ++z) {
                headerCell = matrix.get(x, z);
                if (headerCell instanceof MemberCell && ((MemberCell)headerCell).getUniqueName() != null) continue;
                cellInfo.setParentColMember((MemberCell)matrix.get(x, z - 1));
                break;
            }
            for (z = 0; z < matrix.getMatrixWidth(); ++z) {
                headerCell = matrix.get(z, y);
                if (headerCell instanceof MemberCell && ((MemberCell)headerCell).getUniqueName() != null) continue;
                cellInfo.setParentRowMember((MemberCell)matrix.get(z - 1, y));
                break;
            }
            if (cell.getValue() != null && cell.getValue() instanceof Number) {
                cellInfo.setRawNumber((Number)cell.getValue());
            }
            if ((cellValue = cell.getFormattedValue()) == null || cellValue.equals("null")) {
                cellValue = "";
            }
            if (cellValue.length() < 1) {
                Object value = cell.getValue();
                if (value == null || value.equals("null")) {
                    cellValue = "";
                } else {
                    try {
                        String output;
                        DecimalFormat myFormatter = new DecimalFormat("#,###.###");
                        cellValue = output = myFormatter.format(cell.getValue());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            cellInfo.setFormattedValue(CellSetFormatter.getValueString(cellValue));
            matrix.set(x, y, cellInfo);
        }
        return matrix;
    }

    private void populateAxis(Matrix matrix, CellSetAxis axis, AxisInfo axisInfo, boolean isColumns, int offset) {
        if (axis == null) {
            return;
        }
        Member[] prevMembers = new Member[axisInfo.getWidth()];
        MemberCell[] prevMemberInfo = new MemberCell[axisInfo.getWidth()];
        Member[] members = new Member[axisInfo.getWidth()];
        for (int i = 0; i < axis.getPositions().size(); ++i) {
            int x = offset + i;
            Position position = (Position)axis.getPositions().get(i);
            int yOffset = 0;
            List memberList = position.getMembers();
            for (int j = 0; j < memberList.size(); ++j) {
                AxisOrdinalInfo ordinalInfo = axisInfo.ordinalInfos.get(j);
                for (Member member = (Member)memberList.get(j); member != null && member.getDepth() >= ordinalInfo.minDepth; member = member.getParentMember()) {
                    int y = yOffset + member.getDepth() - ordinalInfo.minDepth;
                    members[y] = member;
                }
                yOffset += ordinalInfo.getWidth();
            }
            boolean same = true;
            for (int y = 0; y < members.length; ++y) {
                MemberCell memberInfo = new MemberCell();
                Member member = members[y];
                ArrayList<String> memberPath = new ArrayList<String>();
                for (int z = 0; z <= position.getMembers().size() - 1 && (i >= axis.getPositions().size() - 1 || ((Member)((Position)axis.getPositions().get(i + 1)).getMembers().get(z)).getParentMember() == null || !((Member)((Position)axis.getPositions().get(i + 1)).getMembers().get(z)).getParentMember().equals(member) || member != null && !((Member)position.getMembers().get(z)).getUniqueName().equals(member.getUniqueName())); ++z) {
                    memberPath.add(((Member)position.getMembers().get(z)).getUniqueName());
                }
                if (member != null) {
                    memberPath.add(member.getUniqueName());
                }
                memberInfo.setMemberPath(memberPath);
                boolean bl = same = same && i > 0 && Olap4jUtil.equal((Object)prevMembers[y], (Object)member);
                if (member != null) {
                    if (x - 1 == offset) {
                        matrix.setOffset(offset);
                    }
                    memberInfo.setRawValue(member.getCaption());
                    memberInfo.setFormattedValue(member.getCaption());
                    memberInfo.setParentDimension(member.getDimension().getName());
                    memberInfo.setUniqueName(member.getUniqueName());
                    if (y > 0 && prevMembers[y - 1] != null) {
                        memberInfo.setRightOf(prevMemberInfo[y - 1]);
                    }
                    if (y > 0 && prevMembers[y - 1] != null) {
                        memberInfo.setRightOfDimension(prevMembers[y - 1].getDimension().getName());
                    }
                    if (member.getParentMember() != null) {
                        memberInfo.setParentMember(member.getParentMember().getUniqueName());
                    }
                } else {
                    memberInfo.setRawValue(null);
                    memberInfo.setFormattedValue(null);
                    memberInfo.setParentDimension(null);
                }
                if (isColumns) {
                    memberInfo.setRight(false);
                    memberInfo.setSameAsPrev(same);
                    if (member != null) {
                        memberInfo.setParentDimension(member.getDimension().getName());
                    }
                    matrix.set(x, y, memberInfo);
                } else {
                    if (same) {
                        memberInfo.setFormattedValue(null);
                        memberInfo.setRawValue(null);
                        memberInfo.setParentDimension(null);
                    }
                    memberInfo.setRight(false);
                    memberInfo.setSameAsPrev(false);
                    matrix.set(y, x, memberInfo);
                }
                prevMembers[y] = member;
                prevMemberInfo[y] = memberInfo;
                members[y] = null;
            }
        }
    }

    private static class AxisOrdinalInfo {
        private int minDepth = 1;
        private int maxDepth = 0;

        private AxisOrdinalInfo() {
        }

        public int getWidth() {
            return this.maxDepth - this.minDepth + 1;
        }
    }

    private static class AxisInfo {
        final List<AxisOrdinalInfo> ordinalInfos;

        AxisInfo(int ordinalCount) {
            this.ordinalInfos = new ArrayList<AxisOrdinalInfo>(ordinalCount);
            for (int i = 0; i < ordinalCount; ++i) {
                this.ordinalInfos.add(new AxisOrdinalInfo());
            }
        }

        public int getWidth() {
            int width = 0;
            for (AxisOrdinalInfo info : this.ordinalInfos) {
                width += info.getWidth();
            }
            return width;
        }
    }
}

