/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.olapinput;

import java.sql.DriverManager;
import java.sql.SQLException;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.trans.steps.olapinput.olap4jhelper.AbstractBaseCell;
import org.pentaho.di.trans.steps.olapinput.olap4jhelper.CellDataSet;
import org.pentaho.di.trans.steps.olapinput.olap4jhelper.OlapUtil;

public class OlapHelper {
    private String olap4jDriver;
    private String olap4jUrl;
    private String catalogName;
    private String mdx;
    private String username;
    private String password;
    private CellSet result;
    private String[] headerValues = null;
    private String[][] cellValues = null;
    private OlapConnection olapConnection;

    public OlapHelper(String olap4jDriver, String olap4jUrl, String username, String password, String catalogName, String mdx) {
        this.olap4jDriver = olap4jDriver;
        this.olap4jUrl = "jdbc:xmla:Server=" + olap4jUrl;
        this.catalogName = catalogName;
        this.mdx = mdx;
        this.username = username;
        this.password = password;
    }

    public void openQuery() throws Exception {
        CellSet tmp;
        Class.forName(this.olap4jDriver);
        OlapConnection connection = null;
        connection = Const.isEmpty((String)this.username) && Const.isEmpty((String)this.password) ? (OlapConnection)DriverManager.getConnection(this.olap4jUrl) : (OlapConnection)DriverManager.getConnection(this.olap4jUrl, this.username, this.password);
        OlapConnection wrapper = connection;
        this.olapConnection = (OlapConnection)wrapper.unwrap(OlapConnection.class);
        try {
            if (!Const.isEmpty((String)this.catalogName)) {
                this.olapConnection.setCatalog(this.catalogName);
            }
        }
        catch (SQLException e) {
            throw new OlapException("Error setting catalog for MDX statement: '" + this.catalogName + "'");
        }
        OlapStatement stmt = this.olapConnection.createStatement();
        if (Const.isEmpty((String)this.mdx)) {
            throw new Exception("Error executing empty MDX query");
        }
        this.result = tmp = stmt.executeOlapQuery(this.mdx);
    }

    public void close() throws KettleDatabaseException {
        try {
            if (this.result != null) {
                this.result.close();
            }
            if (this.olapConnection != null) {
                this.olapConnection.close();
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Error closing connection");
        }
    }

    public void createRectangularOutput() throws KettleDatabaseException {
        if (this.result != null) {
            CellDataSet cs = OlapUtil.cellSet2Matrix(this.result);
            AbstractBaseCell[][] headers = cs.getCellSetHeaders();
            this.headerValues = OlapHelper.concatHeader(headers);
            this.cellValues = OlapHelper.castResult(cs.getCellSetBody());
        }
    }

    private static String[][] castResult(AbstractBaseCell[][] cellset) {
        String[][] result = new String[cellset.length][];
        for (int i = 0; i < cellset.length; ++i) {
            String[] row = new String[cellset[i].length];
            for (int k = 0; k < cellset[i].length; ++k) {
                String value = cellset[i][k].getFormattedValue();
                if (value == null || value.equals("") || value.equals("null")) {
                    value = "";
                }
                row[k] = value;
            }
            result[i] = row;
        }
        return result;
    }

    private static String[] concatHeader(AbstractBaseCell[][] cellset) {
        if (cellset.length > 0) {
            String[] row = new String[cellset[0].length];
            for (int k = 0; k < cellset[0].length; ++k) {
                String header = "";
                for (int i = 0; i < cellset.length; ++i) {
                    String value = cellset[i][k].getFormattedValue();
                    if ((value == null || value.equals("") || value.equals("null")) && ((value = cellset[i][k].getRawValue()) == null || value.equals("") || value.equals("null"))) {
                        value = "";
                    }
                    if (value.length() <= 0) continue;
                    if (i > 0) {
                        header = header + ".";
                    }
                    header = header + "[" + value + "]";
                }
                if (Const.isEmpty((String)header)) {
                    header = "Column" + k;
                }
                row[k] = header;
            }
            return row;
        }
        return null;
    }

    public String[][] getRows() {
        return this.cellValues;
    }

    public String[] getHeaderValues() {
        return this.headerValues;
    }

    public String[][] getCellValues() {
        return this.cellValues;
    }
}

