/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.addxml;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.addxml.AddXMLData;
import org.pentaho.di.trans.steps.addxml.AddXMLMeta;
import org.pentaho.di.trans.steps.addxml.XMLField;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AddXML
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = AddXML.class;
    private AddXMLMeta meta;
    private AddXMLData data;
    private DOMImplementation domImplentation;
    private Transformer serializer;

    public AddXML(StepMeta stepMeta, StepDataInterface sdi, int copyNr, TransMeta tm, Trans trans) {
        super(stepMeta, sdi, copyNr, tm, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (AddXMLMeta)smi;
        this.data = (AddXMLData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.fieldIndexes = new int[this.meta.getOutputFields().length];
            for (int i = 0; i < this.data.fieldIndexes.length; ++i) {
                this.data.fieldIndexes[i] = this.getInputRowMeta().indexOfValue(this.meta.getOutputFields()[i].getFieldName());
                if (this.data.fieldIndexes[i] >= 0) continue;
                throw new KettleException(BaseMessages.getString(PKG, (String)"AddXML.Exception.FieldNotFound", (String[])new String[0]));
            }
        }
        Document xmldoc = this.getDomImplentation().createDocument(null, this.meta.getRootNode(), null);
        Element root = xmldoc.getDocumentElement();
        for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
            XMLField outputField = this.meta.getOutputFields()[i];
            String fieldname = outputField.getFieldName();
            ValueMetaInterface v = this.getInputRowMeta().getValueMeta(this.data.fieldIndexes[i]);
            Object valueData = r[this.data.fieldIndexes[i]];
            if (this.meta.isOmitNullValues() && v.isNull(valueData)) continue;
            String value = this.formatField(v, valueData, outputField);
            String element = outputField.getElementName();
            if (element == null || element.length() == 0) {
                element = fieldname;
            }
            if (element == null || element.length() == 0) {
                throw new KettleException("XML does not allow empty strings for element names.");
            }
            if (outputField.isAttribute()) {
                NodeList nodelist;
                String attributeParentName = outputField.getAttributeParentName();
                Element node = attributeParentName == null || attributeParentName.length() == 0 ? root : ((nodelist = root.getElementsByTagName(attributeParentName)).getLength() > 0 ? (Element)nodelist.item(0) : root);
                node.setAttribute(element, value);
                continue;
            }
            if (!element.equals(this.meta.getRootNode())) {
                Element e = xmldoc.createElement(element);
                Text n = xmldoc.createTextNode(value);
                e.appendChild(n);
                root.appendChild(e);
                continue;
            }
            Text n = xmldoc.createTextNode(value);
            root.appendChild(n);
        }
        StringWriter sw = new StringWriter();
        DOMSource domSource = new DOMSource(xmldoc);
        try {
            this.getSerializer().transform(domSource, new StreamResult(sw));
        }
        catch (TransformerException e) {
            throw new KettleException((Throwable)e);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        Object[] outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.getInputRowMeta().size(), (Object)sw.toString());
        this.putRow(this.data.outputRowMeta, outputRowData);
        return true;
    }

    private String formatField(ValueMetaInterface valueMeta, Object valueData, XMLField field) throws KettleValueException {
        String retval = "";
        if (field == null) {
            return "";
        }
        if (valueMeta == null || valueMeta.isNull(valueData)) {
            String defaultNullValue = field.getNullString();
            return Const.isEmpty((String)defaultNullValue) ? "" : defaultNullValue;
        }
        if (valueMeta.isNumeric()) {
            if (!Const.isEmpty((String)field.getFormat())) {
                this.data.df.applyPattern(field.getFormat());
            } else {
                this.data.df.applyPattern(this.data.defaultDecimalFormat.toPattern());
            }
            if (!Const.isEmpty((String)field.getDecimalSymbol())) {
                this.data.dfs.setDecimalSeparator(field.getDecimalSymbol().charAt(0));
            } else {
                this.data.dfs.setDecimalSeparator(this.data.defaultDecimalFormatSymbols.getDecimalSeparator());
            }
            if (!Const.isEmpty((String)field.getGroupingSymbol())) {
                this.data.dfs.setGroupingSeparator(field.getGroupingSymbol().charAt(0));
            } else {
                this.data.dfs.setGroupingSeparator(this.data.defaultDecimalFormatSymbols.getGroupingSeparator());
            }
            if (!Const.isEmpty((String)field.getCurrencySymbol())) {
                this.data.dfs.setCurrencySymbol(field.getCurrencySymbol());
            } else {
                this.data.dfs.setCurrencySymbol(this.data.defaultDecimalFormatSymbols.getCurrencySymbol());
            }
            this.data.df.setDecimalFormatSymbols(this.data.dfs);
            retval = valueMeta.isBigNumber() ? this.data.df.format(valueMeta.getBigNumber(valueData)) : (valueMeta.isNumber() ? this.data.df.format(valueMeta.getNumber(valueData)) : this.data.df.format(valueMeta.getInteger(valueData)));
        } else if (valueMeta.isDate()) {
            if (field != null && !Const.isEmpty((String)field.getFormat()) && valueMeta.getDate(valueData) != null) {
                if (!Const.isEmpty((String)field.getFormat())) {
                    this.data.daf.applyPattern(field.getFormat());
                } else {
                    this.data.daf.applyPattern(this.data.defaultDateFormat.toLocalizedPattern());
                }
                this.data.daf.setDateFormatSymbols(this.data.dafs);
                retval = this.data.daf.format(valueMeta.getDate(valueData));
            } else if (valueMeta.isNull(valueData)) {
                if (field != null && !Const.isEmpty((String)field.getNullString())) {
                    retval = field.getNullString();
                }
            } else {
                retval = valueMeta.getString(valueData);
            }
        } else if (valueMeta.isString()) {
            retval = valueMeta.getString(valueData);
        } else if (valueMeta.isBinary()) {
            if (valueMeta.isNull(valueData)) {
                retval = !Const.isEmpty((String)field.getNullString()) ? field.getNullString() : "";
            } else {
                try {
                    retval = new String(valueMeta.getBinary(valueData), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    retval = "";
                }
            }
        } else {
            retval = valueMeta.getString(valueData);
        }
        return retval;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AddXMLMeta)smi;
        this.data = (AddXMLData)sdi;
        if (!super.init(smi, sdi)) {
            return false;
        }
        try {
            this.setSerializer(TransformerFactory.newInstance().newTransformer());
            this.setDomImplentation(DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation());
            if (this.meta.getEncoding() != null) {
                this.getSerializer().setOutputProperty("encoding", this.meta.getEncoding());
            }
            if (this.meta.isOmitXMLheader()) {
                this.getSerializer().setOutputProperty("omit-xml-declaration", "yes");
            }
        }
        catch (TransformerConfigurationException e) {
            return false;
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        return true;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AddXMLMeta)smi;
        this.data = (AddXMLData)sdi;
        super.dispose(smi, sdi);
    }

    private void setDomImplentation(DOMImplementation domImplentation) {
        this.domImplentation = domImplentation;
    }

    private DOMImplementation getDomImplentation() {
        return this.domImplentation;
    }

    private void setSerializer(Transformer serializer) {
        this.serializer = serializer;
    }

    private Transformer getSerializer() {
        return this.serializer;
    }
}

