/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftpsput;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ftpsget.FTPSConnection;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryFTPSPUT
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryFTPSPUT.class;
    private String serverName = null;
    private String serverPort = "21";
    private String userName;
    private String password;
    private String remoteDirectory = null;
    private String localDirectory = null;
    private String wildcard;
    private boolean binaryMode;
    private int timeout;
    private boolean remove;
    private boolean onlyPuttingNewFiles;
    private boolean activeConnection;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private int connectionType = 0;

    public JobEntryFTPSPUT(String n) {
        super(n, "");
    }

    public JobEntryFTPSPUT() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryFTPSPUT je = (JobEntryFTPSPUT)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remoteDirectory", (String)this.remoteDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"localDirectory", (String)this.localDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"binary", (boolean)this.binaryMode));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (int)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remove", (boolean)this.remove));
        retval.append("      ").append(XMLHandler.addTagValue((String)"only_new", (boolean)this.onlyPuttingNewFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"active", (boolean)this.activeConnection));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_host", (String)this.proxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_username", (String)this.proxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_password", (String)this.proxyPassword));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection_type", (String)FTPSConnection.getConnectionTypeCode(this.connectionType)));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.serverPort = XMLHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.remoteDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"remoteDirectory");
            this.localDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"localDirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.binaryMode = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"binary"));
            this.timeout = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)10000);
            this.remove = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove"));
            this.onlyPuttingNewFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"only_new"));
            this.activeConnection = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"active"));
            this.proxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.proxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_username");
            this.proxyPassword = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_password");
            this.connectionType = FTPSConnection.getConnectionTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"connection_type"), (String)""));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.UnableToLoadFromXml", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.serverPort = rep.getJobEntryAttributeString(id_jobentry, "serverport");
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.remoteDirectory = rep.getJobEntryAttributeString(id_jobentry, "remoteDirectory");
            this.localDirectory = rep.getJobEntryAttributeString(id_jobentry, "localDirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.binaryMode = rep.getJobEntryAttributeBoolean(id_jobentry, "binary");
            this.timeout = (int)rep.getJobEntryAttributeInteger(id_jobentry, "timeout");
            this.remove = rep.getJobEntryAttributeBoolean(id_jobentry, "remove");
            this.onlyPuttingNewFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "only_new");
            this.activeConnection = rep.getJobEntryAttributeBoolean(id_jobentry, "active");
            this.proxyHost = rep.getJobEntryAttributeString(id_jobentry, "proxy_host");
            this.proxyPort = rep.getJobEntryAttributeString(id_jobentry, "proxy_port");
            this.proxyUsername = rep.getJobEntryAttributeString(id_jobentry, "proxy_username");
            this.proxyPassword = rep.getJobEntryAttributeString(id_jobentry, "proxy_password");
            this.connectionType = FTPSConnection.getConnectionTypeByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "connection_type"), (String)""));
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPSPUT.UnableToLoadFromRepo", (String[])new String[]{String.valueOf(id_jobentry)}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "serverport", this.serverPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "remoteDirectory", this.remoteDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "localDirectory", this.localDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "binary", this.binaryMode);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "remove", this.remove);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "only_new", this.onlyPuttingNewFiles);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "active", this.activeConnection);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_host", this.proxyHost);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_port", this.proxyPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_username", this.proxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_password", this.proxyPassword);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "connection_type", FTPSConnection.getConnectionType(this.connectionType));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPSPUT.UnableToSaveToRepo", (String[])new String[]{String.valueOf(id_job)}), (Throwable)dbe);
        }
    }

    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isOnlyPuttingNewFiles() {
        return this.onlyPuttingNewFiles;
    }

    public void setOnlyPuttingNewFiles(boolean onlyPuttingNewFiles) {
        this.onlyPuttingNewFiles = onlyPuttingNewFiles;
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public void setRemoteDirectory(String directory) {
        this.remoteDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(String directory) {
        this.localDirectory = directory;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public boolean isActiveConnection() {
        return this.activeConnection;
    }

    public void setActiveConnection(boolean activeConnection) {
        this.activeConnection = activeConnection;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(int type) {
        this.connectionType = type;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        long filesput = 0L;
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.Starting", (String[])new String[0]));
        }
        String realServerName = this.environmentSubstitute(this.serverName);
        String realServerPort = this.environmentSubstitute(this.serverPort);
        String realUsername = this.environmentSubstitute(this.userName);
        String realPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password));
        String realRemoteDirectory = this.environmentSubstitute(this.remoteDirectory);
        String realWildcard = this.environmentSubstitute(this.wildcard);
        String realLocalDirectory = this.environmentSubstitute(this.localDirectory);
        FTPSConnection connection = null;
        int realPort = Const.toInt((String)this.environmentSubstitute(realServerPort), (int)0);
        connection = new FTPSConnection(this.getConnectionType(), realServerName, realPort, realUsername, realPassword);
        this.buildFTPSConnection(connection);
        if (!Const.isEmpty((String)realRemoteDirectory)) {
            connection.changeDirectory(realRemoteDirectory);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.ChangedDirectory", (String[])new String[]{realRemoteDirectory}));
            }
        }
        realRemoteDirectory = Const.NVL((String)realRemoteDirectory, (String)"/");
        ArrayList<String> myFileList = new ArrayList<String>();
        File localFiles = new File(realLocalDirectory);
        if (!localFiles.exists()) {
            String error = BaseMessages.getString(PKG, (String)"JobFTPSPUT.LocalFileDirectoryNotExists", (String[])new String[0]) + realLocalDirectory;
            throw new Exception(error);
        }
        File[] children = localFiles.listFiles();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isDirectory()) continue;
            myFileList.add(children[i].getName());
        }
        String[] filelist = new String[myFileList.size()];
        myFileList.toArray(filelist);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.FoundFileLocalDirectory", (Object[])new Object[]{filelist.length, realLocalDirectory}));
        }
        Pattern pattern = null;
        if (!Const.isEmpty((String)realWildcard)) {
            pattern = Pattern.compile(realWildcard);
        }
        for (int i = 0; i < filelist.length && !this.parentJob.isStopped(); ++i) {
            boolean getIt = true;
            if (pattern != null) {
                Matcher matcher = pattern.matcher(filelist[i]);
                getIt = matcher.matches();
            }
            if (!getIt) continue;
            boolean fileExist = connection.isFileExists(filelist[i]);
            if (this.isDebug()) {
                if (fileExist) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.FileExists", (String[])new String[]{filelist[i]}));
                } else {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.FileDoesNotExists", (String[])new String[]{filelist[i]}));
                }
            }
            if (fileExist && (this.onlyPuttingNewFiles || !fileExist)) continue;
            String localFilename = realLocalDirectory + Const.FILE_SEPARATOR + filelist[i];
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.PuttingFileToRemoteDirectory", (String[])new String[]{localFilename, realRemoteDirectory}));
            }
            connection.uploadFile(localFilename, filelist[i]);
            ++filesput;
            if (!this.remove) continue;
            new File(localFilename).delete();
            if (!this.isDetailed()) continue;
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.DeletedFile", (String[])new String[]{localFilename}));
        }
        result.setResult(true);
        result.setNrLinesOutput(filesput);
        if (this.isDetailed()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.WeHavePut", (Object[])new Object[]{filesput}));
        }
        if (connection == null) return result;
        try {
            connection.disconnect();
            return result;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.ErrorQuitingFTP", (String[])new String[]{e.getMessage()}));
        }
        return result;
        catch (Exception e) {
            try {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.ErrorPuttingFiles", (String[])new String[]{e.getMessage()}));
                this.logError(Const.getStackTracker((Throwable)e));
                if (connection == null) return result;
            }
            catch (Throwable throwable) {
                if (connection == null) throw throwable;
                try {
                    connection.disconnect();
                    throw throwable;
                }
                catch (Exception e2) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.ErrorQuitingFTP", (String[])new String[]{e2.getMessage()}));
                }
                throw throwable;
            }
            try {
                connection.disconnect();
                return result;
            }
            catch (Exception e3) {
                this.logError(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.ErrorQuitingFTP", (String[])new String[]{e3.getMessage()}));
            }
            return result;
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServerName = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "localDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "serverPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }

    void buildFTPSConnection(FTPSConnection connection) throws Exception {
        if (!Const.isEmpty((String)this.proxyHost)) {
            int proxyport;
            String realProxy_host = this.environmentSubstitute(this.proxyHost);
            String realProxy_username = this.environmentSubstitute(this.proxyUsername);
            String realProxy_password = this.environmentSubstitute(this.proxyPassword);
            realProxy_password = Encr.decryptPasswordOptionallyEncrypted((String)realProxy_password);
            connection.setProxyHost(realProxy_host);
            if (!Const.isEmpty((String)realProxy_username)) {
                connection.setProxyUser(realProxy_username);
            }
            if (!Const.isEmpty((String)realProxy_password)) {
                connection.setProxyPassword(realProxy_password);
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPSPUT.OpenedProxyConnectionOn", (String[])new String[]{realProxy_host}));
            }
            if ((proxyport = Const.toInt((String)this.environmentSubstitute(this.proxyPort), (int)21)) != 0) {
                connection.setProxyPort(proxyport);
            }
        } else if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPSPUT.OpenedConnectionTo", (String[])new String[]{connection.getHostName()}));
        }
        if (this.activeConnection) {
            connection.setPassiveMode(false);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.SetActiveConnection", (String[])new String[0]));
            }
        } else {
            connection.setPassiveMode(true);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.SetPassiveConnection", (String[])new String[0]));
            }
        }
        connection.setTimeOut(this.timeout);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.SetTimeout", (Object[])new Object[]{this.timeout}));
        }
        connection.connect();
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.Logged", (String[])new String[]{connection.getUserName()}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPSPUT.WorkingDirectory", (String[])new String[]{connection.getWorkingDirectory()}));
        }
        if (this.isBinaryMode()) {
            connection.setBinaryMode(true);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Log.BinaryMod", (String[])new String[0]));
            }
        }
    }
}

