/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.MetricsInterface;
import org.pentaho.di.core.metrics.MetricsSnapshotInterface;

public class MetricsRegistry {
    private static MetricsRegistry registry;
    private Map<String, Map<String, MetricsSnapshotInterface>> snapshotMaps = new HashMap<String, Map<String, MetricsSnapshotInterface>>();
    private Map<String, Deque<MetricsSnapshotInterface>> snapshotLists = new HashMap<String, Deque<MetricsSnapshotInterface>>();

    public static MetricsRegistry getInstance() {
        if (registry == null) {
            registry = new MetricsRegistry();
        }
        return registry;
    }

    private MetricsRegistry() {
    }

    public void addSnapshot(LogChannelInterface logChannel, MetricsSnapshotInterface snapshot) {
        MetricsInterface metric = snapshot.getMetric();
        String channelId = logChannel.getLogChannelId();
        switch (metric.getType()) {
            case START: 
            case STOP: {
                Deque<MetricsSnapshotInterface> list = this.getSnapshotList(channelId);
                list.add(snapshot);
                break;
            }
            case MIN: 
            case MAX: 
            case SUM: 
            case COUNT: {
                Map<String, MetricsSnapshotInterface> map = this.getSnapshotMap(channelId);
                map.put(snapshot.getKey(), snapshot);
                break;
            }
        }
    }

    public Map<String, Deque<MetricsSnapshotInterface>> getSnapshotLists() {
        return this.snapshotLists;
    }

    public Map<String, Map<String, MetricsSnapshotInterface>> getSnapshotMaps() {
        return this.snapshotMaps;
    }

    public Deque<MetricsSnapshotInterface> getSnapshotList(String logChannelId) {
        Deque<MetricsSnapshotInterface> list = this.snapshotLists.get(logChannelId);
        if (list == null) {
            list = new LinkedBlockingDeque<MetricsSnapshotInterface>();
            this.snapshotLists.put(logChannelId, list);
        }
        return list;
    }

    public Map<String, MetricsSnapshotInterface> getSnapshotMap(String logChannelId) {
        Map<String, MetricsSnapshotInterface> map = this.snapshotMaps.get(logChannelId);
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap());
            this.snapshotMaps.put(logChannelId, map);
        }
        return map;
    }
}

