/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.ExcelAbstractExporter;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.export.ooxml.GenericElementXlsxMetadataHandler;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporterContext;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporterNature;
import net.sf.jasperreports.engine.export.ooxml.OoxmlEncryptUtil;
import net.sf.jasperreports.engine.export.ooxml.PropsAppHelper;
import net.sf.jasperreports.engine.export.ooxml.PropsCoreHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxContentTypesHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxDrawingHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxDrawingRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxRunHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxSharedStringsHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxSheetHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxSheetRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxStyleHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxWorkbookHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxZip;
import net.sf.jasperreports.engine.export.type.CellEdgeEnum;
import net.sf.jasperreports.engine.export.type.ImageAnchorTypeEnum;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.XlsxMetadataExporterConfiguration;
import net.sf.jasperreports.export.XlsxMetadataReportConfiguration;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XlsxMetadataExporter
extends ExcelAbstractExporter<XlsxMetadataReportConfiguration, XlsxMetadataExporterConfiguration, JRXlsxExporterContext> {
    private static final Log log = LogFactory.getLog(XlsxMetadataExporter.class);
    public static final String XLSX_EXPORTER_KEY = "net.sf.jasperreports.xlsx";
    public static final String XLSX_METADATA_EXPORTER_KEY = "net.sf.jasperreports.metadata.xlsx";
    protected static final String XLSX_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xlsx.";
    protected static final String ONE_CELL = "oneCell";
    protected static final String TWO_CELL = "twoCell";
    protected static final String ABSOLUTE = "absolute";
    protected static final String PARENT_STYLE = "__JR_PARENT_STYLE";
    protected static final String CURRENT_DATA = "__JR_CURRENT_DATA";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected XlsxZip xlsxZip;
    protected XlsxWorkbookHelper wbHelper;
    protected XlsxRelsHelper relsHelper;
    protected XlsxContentTypesHelper ctHelper;
    protected PropsAppHelper appHelper;
    protected PropsCoreHelper coreHelper;
    protected XlsxSheetHelper sheetHelper;
    protected XlsxSheetRelsHelper sheetRelsHelper;
    protected XlsxDrawingHelper drawingHelper;
    protected XlsxDrawingRelsHelper drawingRelsHelper;
    protected XlsxStyleHelper styleHelper;
    protected XlsxSharedStringsHelper sharedStringsHelper;
    protected XlsxCellHelper cellHelper;
    protected StringBuilder definedNames;
    protected String firstSheetName;
    protected String currentSheetName;
    protected Map<String, String> rendererToImagePathMap;
    protected int tableIndex;
    protected boolean startPage;
    protected LinkedList<Color> backcolorStack = new LinkedList();
    protected Color backcolor;
    protected String sheetAutoFilter;
    protected String macroTemplate;
    protected PrintPageFormat oldPageFormat;
    protected Integer currentSheetPageScale;
    protected Integer currentSheetFirstPageNumber;
    protected Map<String, Integer> sheetMapping;
    protected List<String> columnNames;
    protected Map<String, Integer> columnNamesMap;
    protected Map<String, Integer> rowSpanStartIndexesMap;
    protected int rowIndex;
    boolean hasDefinedColumns;
    protected Map<String, Object> currentRow;
    protected Map<String, Object> repeatedValues;
    protected Map<String, Object> columnHeadersRow;
    private JRBasePrintText currentDataElement;

    public XlsxMetadataExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public XlsxMetadataExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
        this.maxColumnIndex = 16383;
    }

    @Override
    protected Class<XlsxMetadataExporterConfiguration> getConfigurationInterface() {
        return XlsxMetadataExporterConfiguration.class;
    }

    @Override
    protected Class<XlsxMetadataReportConfiguration> getItemConfigurationInterface() {
        return XlsxMetadataReportConfiguration.class;
    }

    @Override
    protected void initExport() {
        super.initExport();
        this.sheetInfo = null;
        this.currentRow = new HashMap<String, Object>();
        this.repeatedValues = new HashMap<String, Object>();
        this.columnHeadersRow = new HashMap<String, Object>();
        this.onePagePerSheetMap.clear();
        this.sheetsBeforeCurrentReport = 0;
        this.sheetsBeforeCurrentReportMap.clear();
    }

    @Override
    protected void initReport() {
        super.initReport();
        XlsxMetadataReportConfiguration configuration = (XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration();
        this.styleHelper.setConfiguration(configuration);
        this.nature = new JRXlsxExporterNature(this.jasperReportsContext, this.filter, configuration.isIgnoreGraphics(), configuration.isIgnorePageMargins());
        this.setColumnNames();
    }

    @Override
    protected void exportReportToStream(OutputStream os) throws JRException, IOException {
        this.openWorkbook(os);
        this.sheetNamesMap = new HashMap();
        this.definedNamesMap = new HashMap();
        boolean pageExported = false;
        List<ExporterInputItem> items = this.exporterInput.getItems();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            this.defaultFont = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
            if (!this.hasGlobalSheetNames()) {
                this.sheetNamesIndex = 0;
            }
            XlsxMetadataReportConfiguration configuration = (XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration();
            this.configureDefinedNames(configuration.getDefinedNames());
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && !pages.isEmpty()) {
                JRPrintPage page;
                int endPageIndex;
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int n = endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                if (Boolean.TRUE.equals(configuration.isOnePagePerSheet())) {
                    this.pageIndex = startPageIndex;
                    while (this.pageIndex <= endPageIndex) {
                        this.checkInterrupted();
                        if (pageExported) {
                            this.closeSheet();
                        }
                        page = pages.get(this.pageIndex);
                        this.pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
                        this.sheetInfo = this.getSheetInfo(configuration, null);
                        this.createSheet(this.sheetInfo);
                        ++this.sheetIndex;
                        ++this.sheetNamesIndex;
                        this.rowIndex = 0;
                        for (String key : this.rowSpanStartIndexesMap.keySet()) {
                            this.rowSpanStartIndexesMap.put(key, 0);
                        }
                        this.resetAutoFilters();
                        this.setFreezePane(this.sheetInfo.rowFreezeIndex, this.sheetInfo.columnFreezeIndex);
                        this.exportPage(page);
                        pageExported = true;
                        ++this.pageIndex;
                    }
                } else {
                    this.pageFormat = this.jasperPrint.getPageFormat(startPageIndex);
                    this.sheetInfo = this.getSheetInfo(configuration, this.jasperPrint.getName());
                    this.createSheet(this.sheetInfo);
                    ++this.sheetIndex;
                    ++this.sheetNamesIndex;
                    this.resetAutoFilters();
                    this.setFreezePane(this.sheetInfo.rowFreezeIndex, this.sheetInfo.columnFreezeIndex);
                    if (this.filter instanceof ResetableExporterFilter) {
                        ((ResetableExporterFilter)this.filter).reset();
                    }
                    this.pageIndex = startPageIndex;
                    while (this.pageIndex <= endPageIndex) {
                        this.checkInterrupted();
                        page = pages.get(this.pageIndex);
                        this.pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
                        this.exportPage(page);
                        pageExported = true;
                        ++this.pageIndex;
                    }
                }
            } else if (this.reportIndex == items.size() - 1 && !pageExported) {
                this.exportEmptyReport();
            }
            this.sheetsBeforeCurrentReport = Boolean.TRUE.equals(configuration.isOnePagePerSheet()) ? this.sheetIndex : this.sheetsBeforeCurrentReport + 1;
            ++this.reportIndex;
        }
        this.closeSheet();
        this.closeWorkbook(os);
    }

    @Override
    protected void exportEmptyReport() throws JRException, IOException {
        this.pageFormat = this.jasperPrint.getPageFormat();
        this.sheetInfo = this.getSheetInfo(null, this.jasperPrint.getName());
        this.createSheet(this.sheetInfo);
        ++this.sheetIndex;
        ++this.sheetNamesIndex;
        this.rowIndex = 0;
        this.resetAutoFilters();
        if (this.filter instanceof ResetableExporterFilter) {
            ((ResetableExporterFilter)this.filter).reset();
        }
        this.exportPage(new JRBasePrintPage());
    }

    protected int exportPage(JRPrintPage page) throws JRException {
        if (this.oldPageFormat != this.pageFormat) {
            this.oldPageFormat = this.pageFormat;
        }
        XlsxMetadataReportConfiguration configuration = (XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration();
        if (this.currentRow == null) {
            this.currentRow = new HashMap<String, Object>();
        } else if (!this.currentRow.isEmpty()) {
            this.writeCurrentRow(this.currentRow, this.repeatedValues);
        }
        this.exportElements(page.getElements(), null);
        if (this.columnNames.size() > this.maxColumnIndex + 1) {
            throw new JRException("export.xls.common.column.index.beyond.limit", this.columnNames.size(), this.maxColumnIndex + 1);
        }
        if (!this.columnNames.isEmpty()) {
            this.writeCurrentRow(this.currentRow, this.repeatedValues);
        }
        if (this.autoFilterStart != null) {
            this.setAutoFilter(this.autoFilterStart + ":" + (this.autoFilterEnd != null ? this.autoFilterEnd : this.autoFilterStart));
        } else if (this.autoFilterEnd != null) {
            this.setAutoFilter(this.autoFilterEnd + ":" + this.autoFilterEnd);
        }
        this.setRowLevels(null, null);
        JRExportProgressMonitor progressMonitor = configuration.getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
        return 0;
    }

    protected void exportElements(List<JRPrintElement> elements, JRStyle style) throws JRException {
        if (elements != null) {
            for (int i = 0; i < elements.size(); ++i) {
                int columnFreezeIndex;
                JRPrintElement element = elements.get(i);
                if (element instanceof JRPrintFrame) {
                    this.exportElements(((JRPrintFrame)element).getElements(), element.getStyle());
                    continue;
                }
                String sheetName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.sheet.name");
                if (sheetName != null) {
                    this.setSheetName(sheetName);
                }
                this.exportElement(element, style);
                String currentColumnName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
                String rowFreeze = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.freeze.row.edge");
                int rowFreezeIndex = rowFreeze == null ? -1 : (CellEdgeEnum.BOTTOM.getName().equals(rowFreeze) ? this.rowIndex + 1 : this.rowIndex);
                String columnFreeze = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.freeze.column.edge");
                int n = columnFreeze == null ? -1 : (columnFreezeIndex = CellEdgeEnum.RIGHT.getName().equals(columnFreeze) ? this.columnNamesMap.get(currentColumnName) + 1 : this.columnNamesMap.get(currentColumnName));
                if (rowFreezeIndex <= 0 && columnFreezeIndex <= 0) continue;
                this.setFreezePane(rowFreezeIndex, columnFreezeIndex);
            }
        }
    }

    public JRPrintImage getImage(ExporterInput exporterInput, JRPrintElementIndex imageIndex) throws JRException {
        List<ExporterInputItem> items = exporterInput.getItems();
        ExporterInputItem item = items.get(imageIndex.getReportIndex());
        JasperPrint report = item.getJasperPrint();
        JRPrintPage page = report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        JRPrintElement element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        if (element instanceof JRGenericPrintElement) {
            JRGenericPrintElement genericPrintElement = (JRGenericPrintElement)element;
            return ((GenericElementXlsxMetadataHandler)GenericElementHandlerEnviroment.getInstance(this.jasperReportsContext).getElementHandler(genericPrintElement.getGenericType(), XLSX_METADATA_EXPORTER_KEY)).getImage((JRXlsxExporterContext)this.exporterContext, genericPrintElement);
        }
        return (JRPrintImage)element;
    }

    protected void exportStyledText(JRStyle style, JRStyledText styledText, Locale locale, boolean isStyledText, String currentData) {
        XlsxRunHelper runHelper = new XlsxRunHelper(this.jasperReportsContext, this.getExporterKey());
        if (currentData == null) {
            String text = styledText.getText();
            int runLimit = 0;
            AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
            while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
                runHelper.export(style, iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), locale, this.invalidCharReplacement, isStyledText);
                iterator.setIndex(runLimit);
            }
        } else {
            runHelper.export(style, new HashMap<AttributedCharacterIterator.Attribute, Object>(), currentData, locale, this.invalidCharReplacement, isStyledText);
        }
        String sharedString = runHelper.getSharedString();
        int index = this.sharedStringsHelper.export(sharedString);
        this.sheetHelper.write(String.valueOf(index));
    }

    protected JRPrintElementIndex getElementIndex(int colIndex) {
        return new JRPrintElementIndex(this.reportIndex, this.pageIndex, String.valueOf(colIndex + 1 + this.rowIndex * (this.columnNames == null ? 0 : this.columnNames.size())));
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("export.common.invalid.image.name", imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = this.backcolorStack.removeLast();
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTargetValue()) {
            case SELF: {
                target = "_self";
                break;
            }
            default: {
                target = "_blank";
            }
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href = null;
        XlsxMetadataReportConfiguration configuration = (XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration();
        Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink("net.sf.jasperreports.export.xls.ignore.hyperlink", link);
        if (ignoreHyperlink == null) {
            ignoreHyperlink = configuration.isIgnoreHyperlink();
        }
        if (!ignoreHyperlink.booleanValue()) {
            JRHyperlinkProducer customHandler = this.getHyperlinkProducer(link);
            if (customHandler == null) {
                boolean includeAnchors = !Boolean.TRUE.equals(configuration.isIgnoreAnchors());
                boolean onePagePerSheet = Boolean.TRUE.equals(configuration.isOnePagePerSheet());
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() == null) break;
                        try {
                            href = link.getHyperlinkReference().replaceAll("\\s", URLEncoder.encode(" ", "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            href = link.getHyperlinkReference();
                        }
                        break;
                    }
                    case LOCAL_ANCHOR: {
                        if (!includeAnchors || link.getHyperlinkAnchor() == null) break;
                        href = link.getHyperlinkAnchor();
                        break;
                    }
                    case LOCAL_PAGE: {
                        if (!includeAnchors || link.getHyperlinkPage() == null) break;
                        href = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (onePagePerSheet ? link.getHyperlinkPage().toString() : "1");
                        break;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() == null || link.getHyperlinkAnchor() == null) break;
                        try {
                            href = link.getHyperlinkReference().replaceAll("\\s", URLEncoder.encode(" ", "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            href = link.getHyperlinkReference();
                        }
                        href = href + "#" + link.getHyperlinkAnchor();
                        break;
                    }
                }
            } else {
                href = customHandler.getHyperlink(link);
            }
        }
        return href;
    }

    protected void insertPageAnchor() {
        if (!Boolean.TRUE.equals(((XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreAnchors()) && this.startPage) {
            String anchorPage = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (this.sheetIndex - this.sheetsBeforeCurrentReport);
            String ref = "'" + JRStringUtil.xmlEncode(this.currentSheetName) + "'!$A$1";
            this.definedNames.append("<definedName name=\"" + this.getDefinedName(anchorPage) + "\">" + ref + "</definedName>\n");
            this.startPage = false;
        }
    }

    @Override
    protected void closeWorkbook(OutputStream os) throws JRException {
        if (this.sheetMapping != null && this.definedNamesMap != null && !this.definedNamesMap.isEmpty()) {
            for (Map.Entry entry : this.definedNamesMap.entrySet()) {
                String name = ((ExcelAbstractExporter.NameScope)entry.getKey()).getName();
                String localSheetId = "";
                if (name == null || entry.getValue() == null) continue;
                String scope = ((ExcelAbstractExporter.NameScope)entry.getKey()).getScope();
                if (scope != null && !scope.equalsIgnoreCase("workbook") && this.sheetMapping.containsKey(scope)) {
                    localSheetId = " localSheetId=\"" + this.sheetMapping.get(scope) + "\"";
                }
                this.definedNames.append("<definedName name=\"" + name + "\"" + localSheetId + ">" + (String)entry.getValue() + "</definedName>\n");
            }
        }
        this.styleHelper.export();
        this.styleHelper.close();
        this.sharedStringsHelper.exportFooter();
        this.sharedStringsHelper.close();
        try {
            this.wbHelper.exportFooter();
            this.wbHelper.close();
            this.relsHelper.exportFooter();
            this.relsHelper.close();
            this.ctHelper.exportFooter();
            this.ctHelper.close();
            this.appHelper.exportFooter();
            this.appHelper.close();
            this.coreHelper.exportFooter();
            this.coreHelper.close();
            String password = ((XlsxMetadataExporterConfiguration)this.getCurrentConfiguration()).getEncryptionPassword();
            if (password == null || password.trim().length() == 0) {
                this.xlsxZip.zipEntries(os);
            } else {
                OoxmlEncryptUtil.zipEntries(this.xlsxZip, os, password);
            }
            this.xlsxZip.dispose();
        }
        catch (IOException e) {
            throw new JRException(e);
        }
    }

    protected void createSheet(JRXlsAbstractExporter.SheetInfo sheetInfo) {
        this.startPage = true;
        this.currentSheetPageScale = sheetInfo.sheetPageScale;
        this.currentSheetFirstPageNumber = sheetInfo.sheetFirstPageNumber;
        this.currentSheetName = sheetInfo.sheetName;
        this.firstSheetName = this.firstSheetName == null ? this.currentSheetName : this.firstSheetName;
        this.wbHelper.exportSheet(this.sheetIndex + 1, this.currentSheetName, this.sheetMapping);
        this.ctHelper.exportSheet(this.sheetIndex + 1);
        this.relsHelper.exportSheet(this.sheetIndex + 1);
        XlsxMetadataReportConfiguration configuration = (XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration();
        ExportZipEntry sheetRelsEntry = this.xlsxZip.addSheetRels(this.sheetIndex + 1);
        Writer sheetRelsWriter = sheetRelsEntry.getWriter();
        this.sheetRelsHelper = new XlsxSheetRelsHelper(this.jasperReportsContext, sheetRelsWriter);
        ExportZipEntry sheetEntry = this.xlsxZip.addSheet(this.sheetIndex + 1);
        Writer sheetWriter = sheetEntry.getWriter();
        this.sheetHelper = new XlsxSheetHelper(this.jasperReportsContext, sheetWriter, this.sheetRelsHelper, configuration);
        ExportZipEntry drawingRelsEntry = this.xlsxZip.addDrawingRels(this.sheetIndex + 1);
        Writer drawingRelsWriter = drawingRelsEntry.getWriter();
        this.drawingRelsHelper = new XlsxDrawingRelsHelper(this.jasperReportsContext, drawingRelsWriter);
        ExportZipEntry drawingEntry = this.xlsxZip.addDrawing(this.sheetIndex + 1);
        Writer drawingWriter = drawingEntry.getWriter();
        this.drawingHelper = new XlsxDrawingHelper(this.jasperReportsContext, drawingWriter, this.drawingRelsHelper);
        this.cellHelper = new XlsxCellHelper(this.jasperReportsContext, sheetWriter, this.styleHelper);
        boolean showGridlines = true;
        if (sheetInfo.sheetShowGridlines == null) {
            Boolean documentShowGridlines = configuration.isShowGridLines();
            if (documentShowGridlines != null) {
                showGridlines = documentShowGridlines;
            }
        } else {
            showGridlines = sheetInfo.sheetShowGridlines;
        }
        this.sheetHelper.exportHeader(showGridlines, sheetInfo.sheetPageScale == null ? 0 : sheetInfo.sheetPageScale, sheetInfo.rowFreezeIndex, sheetInfo.columnFreezeIndex, this.maxColumnIndex, this.jasperPrint, sheetInfo.tabColor);
        this.sheetRelsHelper.exportHeader(this.sheetIndex + 1);
        this.drawingHelper.exportHeader();
        this.drawingRelsHelper.exportHeader();
    }

    @Override
    protected void closeSheet() {
        if (this.sheetHelper != null) {
            XlsxMetadataReportConfiguration configuration = (XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration();
            boolean isIgnorePageMargins = configuration.isIgnorePageMargins();
            String password = configuration.getPassword();
            if (this.currentSheetFirstPageNumber != null && this.currentSheetFirstPageNumber > 0) {
                this.sheetHelper.exportFooter(this.sheetIndex, this.oldPageFormat == null ? this.pageFormat : this.oldPageFormat, isIgnorePageMargins, this.sheetAutoFilter, this.currentSheetPageScale, this.currentSheetFirstPageNumber, false, this.pageIndex - this.sheetInfo.sheetFirstPageIndex, this.sheetInfo.printSettings, password);
                this.firstPageNotSet = false;
            } else {
                Integer documentFirstPageNumber = configuration.getFirstPageNumber();
                if (documentFirstPageNumber != null && documentFirstPageNumber > 0 && this.firstPageNotSet) {
                    this.sheetHelper.exportFooter(this.sheetIndex, this.oldPageFormat == null ? this.pageFormat : this.oldPageFormat, isIgnorePageMargins, this.sheetAutoFilter, this.currentSheetPageScale, documentFirstPageNumber, false, this.pageIndex - this.sheetInfo.sheetFirstPageIndex, this.sheetInfo.printSettings, password);
                    this.firstPageNotSet = false;
                } else {
                    this.sheetHelper.exportFooter(this.sheetIndex, this.oldPageFormat == null ? this.pageFormat : this.oldPageFormat, isIgnorePageMargins, this.sheetAutoFilter, this.currentSheetPageScale, null, this.firstPageNotSet, this.pageIndex - this.sheetInfo.sheetFirstPageIndex, this.sheetInfo.printSettings, password);
                }
            }
            if (this.sheetAutoFilter != null) {
                int index = Math.max(0, this.sheetIndex - 1);
                this.definedNames.append("<definedName name=\"_xlnm._FilterDatabase\" localSheetId=\"" + index + "\">'" + JRStringUtil.xmlEncode(this.currentSheetName) + "'!" + this.sheetAutoFilter + "</definedName>\n");
            }
            this.sheetHelper.close();
            this.sheetRelsHelper.exportFooter();
            this.sheetRelsHelper.close();
            this.drawingHelper.exportFooter();
            this.drawingHelper.close();
            this.drawingRelsHelper.exportFooter();
            this.drawingRelsHelper.close();
        }
    }

    public void exportImage(JRPrintImage image, int colIndex, JRStyle parentStyle) throws JRException {
        int topPadding = Math.max(image.getLineBox().getTopPadding(), this.getImageBorderCorrection(image.getLineBox().getTopPen()));
        int leftPadding = Math.max(image.getLineBox().getLeftPadding(), this.getImageBorderCorrection(image.getLineBox().getLeftPen()));
        int bottomPadding = Math.max(image.getLineBox().getBottomPadding(), this.getImageBorderCorrection(image.getLineBox().getBottomPen()));
        int rightPadding = Math.max(image.getLineBox().getRightPadding(), this.getImageBorderCorrection(image.getLineBox().getRightPen()));
        int availableImageWidth = image.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        this.cellHelper.exportHeader(image, this.rowIndex, colIndex, this.maxColumnIndex, null, null, null, true, false, false, false, false, RotationEnum.NONE, this.sheetInfo, null, parentStyle);
        Renderable renderer = image.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            InternalImageProcessorResult imageProcessorResult;
            block98: {
                InternalImageProcessor imageProcessor = new InternalImageProcessor(image, colIndex, availableImageWidth, availableImageHeight);
                imageProcessorResult = null;
                try {
                    imageProcessorResult = imageProcessor.process(renderer);
                }
                catch (Exception e) {
                    Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, image.getOnErrorTypeValue());
                    if (onErrorRenderer == null) break block98;
                    imageProcessorResult = imageProcessor.process(onErrorRenderer);
                }
            }
            if (imageProcessorResult != null) {
                String href;
                String altText;
                double cropTop = 0.0;
                double cropLeft = 0.0;
                double cropBottom = 0.0;
                double cropRight = 0.0;
                int angle = 0;
                block1 : switch (image.getScaleImageValue()) {
                    case FILL_FRAME: {
                        switch (image.getRotation()) {
                            case LEFT: {
                                angle = -90;
                                break block1;
                            }
                            case RIGHT: {
                                angle = 90;
                                break block1;
                            }
                            case UPSIDE_DOWN: {
                                angle = 180;
                                break block1;
                            }
                        }
                        angle = 0;
                        break;
                    }
                    case CLIP: {
                        double normalWidth = availableImageWidth;
                        double normalHeight = availableImageHeight;
                        Dimension2D dimension = imageProcessorResult.dimension;
                        if (dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                        switch (image.getRotation()) {
                            case LEFT: {
                                if (dimension == null) {
                                    normalWidth = availableImageHeight;
                                    normalHeight = availableImageWidth;
                                }
                                switch (image.getHorizontalImageAlign()) {
                                    case RIGHT: {
                                        cropLeft = ((double)availableImageHeight - normalWidth) / (double)availableImageHeight;
                                        cropRight = 0.0;
                                        break;
                                    }
                                    case CENTER: {
                                        cropRight = cropLeft = ((double)availableImageHeight - normalWidth) / (double)availableImageHeight / 2.0;
                                        break;
                                    }
                                    default: {
                                        cropLeft = 0.0;
                                        cropRight = ((double)availableImageHeight - normalWidth) / (double)availableImageHeight;
                                    }
                                }
                                switch (image.getVerticalImageAlign()) {
                                    case TOP: {
                                        cropTop = 0.0;
                                        cropBottom = ((double)availableImageWidth - normalHeight) / (double)availableImageWidth;
                                        break;
                                    }
                                    case MIDDLE: {
                                        cropBottom = cropTop = ((double)availableImageWidth - normalHeight) / (double)availableImageWidth / 2.0;
                                        break;
                                    }
                                    default: {
                                        cropTop = ((double)availableImageWidth - normalHeight) / (double)availableImageWidth;
                                        cropBottom = 0.0;
                                    }
                                }
                                angle = -90;
                                break block1;
                            }
                            case RIGHT: {
                                if (dimension == null) {
                                    normalWidth = availableImageHeight;
                                    normalHeight = availableImageWidth;
                                }
                                switch (image.getHorizontalImageAlign()) {
                                    case RIGHT: {
                                        cropLeft = ((double)availableImageHeight - normalWidth) / (double)availableImageHeight;
                                        cropRight = 0.0;
                                        break;
                                    }
                                    case CENTER: {
                                        cropRight = cropLeft = ((double)availableImageHeight - normalWidth) / (double)availableImageHeight / 2.0;
                                        break;
                                    }
                                    default: {
                                        cropLeft = 0.0;
                                        cropRight = ((double)availableImageHeight - normalWidth) / (double)availableImageHeight;
                                    }
                                }
                                switch (image.getVerticalImageAlign()) {
                                    case TOP: {
                                        cropTop = 0.0;
                                        cropBottom = ((double)availableImageWidth - normalHeight) / (double)availableImageWidth;
                                        break;
                                    }
                                    case MIDDLE: {
                                        cropBottom = cropTop = ((double)availableImageWidth - normalHeight) / (double)availableImageWidth / 2.0;
                                        break;
                                    }
                                    default: {
                                        cropTop = ((double)availableImageWidth - normalHeight) / (double)availableImageWidth;
                                        cropBottom = 0.0;
                                    }
                                }
                                angle = 90;
                                break block1;
                            }
                            case UPSIDE_DOWN: {
                                switch (image.getHorizontalImageAlign()) {
                                    case RIGHT: {
                                        cropLeft = ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                                        cropRight = 0.0;
                                        break;
                                    }
                                    case CENTER: {
                                        cropRight = cropLeft = ((double)availableImageWidth - normalWidth) / (double)availableImageWidth / 2.0;
                                        break;
                                    }
                                    default: {
                                        cropLeft = 0.0;
                                        cropRight = ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                                    }
                                }
                                switch (image.getVerticalImageAlign()) {
                                    case TOP: {
                                        cropTop = 0.0;
                                        cropBottom = ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                        break;
                                    }
                                    case MIDDLE: {
                                        cropBottom = cropTop = ((double)availableImageHeight - normalHeight) / (double)availableImageHeight / 2.0;
                                        break;
                                    }
                                    default: {
                                        cropTop = ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                        cropBottom = 0.0;
                                    }
                                }
                                angle = 180;
                                break block1;
                            }
                        }
                        switch (image.getHorizontalImageAlign()) {
                            case RIGHT: {
                                cropLeft = ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                                cropRight = 0.0;
                                break;
                            }
                            case CENTER: {
                                cropRight = cropLeft = ((double)availableImageWidth - normalWidth) / (double)availableImageWidth / 2.0;
                                break;
                            }
                            default: {
                                cropLeft = 0.0;
                                cropRight = ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                            }
                        }
                        switch (image.getVerticalImageAlign()) {
                            case TOP: {
                                cropTop = 0.0;
                                cropBottom = ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                break;
                            }
                            case MIDDLE: {
                                cropBottom = cropTop = ((double)availableImageHeight - normalHeight) / (double)availableImageHeight / 2.0;
                                break;
                            }
                            default: {
                                cropTop = ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                cropBottom = 0.0;
                            }
                        }
                        angle = 0;
                        break;
                    }
                    default: {
                        double normalWidth = availableImageWidth;
                        double normalHeight = availableImageHeight;
                        Dimension2D dimension = imageProcessorResult.dimension;
                        if (dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                        switch (image.getRotation()) {
                            case LEFT: {
                                double ratioY;
                                double ratioX;
                                if (dimension == null) {
                                    normalWidth = availableImageHeight;
                                    normalHeight = availableImageWidth;
                                }
                                ratioY = ratioX = (ratioX = (double)availableImageWidth / normalHeight) < (ratioY = (double)availableImageHeight / normalWidth) ? ratioX : ratioY;
                                double imageWidth = (int)(normalHeight * ratioX);
                                double imageHeight = (int)(normalWidth * ratioY);
                                switch (image.getHorizontalImageAlign()) {
                                    case RIGHT: {
                                        cropLeft = ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                        cropRight = 0.0;
                                        break;
                                    }
                                    case CENTER: {
                                        cropRight = cropLeft = ((double)availableImageHeight - imageHeight) / (double)availableImageHeight / 2.0;
                                        break;
                                    }
                                    default: {
                                        cropLeft = 0.0;
                                        cropRight = ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                    }
                                }
                                switch (image.getVerticalImageAlign()) {
                                    case TOP: {
                                        cropTop = 0.0;
                                        cropBottom = ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                        break;
                                    }
                                    case MIDDLE: {
                                        cropBottom = cropTop = ((double)availableImageWidth - imageWidth) / (double)availableImageWidth / 2.0;
                                        break;
                                    }
                                    default: {
                                        cropTop = ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                        cropBottom = 0.0;
                                    }
                                }
                                angle = -90;
                                break block1;
                            }
                            case RIGHT: {
                                double ratioY;
                                double ratioX;
                                if (dimension == null) {
                                    normalWidth = availableImageHeight;
                                    normalHeight = availableImageWidth;
                                }
                                ratioY = ratioX = (ratioX = (double)availableImageWidth / normalHeight) < (ratioY = (double)availableImageHeight / normalWidth) ? ratioX : ratioY;
                                double imageWidth = (int)(normalHeight * ratioX);
                                double imageHeight = (int)(normalWidth * ratioY);
                                switch (image.getHorizontalImageAlign()) {
                                    case RIGHT: {
                                        cropLeft = ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                        cropRight = 0.0;
                                        break;
                                    }
                                    case CENTER: {
                                        cropRight = cropLeft = ((double)availableImageHeight - imageHeight) / (double)availableImageHeight / 2.0;
                                        break;
                                    }
                                    default: {
                                        cropLeft = 0.0;
                                        cropRight = ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                    }
                                }
                                switch (image.getVerticalImageAlign()) {
                                    case TOP: {
                                        cropTop = 0.0;
                                        cropBottom = ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                        break;
                                    }
                                    case MIDDLE: {
                                        cropBottom = cropTop = ((double)availableImageWidth - imageWidth) / (double)availableImageWidth / 2.0;
                                        break;
                                    }
                                    default: {
                                        cropTop = ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                        cropBottom = 0.0;
                                    }
                                }
                                angle = 90;
                                break block1;
                            }
                            case UPSIDE_DOWN: {
                                double ratioX = (double)availableImageWidth / normalWidth;
                                double ratioY = (double)availableImageHeight / normalHeight;
                                ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                                double imageWidth = (int)(normalWidth * ratioX);
                                double imageHeight = (int)(normalHeight * ratioY);
                                switch (image.getHorizontalImageAlign()) {
                                    case RIGHT: {
                                        cropLeft = ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                        cropRight = 0.0;
                                        break;
                                    }
                                    case CENTER: {
                                        cropRight = cropLeft = ((double)availableImageWidth - imageWidth) / (double)availableImageWidth / 2.0;
                                        break;
                                    }
                                    default: {
                                        cropLeft = 0.0;
                                        cropRight = ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                    }
                                }
                                switch (image.getVerticalImageAlign()) {
                                    case TOP: {
                                        cropTop = 0.0;
                                        cropBottom = ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                        break;
                                    }
                                    case MIDDLE: {
                                        cropBottom = cropTop = ((double)availableImageHeight - imageHeight) / (double)availableImageHeight / 2.0;
                                        break;
                                    }
                                    default: {
                                        cropTop = ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                        cropBottom = 0.0;
                                    }
                                }
                                angle = 180;
                                break block1;
                            }
                        }
                        double ratioX = (double)availableImageWidth / normalWidth;
                        double ratioY = (double)availableImageHeight / normalHeight;
                        ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                        double imageWidth = (int)(normalWidth * ratioX);
                        double imageHeight = (int)(normalHeight * ratioY);
                        switch (image.getHorizontalImageAlign()) {
                            case RIGHT: {
                                cropLeft = ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropRight = 0.0;
                                break;
                            }
                            case CENTER: {
                                cropRight = cropLeft = ((double)availableImageWidth - imageWidth) / (double)availableImageWidth / 2.0;
                                break;
                            }
                            default: {
                                cropLeft = 0.0;
                                cropRight = ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                            }
                        }
                        switch (image.getVerticalImageAlign()) {
                            case TOP: {
                                cropTop = 0.0;
                                cropBottom = ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                break;
                            }
                            case MIDDLE: {
                                cropBottom = cropTop = ((double)availableImageHeight - imageHeight) / (double)availableImageHeight / 2.0;
                                break;
                            }
                            default: {
                                cropTop = ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropBottom = 0.0;
                            }
                        }
                        angle = 0;
                    }
                }
                XlsxMetadataReportConfiguration configuration = (XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration();
                if (!Boolean.TRUE.equals(configuration.isIgnoreAnchors())) {
                    this.insertPageAnchor();
                    if (image.getAnchorName() != null) {
                        String ref = "'" + JRStringUtil.xmlEncode(this.currentSheetName) + "'!$" + ExcelAbstractExporter.getColumIndexName(colIndex, this.maxColumnIndex) + "$" + (this.rowIndex + 1);
                        this.definedNames.append("<definedName name=\"" + this.getDefinedName(image.getAnchorName()) + "\">" + ref + "</definedName>\n");
                    }
                }
                this.drawingRelsHelper.exportImage(imageProcessorResult.imagePath);
                ImageAnchorTypeEnum imageAnchorType = ImageAnchorTypeEnum.getByName(JRPropertiesUtil.getOwnProperty(image, "net.sf.jasperreports.export.xls.image.anchor.type"));
                if (imageAnchorType == null && (imageAnchorType = configuration.getImageAnchorType()) == null) {
                    imageAnchorType = ImageAnchorTypeEnum.MOVE_NO_SIZE;
                }
                this.drawingHelper.write("<xdr:twoCellAnchor editAs=\"" + this.getAnchorType(imageAnchorType) + "\">\n");
                this.drawingHelper.write("<xdr:from><xdr:col>" + colIndex + "</xdr:col><xdr:colOff>" + LengthUtil.emu(leftPadding) + "</xdr:colOff><xdr:row>" + this.rowIndex + "</xdr:row><xdr:rowOff>" + LengthUtil.emu(topPadding) + "</xdr:rowOff></xdr:from>\n");
                this.drawingHelper.write("<xdr:to><xdr:col>" + (colIndex + 1) + "</xdr:col><xdr:colOff>" + LengthUtil.emu(-rightPadding) + "</xdr:colOff><xdr:row>" + (this.rowIndex + 1) + "</xdr:row><xdr:rowOff>" + LengthUtil.emu(-bottomPadding) + "</xdr:rowOff></xdr:to>\n");
                this.drawingHelper.write("<xdr:pic>\n");
                String string = altText = image.getHyperlinkTooltip() == null ? "" : image.getHyperlinkTooltip();
                if (!altText.isEmpty()) {
                    altText = " descr=\"" + altText + "\"";
                }
                int hashCode = image.hashCode();
                this.drawingHelper.write("<xdr:nvPicPr><xdr:cNvPr id=\"" + (hashCode > 0 ? hashCode : -hashCode) + "\" name=\"Picture\"" + altText + ">\n");
                String string2 = href = HyperlinkTypeEnum.LOCAL_ANCHOR.equals(image.getHyperlinkTypeValue()) || HyperlinkTypeEnum.LOCAL_PAGE.equals(image.getHyperlinkTypeValue()) ? "#" + this.getHyperlinkURL(image) : this.getHyperlinkURL(image);
                if (href != null) {
                    this.drawingHelper.exportHyperlink(href);
                }
                this.drawingHelper.write("</xdr:cNvPr><xdr:cNvPicPr/></xdr:nvPicPr>\n");
                this.drawingHelper.write("<xdr:blipFill>\n");
                this.drawingHelper.write("<a:blip r:embed=\"" + imageProcessorResult.imagePath + "\"/>");
                this.drawingHelper.write("<a:srcRect/>");
                this.drawingHelper.write("<a:stretch><a:fillRect");
                this.drawingHelper.write(" l=\"" + (int)(100000.0 * cropLeft) + "\"");
                this.drawingHelper.write(" t=\"" + (int)(100000.0 * cropTop) + "\"");
                this.drawingHelper.write(" r=\"" + (int)(100000.0 * cropRight) + "\"");
                this.drawingHelper.write(" b=\"" + (int)(100000.0 * cropBottom) + "\"");
                this.drawingHelper.write("/></a:stretch>\n");
                this.drawingHelper.write("</xdr:blipFill>\n");
                this.drawingHelper.write("<xdr:spPr>\n");
                this.drawingHelper.write("  <a:xfrm rot=\"" + 60000 * angle + "\">\n");
                this.drawingHelper.write("    <a:off x=\"0\" y=\"0\"/>\n");
                this.drawingHelper.write("    <a:ext cx=\"" + LengthUtil.emu(0.0f) + "\" cy=\"" + LengthUtil.emu(0.0f) + "\"/>");
                this.drawingHelper.write("  </a:xfrm>\n");
                this.drawingHelper.write("<a:prstGeom prst=\"rect\"></a:prstGeom>\n");
                this.drawingHelper.write("</xdr:spPr>\n");
                this.drawingHelper.write("</xdr:pic>\n");
                this.drawingHelper.write("<xdr:clientData/>\n");
                this.drawingHelper.write("</xdr:twoCellAnchor>\n");
            }
        }
        this.cellHelper.exportFooter();
    }

    protected void exportLine(JRPrintLine line, int colIndex, JRStyle parentStyle) {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = null;
        LineDirectionEnum direction = null;
        float ratio = (float)line.getWidth() / (float)line.getHeight();
        if (ratio > 1.0f) {
            if (line.getHeight() > 1) {
                direction = line.getDirectionValue();
                pen = box.getPen();
            } else {
                pen = line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getTopPen() : box.getBottomPen();
            }
        } else if (line.getWidth() > 1) {
            direction = line.getDirectionValue();
            pen = box.getPen();
        } else {
            pen = line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getLeftPen() : box.getRightPen();
        }
        pen.setLineColor(line.getLinePen().getLineColor());
        pen.setLineStyle(line.getLinePen().getLineStyleValue());
        pen.setLineWidth(line.getLinePen().getLineWidth());
        this.cellHelper.exportHeader(box, this.rowIndex, colIndex, this.maxColumnIndex, null, null, null, true, false, false, false, false, RotationEnum.NONE, this.sheetInfo, direction, parentStyle);
        this.cellHelper.exportFooter();
    }

    protected void exportRectangle(JRPrintGraphicElement rectangle, int colIndex, JRStyle parentStyle) {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = box.getPen();
        pen.setLineColor(rectangle.getLinePen().getLineColor());
        pen.setLineStyle(rectangle.getLinePen().getLineStyleValue());
        pen.setLineWidth(rectangle.getLinePen().getLineWidth());
        this.cellHelper.exportHeader(box, this.rowIndex, colIndex, this.maxColumnIndex, null, null, null, true, false, false, false, false, RotationEnum.NONE, this.sheetInfo, null, parentStyle);
        this.cellHelper.exportFooter();
    }

    public void exportText(JRPrintText text, int colIndex, JRStyle parentStyle, String currentData) throws JRException {
        this.exportText(text, colIndex, this.rowIndex, parentStyle, currentData);
    }

    public void exportText(JRPrintText text, int colIndex, int rowIndex, JRStyle parentStyle, String currentData) throws JRException {
        String href;
        String textFormula;
        JRStyledText styledText = this.getStyledText(text);
        boolean useCurrentData = currentData != null;
        String textStr = useCurrentData ? currentData : styledText.getText();
        TextValue textValue = null;
        String pattern = null;
        XlsxMetadataReportConfiguration configuration = (XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration();
        Boolean isDetectCellType = Boolean.TRUE.equals(configuration.isDetectCellType());
        if (isDetectCellType.booleanValue()) {
            textValue = this.getTextValue(text, textStr, useCurrentData);
            if (textValue instanceof NumberTextValue) {
                pattern = ((NumberTextValue)textValue).getPattern();
            } else if (textValue instanceof DateTextValue) {
                pattern = ((DateTextValue)textValue).getPattern();
            }
        }
        String convertedPattern = isDetectCellType != false ? this.getConvertedPattern(text, pattern) : null;
        this.cellHelper.exportHeader(text, rowIndex, colIndex, this.maxColumnIndex, textValue, convertedPattern, this.getTextLocale(text), this.isWrapText(text) || Boolean.TRUE.equals(((JRXlsxExporterNature)this.nature).getColumnAutoFit(text)), this.isCellHidden(text), this.isCellLocked(text), this.isShrinkToFit(text), this.isIgnoreTextFormatting(text), text.getRotationValue(), this.sheetInfo, null, parentStyle);
        String string = textFormula = useCurrentData ? null : this.getFormula(text);
        if (textFormula != null) {
            this.sheetHelper.write("<f>" + textFormula + "</f>\n");
        }
        if (!Boolean.TRUE.equals(configuration.isIgnoreAnchors())) {
            this.insertPageAnchor();
            if (text.getAnchorName() != null) {
                String ref = "'" + JRStringUtil.xmlEncode(this.currentSheetName) + "'!$" + ExcelAbstractExporter.getColumIndexName(colIndex, this.maxColumnIndex) + "$" + (rowIndex + 1);
                this.definedNames.append("<definedName name=\"" + this.getDefinedName(text.getAnchorName()) + "\">" + ref + "</definedName>\n");
            }
        }
        if ((href = this.getHyperlinkURL(text)) != null) {
            this.sheetHelper.exportHyperlink(rowIndex, colIndex, this.maxColumnIndex, href, HyperlinkTypeEnum.LOCAL_ANCHOR.equals(text.getHyperlinkTypeValue()) || HyperlinkTypeEnum.LOCAL_PAGE.equals(text.getHyperlinkTypeValue()));
        }
        TextValueHandler handler = this.getTextValueHandler(text, convertedPattern, currentData);
        if (textValue != null) {
            textValue.handle(handler);
        } else {
            handler.handle((StringTextValue)null);
        }
        this.cellHelper.exportFooter();
    }

    protected TextValueHandler getTextValueHandler(final JRPrintText text, final String convertedPattern, final String currentData) {
        final JRStyledText styledText = this.getStyledText(text);
        final String textStr = currentData == null ? styledText.getText() : currentData;
        return new TextValueHandler(){

            @Override
            public void handle(BooleanTextValue textValue) throws JRException {
                if (textValue.getValue() != null) {
                    XlsxMetadataExporter.this.sheetHelper.write("<v>" + textValue.getValue() + "</v>");
                }
            }

            @Override
            public void handle(DateTextValue textValue) throws JRException {
                Date date = textValue.getValue();
                if (date != null) {
                    XlsxMetadataExporter.this.sheetHelper.write("<v>" + JRDataUtils.getExcelSerialDayNumber(date, XlsxMetadataExporter.this.getTextLocale(text), XlsxMetadataExporter.this.getTextTimeZone(text)) + "</v>");
                }
            }

            @Override
            public void handle(NumberTextValue textValue) throws JRException {
                if (textValue.getValue() != null) {
                    XlsxMetadataExporter.this.sheetHelper.write("<v>");
                    double doubleValue = textValue.getValue().doubleValue();
                    if ("[h]:mm:ss".equals(convertedPattern)) {
                        doubleValue /= 86400.0;
                    }
                    XlsxMetadataExporter.this.sheetHelper.write(String.valueOf(doubleValue));
                    XlsxMetadataExporter.this.sheetHelper.write("</v>");
                }
            }

            @Override
            public void handle(StringTextValue textValue) throws JRException {
                if (textStr != null && textStr.length() > 0) {
                    XlsxMetadataExporter.this.sheetHelper.write("<v>");
                    String markup = text.getMarkup();
                    boolean isStyledText = markup != null && !"none".equals(markup) && !XlsxMetadataExporter.this.isIgnoreTextFormatting(text);
                    XlsxMetadataExporter.this.exportStyledText(text.getStyle(), styledText, XlsxMetadataExporter.this.getTextLocale(text), isStyledText, currentData);
                    XlsxMetadataExporter.this.sheetHelper.write("</v>");
                }
            }
        };
    }

    protected TextValue getTextValue(JRPrintText text, String textStr, boolean useCurrentData) {
        boolean isDetectCellType = Boolean.TRUE.equals(((XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration()).isDetectCellType());
        if (!useCurrentData) {
            if (isDetectCellType) {
                return super.getTextValue(text, textStr);
            }
            return super.getTextValueString(text, textStr);
        }
        if (this.currentDataElement == null) {
            this.currentDataElement = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
        }
        this.currentDataElement.setValueClassName(isDetectCellType ? text.getValueClassName() : null);
        this.currentDataElement.setPattern(text.getPattern());
        this.currentDataElement.setLocaleCode(text.getLocaleCode());
        this.currentDataElement.setTimeZoneId(text.getTimeZoneId());
        return super.getTextValue(this.currentDataElement, textStr);
    }

    protected void exportElement(JRPrintElement element, JRStyle parentStyle) throws JRException {
        String currentColumnName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
        if (currentColumnName != null && currentColumnName.length() > 0) {
            String currentData = element instanceof JRPrintText && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.data") ? element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.data") : null;
            Boolean ignoreRowHeight = ((JRXlsxExporterNature)this.nature).getIgnoreRowHeight(element);
            this.adjustRowHeight(Boolean.TRUE.equals(ignoreRowHeight) ? 0 : element.getHeight(), ((JRXlsxExporterNature)this.nature).getRowAutoFit(element));
            this.setColumnName(currentColumnName);
            this.addElement(element, this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.repeat.value", false), currentColumnName, parentStyle, currentData);
        }
    }

    protected void adjustRowHeight(int rowHeight, Boolean isAutofit) {
        if (isAutofit != null || !Boolean.TRUE.equals(this.currentRow.get("CURRENT_ROW_AUTOFIT"))) {
            this.currentRow.put("CURRENT_ROW_AUTOFIT", isAutofit);
        }
        if (!this.currentRow.containsKey("CURRENT_ROW_HEIGHT") || (Integer)this.currentRow.get("CURRENT_ROW_HEIGHT") < rowHeight) {
            this.currentRow.put("CURRENT_ROW_HEIGHT", rowHeight);
        }
    }

    protected void addElement(JRPrintElement element, boolean repeatValue, String currentColumnName, JRStyle parentStyle, String currentData) throws JRException {
        if (!this.columnNames.isEmpty()) {
            if (this.columnNames.contains(currentColumnName) && !this.currentRow.containsKey(currentColumnName) && this.isColumnReadOnTime(this.currentRow, currentColumnName)) {
                this.addElement(this.currentRow, element, currentColumnName, parentStyle, currentData);
            } else if (this.columnNames.contains(currentColumnName) && !this.currentRow.containsKey(currentColumnName) && !this.isColumnReadOnTime(this.currentRow, currentColumnName) || this.columnNames.contains(currentColumnName) && this.currentRow.containsKey(currentColumnName)) {
                this.writeCurrentRow(this.currentRow, this.repeatedValues);
                this.addElement(this.currentRow, element, currentColumnName, parentStyle, currentData);
            }
            if (repeatValue) {
                if (currentColumnName != null && !currentColumnName.isEmpty()) {
                    this.addElement(this.repeatedValues, element, currentColumnName, parentStyle, currentData);
                }
            } else {
                this.repeatedValues.remove(currentColumnName);
                this.repeatedValues.remove(currentColumnName + PARENT_STYLE);
                this.repeatedValues.remove(currentColumnName + CURRENT_DATA);
            }
        }
    }

    protected void addElement(Map<String, Object> currentMap, JRPrintElement element, String currentColumnName, JRStyle parentStyle, String currentData) {
        currentMap.put(currentColumnName, element);
        if (currentData != null) {
            currentMap.put(currentColumnName + CURRENT_DATA, currentData);
        }
        XlsxMetadataReportConfiguration configuration = (XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration();
        if (!(parentStyle == null || Boolean.TRUE.equals(configuration.isIgnoreTextFormatting()) && (Boolean.TRUE.equals(configuration.isIgnoreCellBorder()) || Boolean.TRUE.equals(configuration.isIgnoreGraphics())))) {
            currentMap.put(currentColumnName + PARENT_STYLE, parentStyle);
        }
    }

    protected boolean isColumnReadOnTime(Map<String, Object> currentRow, String currentColumnName) {
        int indexOfLastFilledColumn = -1;
        Set<String> currentlyFilledColumns = currentRow.keySet();
        for (String column : currentlyFilledColumns) {
            indexOfLastFilledColumn = Math.max(indexOfLastFilledColumn, this.columnNames.indexOf(column));
        }
        return indexOfLastFilledColumn < this.columnNames.indexOf(currentColumnName);
    }

    protected void writeCurrentRow(Map<String, Object> currentRow, Map<String, Object> repeatedValues) throws JRException {
        int columnsCount = this.columnNames == null ? 0 : this.columnNames.size();
        this.exportHeaderRow(columnsCount, currentRow, repeatedValues);
        int rowHeight = currentRow.get("CURRENT_ROW_HEIGHT") == null ? 0 : (Integer)currentRow.get("CURRENT_ROW_HEIGHT");
        boolean isAutofit = currentRow.get("CURRENT_ROW_AUTOFIT") == null ? Boolean.FALSE : (Boolean)currentRow.get("CURRENT_ROW_AUTOFIT");
        this.sheetHelper.exportRow(rowHeight, isAutofit, null);
        for (int i = 0; i < this.columnNames.size(); ++i) {
            JRStyle parentStyle;
            JRPrintElement element;
            String columnName = this.columnNames.get(i);
            JRPrintElement jRPrintElement = element = currentRow.containsKey(columnName) ? (JRPrintElement)currentRow.get(columnName) : (JRPrintElement)repeatedValues.get(columnName);
            if (element == null) continue;
            String autofilter = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.auto.filter");
            if ("Start".equals(autofilter)) {
                this.autoFilterStart = "$" + JRStringUtil.getLetterNumeral(i + 1, true) + "$" + (this.rowIndex + 1);
            } else if ("End".equals(autofilter)) {
                this.autoFilterEnd = "$" + JRStringUtil.getLetterNumeral(i + 1, true) + "$" + (this.rowIndex + 1);
            }
            this.configureDefinedNames(this.getNature(), element);
            JRStyle jRStyle = parentStyle = (JRStyle)currentRow.get(columnName + PARENT_STYLE) == null ? (JRStyle)repeatedValues.get(columnName + PARENT_STYLE) : (JRStyle)currentRow.get(columnName + PARENT_STYLE);
            if (element instanceof JRPrintLine) {
                this.exportLine((JRPrintLine)element, i, parentStyle);
                continue;
            }
            if (element instanceof JRPrintRectangle) {
                this.exportRectangle((JRPrintRectangle)element, i, parentStyle);
                continue;
            }
            if (element instanceof JRPrintEllipse) {
                this.exportRectangle((JRPrintEllipse)element, i, parentStyle);
                continue;
            }
            if (element instanceof JRPrintImage) {
                this.exportImage((JRPrintImage)element, i, parentStyle);
                continue;
            }
            if (element instanceof JRPrintText) {
                String currentData = (String)currentRow.get(columnName + CURRENT_DATA) == null ? (String)repeatedValues.get(columnName + CURRENT_DATA) : (String)currentRow.get(columnName + CURRENT_DATA);
                this.exportText((JRPrintText)element, i, parentStyle, currentData);
                continue;
            }
            if (element instanceof JRPrintFrame) {
                this.exportFrame((JRPrintFrame)element, i, parentStyle);
                continue;
            }
            if (!(element instanceof JRGenericPrintElement)) continue;
            this.exportGenericElement((JRGenericPrintElement)element, i, parentStyle);
        }
        ++this.rowIndex;
        currentRow.clear();
    }

    private void exportHeaderRow(int columnsCount, Map<String, Object> currentRow, Map<String, Object> repeatedValues) throws JRException {
        JRPrintElement element;
        String columnName;
        int i;
        for (i = 0; i < columnsCount; ++i) {
            columnName = this.columnNames.get(i);
            JRPrintElement jRPrintElement = element = currentRow.get(columnName) == null ? (JRPrintElement)repeatedValues.get(columnName) : (JRPrintElement)currentRow.get(columnName);
            if (element == null) continue;
            if (this.rowIndex == 0) {
                String width = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.width.metadata");
                width = width == null || width.isEmpty() ? element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.width") : width;
                Integer columnWidth = width == null || width.isEmpty() ? element.getWidth() : Integer.valueOf(width).intValue();
                this.setColumnWidth(i, columnWidth, false);
            }
            if (this.columnHeadersRow.containsKey(columnName)) continue;
            JRBasePrintText headerElement = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
            headerElement.setText(columnName);
            headerElement.setMode(ModeEnum.TRANSPARENT);
            headerElement.setWidth(element.getWidth());
            headerElement.setHeight(element.getHeight());
            headerElement.setX(element.getX());
            headerElement.setY(0);
            this.columnHeadersRow.put(columnName, headerElement);
        }
        if (this.rowIndex == 0 && ((XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration()).isWriteHeader().booleanValue()) {
            this.sheetHelper.exportRow((int)((Integer)currentRow.get("CURRENT_ROW_HEIGHT")), false, null);
            for (i = 0; i < columnsCount; ++i) {
                columnName = this.columnNames.get(i);
                element = this.columnHeadersRow.get(columnName) == null ? new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider()) : (JRPrintText)this.columnHeadersRow.get(columnName);
                this.exportText((JRPrintText)element, i, 0, null, null);
                this.rowSpanStartIndexesMap.put(columnName, this.rowSpanStartIndexesMap.get(columnName) + 1);
            }
            ++this.rowIndex;
        }
    }

    protected void exportGenericElement(JRGenericPrintElement element, int colIndex, JRStyle parentStyle) throws JRException {
        GenericElementXlsxMetadataHandler handler = (GenericElementXlsxMetadataHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), XLSX_METADATA_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement((JRXlsxExporterContext)this.exporterContext, element, colIndex, this.rowIndex, parentStyle);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No XLSX generic element handler for " + element.getGenericType()));
        }
    }

    protected void exportFrame(JRPrintFrame frame, int colIndex, JRStyle parentStyle) {
        this.cellHelper.exportHeader(frame, this.rowIndex, colIndex, this.maxColumnIndex, null, null, null, true, false, false, false, false, RotationEnum.NONE, this.sheetInfo, null, parentStyle);
        this.cellHelper.exportFooter();
    }

    @Override
    protected void openWorkbook(OutputStream os) throws JRException {
        this.rendererToImagePathMap = new HashMap<String, String>();
        this.definedNames = new StringBuilder();
        this.sheetMapping = new HashMap<String, Integer>();
        try {
            String keywords;
            String author;
            String subject;
            String macro;
            String memoryThreshold = this.jasperPrint.getPropertiesMap().getProperty("net.sf.jasperreports.file.buffer.os.memory.threshold");
            this.xlsxZip = new XlsxZip(this.jasperReportsContext, this.getRepository(), memoryThreshold == null ? null : Integer.valueOf(JRPropertiesUtil.asInteger(memoryThreshold)));
            this.wbHelper = new XlsxWorkbookHelper(this.jasperReportsContext, this.xlsxZip.getWorkbookEntry().getWriter(), this.definedNames);
            this.wbHelper.exportHeader();
            this.relsHelper = new XlsxRelsHelper(this.jasperReportsContext, this.xlsxZip.getRelsEntry().getWriter());
            this.ctHelper = new XlsxContentTypesHelper(this.jasperReportsContext, this.xlsxZip.getContentTypesEntry().getWriter());
            this.appHelper = new PropsAppHelper(this.jasperReportsContext, this.xlsxZip.getAppEntry().getWriter());
            this.coreHelper = new PropsCoreHelper(this.jasperReportsContext, this.xlsxZip.getCoreEntry().getWriter());
            XlsxMetadataExporterConfiguration configuration = (XlsxMetadataExporterConfiguration)this.getCurrentConfiguration();
            String string = macro = this.macroTemplate == null ? configuration.getMacroTemplate() : this.macroTemplate;
            if (macro != null) {
                this.xlsxZip.addMacro(macro);
                this.relsHelper.setContainsMacro(true);
                this.ctHelper.setContainsMacro(true);
            }
            this.relsHelper.exportHeader();
            this.ctHelper.exportHeader();
            this.appHelper.exportHeader();
            String application = configuration.getMetadataApplication();
            if (application == null) {
                String depApplication;
                application = depApplication = "JasperReports Library version " + Package.getPackage("net.sf.jasperreports.engine").getImplementationVersion();
            }
            this.appHelper.exportProperty("Application", application);
            this.coreHelper.exportHeader();
            String title = configuration.getMetadataTitle();
            if (title != null) {
                this.coreHelper.exportProperty("dc:title", title);
            }
            if ((subject = configuration.getMetadataSubject()) != null) {
                this.coreHelper.exportProperty("dc:subject", subject);
            }
            if ((author = configuration.getMetadataAuthor()) != null) {
                this.coreHelper.exportProperty("dc:creator", author);
            }
            if ((keywords = configuration.getMetadataKeywords()) != null) {
                this.coreHelper.exportProperty("cp:keywords", keywords);
            }
            this.styleHelper = new XlsxStyleHelper(this.jasperReportsContext, this.xlsxZip.getStylesEntry().getWriter(), this.getExporterKey());
            this.sharedStringsHelper = new XlsxSharedStringsHelper(this.jasperReportsContext, this.xlsxZip.getSharedStringsEntry().getWriter(), this.getExporterKey());
            this.sharedStringsHelper.exportHeader();
            this.firstPageNotSet = true;
            this.firstSheetName = null;
        }
        catch (IOException e) {
            throw new JRException(e);
        }
    }

    protected void setBackground() {
    }

    @Override
    protected void setColumnWidth(int col, int width, boolean autoFit) {
        this.sheetHelper.exportColumn(col, width, autoFit);
    }

    @Override
    protected void addRowBreak(int rowIndex) {
        this.sheetHelper.addRowBreak(rowIndex);
    }

    @Override
    public String getExporterKey() {
        return XLSX_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return XLSX_EXPORTER_PROPERTIES_PREFIX;
    }

    @Override
    protected void setFreezePane(int rowIndex, int colIndex) {
    }

    @Override
    protected void setSheetName(String sheetName) {
    }

    @Override
    protected void setAutoFilter(String autoFilterRange) {
        this.sheetAutoFilter = autoFilterRange;
    }

    @Override
    protected void resetAutoFilters() {
        super.resetAutoFilters();
        this.sheetAutoFilter = null;
    }

    @Override
    protected void setRowLevels(XlsRowLevelInfo levelInfo, String level) {
    }

    protected void setScale(Integer scale) {
    }

    protected String getAnchorType(ImageAnchorTypeEnum anchorType) {
        switch (anchorType) {
            case MOVE_SIZE: {
                return TWO_CELL;
            }
            case NO_MOVE_NO_SIZE: {
                return ABSOLUTE;
            }
        }
        return ONE_CELL;
    }

    protected String getDefinedName(String name) {
        if (name != null) {
            return name.replaceAll("\\W", "");
        }
        return null;
    }

    protected void setColumnNames() {
        String[] columnNamesArray = ((XlsxMetadataReportConfiguration)this.getCurrentItemConfiguration()).getColumnNames();
        this.hasDefinedColumns = columnNamesArray != null && columnNamesArray.length > 0;
        this.columnNames = new ArrayList<String>();
        this.columnNamesMap = new HashMap<String, Integer>();
        this.rowSpanStartIndexesMap = new HashMap<String, Integer>();
        List<String> columnNamesList = JRStringUtil.split(columnNamesArray, ",");
        if (columnNamesList != null) {
            for (String columnName : columnNamesList) {
                if (this.columnNamesMap.containsKey(columnName)) continue;
                this.columnNames.add(columnName);
                this.columnNamesMap.put(columnName, this.columnNames.size());
                this.rowSpanStartIndexesMap.put(columnName, 0);
            }
        }
    }

    private JRXlsAbstractExporter.SheetInfo getSheetInfo(XlsxMetadataReportConfiguration configuration, String name) {
        JRXlsAbstractExporter.SheetInfo sheetInfo = new JRXlsAbstractExporter.SheetInfo();
        sheetInfo.sheetName = this.getSheetName(name);
        sheetInfo.sheetFirstPageIndex = this.pageIndex;
        sheetInfo.printSettings = new JRXlsAbstractExporter.SheetInfo.SheetPrintSettings(new JRXlsAbstractExporter.SheetInfo());
        if (configuration == null) {
            sheetInfo.printSettings.setPageHeight(0);
            sheetInfo.printSettings.setPageWidth(0);
            sheetInfo.printSettings.setLeftMargin(0);
            sheetInfo.printSettings.setRightMargin(0);
            sheetInfo.printSettings.setTopMargin(0);
            sheetInfo.printSettings.setBottomMargin(0);
            sheetInfo.printSettings.setHeaderMargin(0);
            sheetInfo.printSettings.setFooterMargin(0);
            sheetInfo.rowFreezeIndex = -1;
            sheetInfo.columnFreezeIndex = -1;
        } else {
            sheetInfo.rowFreezeIndex = configuration.getFreezeRow() == null ? -1 : configuration.getFreezeRow();
            sheetInfo.columnFreezeIndex = configuration.getFreezeColumn() == null ? -1 : this.getColumnIndex(configuration.getFreezeColumn());
            sheetInfo.ignoreCellBackground = configuration.isIgnoreCellBackground();
            sheetInfo.ignoreCellBorder = configuration.isIgnoreCellBorder();
            sheetInfo.whitePageBackground = configuration.isWhitePageBackground();
            sheetInfo.sheetFirstPageNumber = configuration.getFirstPageNumber();
            sheetInfo.sheetPageScale = configuration.getPageScale();
            sheetInfo.sheetShowGridlines = configuration.isShowGridLines();
            sheetInfo.tabColor = configuration.getSheetTabColor();
            sheetInfo.columnWidthRatio = configuration.getColumnWidthRatio();
            this.updatePrintSettings(sheetInfo.printSettings, configuration);
        }
        return sheetInfo;
    }

    protected void setColumnName(String currentColumnName) {
        if (!this.hasDefinedColumns && currentColumnName != null && currentColumnName.length() > 0 && !this.columnNames.contains(currentColumnName)) {
            this.columnNamesMap.put(currentColumnName, this.columnNames.size());
            this.rowSpanStartIndexesMap.put(currentColumnName, 0);
            this.columnNames.add(currentColumnName);
        }
    }

    private class InternalImageProcessorResult {
        protected final String imagePath;
        protected final Dimension2D dimension;

        protected InternalImageProcessorResult(String imagePath, Dimension2D dimension) {
            this.imagePath = imagePath;
            this.dimension = dimension;
        }
    }

    private class InternalImageProcessor {
        private final JRPrintElement imageElement;
        private final RenderersCache imageRenderersCache;
        private final boolean needDimension;
        private final int colIndex;
        private final int availableImageWidth;
        private final int availableImageHeight;

        protected InternalImageProcessor(JRPrintImage imageElement, int colIndex, int availableImageWidth, int availableImageHeight) {
            this.imageElement = imageElement;
            this.colIndex = colIndex;
            this.imageRenderersCache = imageElement.isUsingCache() ? XlsxMetadataExporter.this.renderersCache : new RenderersCache(XlsxMetadataExporter.this.getJasperReportsContext());
            boolean bl = this.needDimension = imageElement.getScaleImageValue() != ScaleImageEnum.FILL_FRAME;
            if (imageElement.getRotation() == RotationEnum.LEFT || imageElement.getRotation() == RotationEnum.RIGHT) {
                this.availableImageWidth = availableImageHeight;
                this.availableImageHeight = availableImageWidth;
            } else {
                this.availableImageWidth = availableImageWidth;
                this.availableImageHeight = availableImageHeight;
            }
        }

        private InternalImageProcessorResult process(Renderable renderer) throws JRException {
            if (renderer instanceof ResourceRenderer) {
                renderer = this.imageRenderersCache.getLoadedRenderer((ResourceRenderer)renderer);
            }
            Dimension2D dimension = null;
            if (this.needDimension) {
                DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable(renderer);
                dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(XlsxMetadataExporter.this.jasperReportsContext);
            }
            String imagePath = null;
            if (renderer instanceof DataRenderable && XlsxMetadataExporter.this.rendererToImagePathMap.containsKey(renderer.getId())) {
                imagePath = XlsxMetadataExporter.this.rendererToImagePathMap.get(renderer.getId());
            } else {
                JRPrintElementIndex imageIndex = XlsxMetadataExporter.this.getElementIndex(this.colIndex);
                DataRenderable imageRenderer = XlsxMetadataExporter.this.getRendererUtil().getImageDataRenderable(this.imageRenderersCache, renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null);
                byte[] imageData = imageRenderer.getData(XlsxMetadataExporter.this.jasperReportsContext);
                String fileExtension = JRTypeSniffer.getImageTypeValue(imageData).getFileExtension();
                String imageName = XlsxMetadataExporter.IMAGE_NAME_PREFIX + imageIndex.toString() + (fileExtension == null ? "" : "." + fileExtension);
                XlsxMetadataExporter.this.xlsxZip.addEntry(new FileBufferedZipEntry("xl/media/" + imageName, imageData));
                imagePath = imageName;
                if (imageRenderer == renderer) {
                    XlsxMetadataExporter.this.rendererToImagePathMap.put(renderer.getId(), imagePath);
                }
            }
            return new InternalImageProcessorResult(imagePath, dimension);
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRXlsxExporterContext {
        protected ExporterContext() {
            super(XlsxMetadataExporter.this);
        }
    }
}

