/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.AbstractXmlDataSource;
import net.sf.jasperreports.engine.data.NoRecordAtIndexException;
import net.sf.jasperreports.engine.util.xml.JRXmlDocumentProducer;
import net.sf.jasperreports.engine.util.xml.JaxenNsAwareXPathExecuter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxenXmlDataSource
extends AbstractXmlDataSource<JaxenXmlDataSource> {
    private Document document;
    private String selectExpression;
    private NodeList nodeList;
    private int nodeListLength;
    private Node currentNode;
    private int currentNodeIndex = -1;
    private final JaxenNsAwareXPathExecuter xPathExecuter = new JaxenNsAwareXPathExecuter();
    private final JRXmlDocumentProducer documentProducer;
    private boolean mustBeMovedFirst;

    public JaxenXmlDataSource(Document document) throws JRException {
        this(document, ".");
    }

    public JaxenXmlDataSource(Document document, String selectExpression) throws JRException {
        this.document = document;
        this.selectExpression = selectExpression;
        this.documentProducer = new JRXmlDocumentProducer();
        this.mustBeMovedFirst = true;
    }

    public JaxenXmlDataSource(InputStream in) throws JRException {
        this(in, ".");
    }

    public JaxenXmlDataSource(InputStream in, String selectExpression) throws JRException {
        this.selectExpression = selectExpression;
        this.documentProducer = new JRXmlDocumentProducer(in);
        this.mustBeMovedFirst = true;
    }

    public JaxenXmlDataSource(String uri) throws JRException {
        this(uri, ".");
    }

    public JaxenXmlDataSource(String uri, String selectExpression) throws JRException {
        this.selectExpression = selectExpression;
        this.documentProducer = new JRXmlDocumentProducer(uri);
        this.mustBeMovedFirst = true;
    }

    public JaxenXmlDataSource(File file) throws JRException {
        this(file, ".");
    }

    public JaxenXmlDataSource(File file, String selectExpression) throws JRException {
        this.selectExpression = selectExpression;
        this.documentProducer = new JRXmlDocumentProducer(file);
        this.mustBeMovedFirst = true;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void moveFirst() throws JRException {
        if (this.document == null) {
            this.document = this.documentProducer.getDocument();
            if (this.document == null) {
                throw new JRException("data.common.xml.null.document", (Object[])null);
            }
        }
        if (this.selectExpression == null) {
            throw new JRException("data.common.xml.null.select.expression", (Object[])null);
        }
        this.currentNode = null;
        this.currentNodeIndex = -1;
        this.nodeListLength = 0;
        this.nodeList = this.xPathExecuter.selectNodeList(this.document, this.selectExpression);
        this.nodeListLength = this.nodeList.getLength();
    }

    protected void checkMoveFirst() throws JRException {
        if (this.mustBeMovedFirst) {
            this.moveFirst();
            this.mustBeMovedFirst = false;
        }
    }

    @Override
    public boolean next() throws JRException {
        this.checkMoveFirst();
        if (this.currentNodeIndex == this.nodeListLength - 1) {
            return false;
        }
        this.currentNode = this.nodeList.item(++this.currentNodeIndex);
        return true;
    }

    @Override
    public int recordCount() throws JRException {
        this.checkMoveFirst();
        return this.nodeListLength;
    }

    @Override
    public int currentIndex() {
        return this.currentNodeIndex;
    }

    @Override
    public void moveToRecord(int index) throws NoRecordAtIndexException {
        if (index < 0 || index >= this.nodeListLength) {
            throw new NoRecordAtIndexException(index);
        }
        this.currentNodeIndex = index;
        this.currentNode = this.nodeList.item(index);
    }

    @Override
    public Document subDocument() throws JRException {
        if (this.currentNode == null) {
            throw new JRException("data.common.xml.node.not.available", (Object[])null);
        }
        return this.documentProducer.getDocument(this.currentNode);
    }

    public void setXmlNamespaceMap(Map<String, String> xmlNamespaceMap) throws JRException {
        this.xPathExecuter.setXmlNamespaceMap(xmlNamespaceMap);
    }

    public void setDetectXmlNamespaces(boolean detectXmlNamespaces) {
        this.xPathExecuter.setDetectXmlNamespaces(detectXmlNamespaces);
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentProducer.setDocumentBuilderFactory(documentBuilderFactory);
    }

    @Override
    public Node getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public Object getSelectObject(Node currentNode, String expression) throws JRException {
        return this.xPathExecuter.selectObject(currentNode, expression);
    }

    @Override
    public JaxenXmlDataSource subDataSource(String selectExpr) throws JRException {
        Document doc = this.subDocument();
        JaxenXmlDataSource subDataSource = new JaxenXmlDataSource(doc, selectExpr);
        subDataSource.setTextAttributes(this);
        subDataSource.setXmlNamespaceMap(this.xPathExecuter.getXmlNamespaceMap());
        subDataSource.setDetectXmlNamespaces(this.xPathExecuter.getDetectXmlNamespaces());
        subDataSource.setDocumentBuilderFactory(this.documentProducer.getDocumentBuilderFactory());
        return subDataSource;
    }

    @Override
    public JaxenXmlDataSource dataSource(String selectExpr) throws JRException {
        JaxenXmlDataSource subDataSource = new JaxenXmlDataSource(this.document, selectExpr);
        subDataSource.setTextAttributes(this);
        subDataSource.setXmlNamespaceMap(this.xPathExecuter.getXmlNamespaceMap());
        subDataSource.setDetectXmlNamespaces(this.xPathExecuter.getDetectXmlNamespaces());
        subDataSource.setDocumentBuilderFactory(this.documentProducer.getDocumentBuilderFactory());
        return subDataSource;
    }
}

