/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Part {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$methods$multipart$Part != null ? class$org$apache$commons$httpclient$methods$multipart$Part : (class$org$apache$commons$httpclient$methods$multipart$Part = Part.class$("org.apache.commons.httpclient.methods.multipart.Part"))));
    protected static final String BOUNDARY = "----------------314159265358979323846";
    protected static final byte[] BOUNDARY_BYTES = HttpConstants.getAsciiBytes("----------------314159265358979323846");
    protected static final String CRLF = "\r\n";
    protected static final byte[] CRLF_BYTES = HttpConstants.getAsciiBytes("\r\n");
    protected static final String QUOTE = "\"";
    protected static final byte[] QUOTE_BYTES = HttpConstants.getAsciiBytes("\"");
    protected static final String EXTRA = "--";
    protected static final byte[] EXTRA_BYTES = HttpConstants.getAsciiBytes("--");
    protected static final String CONTENT_DISPOSITION = "Content-Disposition: form-data; name=";
    protected static final byte[] CONTENT_DISPOSITION_BYTES = HttpConstants.getAsciiBytes("Content-Disposition: form-data; name=");
    protected static final String CONTENT_TYPE = "Content-Type: ";
    protected static final byte[] CONTENT_TYPE_BYTES = HttpConstants.getAsciiBytes("Content-Type: ");
    protected static final String CHARSET = "; charset=";
    protected static final byte[] CHARSET_BYTES = HttpConstants.getAsciiBytes("; charset=");
    protected static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding: ";
    protected static final byte[] CONTENT_TRANSFER_ENCODING_BYTES = HttpConstants.getAsciiBytes("Content-Transfer-Encoding: ");
    static /* synthetic */ Class class$org$apache$commons$httpclient$methods$multipart$Part;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static String getBoundary() {
        return BOUNDARY;
    }

    public abstract String getCharSet();

    public abstract String getContentType();

    public static long getLengthOfParts(Part[] parts) throws IOException {
        LOG.trace((Object)"getLengthOfParts(Parts[])");
        if (parts == null) {
            throw new IllegalArgumentException("Parts may not be null");
        }
        long total = 0L;
        int i = 0;
        while (i < parts.length) {
            total += parts[i].length();
            ++i;
        }
        total += (long)EXTRA_BYTES.length;
        total += (long)BOUNDARY_BYTES.length;
        total += (long)EXTRA_BYTES.length;
        return total += (long)CRLF_BYTES.length;
    }

    public abstract String getName();

    public abstract String getTransferEncoding();

    public long length() throws IOException {
        LOG.trace((Object)"enter length()");
        ByteArrayOutputStream overhead = new ByteArrayOutputStream();
        this.sendStart(overhead);
        this.sendDispositionHeader(overhead);
        this.sendContentTypeHeader(overhead);
        this.sendTransferEncodingHeader(overhead);
        this.sendEndOfHeader(overhead);
        this.sendEnd(overhead);
        return (long)overhead.size() + this.lengthOfData();
    }

    protected abstract long lengthOfData() throws IOException;

    public void send(OutputStream out) throws IOException {
        LOG.trace((Object)"enter send(OutputStream out)");
        this.sendStart(out);
        this.sendDispositionHeader(out);
        this.sendContentTypeHeader(out);
        this.sendTransferEncodingHeader(out);
        this.sendEndOfHeader(out);
        this.sendData(out);
        this.sendEnd(out);
    }

    protected void sendContentTypeHeader(OutputStream out) throws IOException {
        LOG.trace((Object)"enter sendContentTypeHeader(OutputStream out)");
        String contentType = this.getContentType();
        if (contentType != null) {
            out.write(CRLF_BYTES);
            out.write(CONTENT_TYPE_BYTES);
            out.write(HttpConstants.getAsciiBytes(contentType));
            String charSet = this.getCharSet();
            if (charSet != null) {
                out.write(CHARSET_BYTES);
                out.write(HttpConstants.getAsciiBytes(charSet));
            }
        }
    }

    protected abstract void sendData(OutputStream var1) throws IOException;

    protected void sendDispositionHeader(OutputStream out) throws IOException {
        LOG.trace((Object)"enter sendDispositionHeader(OutputStream out)");
        out.write(CONTENT_DISPOSITION_BYTES);
        out.write(QUOTE_BYTES);
        out.write(HttpConstants.getAsciiBytes(this.getName()));
        out.write(QUOTE_BYTES);
    }

    protected void sendEnd(OutputStream out) throws IOException {
        LOG.trace((Object)"enter sendEnd(OutputStream out)");
        out.write(CRLF_BYTES);
    }

    protected void sendEndOfHeader(OutputStream out) throws IOException {
        LOG.trace((Object)"enter sendEndOfHeader(OutputStream out)");
        out.write(CRLF_BYTES);
        out.write(CRLF_BYTES);
    }

    public static void sendParts(OutputStream out, Part[] parts) throws IOException {
        LOG.trace((Object)"enter sendParts(OutputStream out, Parts[])");
        if (parts == null) {
            throw new IllegalArgumentException("Parts may not be null");
        }
        int i = 0;
        while (i < parts.length) {
            parts[i].send(out);
            ++i;
        }
        out.write(EXTRA_BYTES);
        out.write(BOUNDARY_BYTES);
        out.write(EXTRA_BYTES);
        out.write(CRLF_BYTES);
    }

    protected void sendStart(OutputStream out) throws IOException {
        LOG.trace((Object)"enter sendStart(OutputStream out)");
        out.write(EXTRA_BYTES);
        out.write(BOUNDARY_BYTES);
        out.write(CRLF_BYTES);
    }

    protected void sendTransferEncodingHeader(OutputStream out) throws IOException {
        LOG.trace((Object)"enter sendTransferEncodingHeader(OutputStream out)");
        String transferEncoding = this.getTransferEncoding();
        if (transferEncoding != null) {
            out.write(CRLF_BYTES);
            out.write(CONTENT_TRANSFER_ENCODING_BYTES);
            out.write(HttpConstants.getAsciiBytes(transferEncoding));
        }
    }

    public String toString() {
        return this.getName();
    }
}

